/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import de.wilke.wizepanel.core.displays.Display;
import java.io.ByteArrayInputStream;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WpDisplayUtils {
    private static final List<Display> m_displays = new LinkedList<Display>();

    private WpDisplayUtils() {
    }

    public static Display getDisplay(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split("x", 4);
        if (stringArray.length < 3) {
            return null;
        }
        String string2 = stringArray.length == 4 ? stringArray[3] : "WizePanel";
        try {
            return new Display(string2, Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static List<Display> getDisplays() {
        return m_displays;
    }

    public static boolean isValidType(String string) {
        for (Display display : m_displays) {
            if (!display.toString().equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void read_config_file_stream(String string) {
        try {
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName("Display");
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string2 = namedNodeMap.getNamedItem("type").getTextContent();
                String string3 = namedNodeMap.getNamedItem("name").getTextContent();
                String string4 = namedNodeMap.getNamedItem("description").getTextContent();
                Display display = WpDisplayUtils.getDisplay(string2);
                if (display == null) continue;
                display.setTitle(string3);
                display.setDescription(string4);
                m_displays.add(display);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

