/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import de.wilke.wizepanel.core.WpCore;
import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WpFileUtils {
    public static final String WP_SHELL_VAR_PREFIX_SEPARATOR = ":";
    public static final String WP_SHELL_VAR_PREFIX_ENV_VAR = "env_var";
    public static final String WP_SHELL_VAR_PREFIX_WP_PROP = "wp_prop";

    public static void copyFile(WpFile wpFile, WpFile wpFile2) throws IOException {
        WpFileUtils.copyFile(wpFile.getJavaFile(), wpFile2.getJavaFile());
    }

    public static void copyFile(File file, File file2) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);
             FileOutputStream fileOutputStream = new FileOutputStream(file2);){
            FileChannel fileChannel = fileInputStream.getChannel();
            FileChannel fileChannel2 = fileOutputStream.getChannel();
            int n = 67076096;
            long l = fileChannel.size();
            for (long i = 0L; i < l; i += fileChannel.transferTo(i, n, fileChannel2)) {
            }
        }
    }

    public static void moveFile(File file, File file2) throws IOException {
        WpFileUtils.copyFile(file, file2);
        if (!file.delete()) {
            file2.delete();
            throw new IOException("Could not delete source");
        }
    }

    public static File getAbsoluteFileExt(String string) {
        File file = new File(string);
        if (file.isAbsolute()) {
            return file;
        }
        String string2 = WpFileUtils.expandPathPlaceholders(string);
        File file2 = new File(string2);
        if (file2.isAbsolute()) {
            return file2;
        }
        String string3 = WpCore.homeDir() + File.separator + string2;
        return new File(string3);
    }

    public static String expandPathPlaceholders(String string) {
        Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        boolean bl2 = false;
        do {
            bl = false;
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                String string3 = matcher.group(1);
                String string4 = null;
                int n = string3.indexOf(WP_SHELL_VAR_PREFIX_SEPARATOR);
                if (n >= 0) {
                    if (string3.indexOf(WP_SHELL_VAR_PREFIX_ENV_VAR) >= 0) {
                        string4 = System.getenv(string3.substring(n + 1));
                    }
                    if (string3.indexOf(WP_SHELL_VAR_PREFIX_WP_PROP) >= 0) {
                        string4 = WpSystemLocator.getLocator().getProperty(string3.substring(n + 1));
                    }
                } else {
                    string4 = System.getenv(string3);
                }
                if (string4 == null) {
                    string4 = "";
                }
                string4 = string4.replace(File.separatorChar, '/');
                matcher.appendReplacement(stringBuffer, string4);
                bl = true;
            }
            if (bl || !bl && !bl2) {
                matcher.appendTail(stringBuffer);
                bl2 = true;
            }
            string2 = stringBuffer.toString();
        } while (bl);
        return stringBuffer.toString();
    }

    public static String readTextFile(File file) {
        return WpFileUtils.readTextFile(file, Charset.forName("UTF-8"));
    }

    public static String readTextFile(File file, Charset charset) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
            object = new BufferedReader(inputStreamReader);
            try {
                int n;
                while ((n = ((Reader)object).read()) > -1) {
                    stringBuffer.append((char)n);
                }
            }
            finally {
                ((Reader)object).close();
            }
            object = stringBuffer.toString();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                return null;
            }
        }
        fileInputStream.close();
        return object;
    }

    public static boolean writeTextToFile(String string, String string2) {
        return WpFileUtils.writeTextToFile(new File(string), string2, Charset.forName("UTF-8"));
    }

    public static boolean writeTextToFile(File file, String string) {
        return WpFileUtils.writeTextToFile(file, string, Charset.forName("UTF-8"));
    }

    private static boolean writeTextToFile(File file, String string, Charset charset) {
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), charset));
            bufferedWriter.append(string);
            ((Writer)bufferedWriter).flush();
            ((Writer)bufferedWriter).close();
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public static String getExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        if (n > 0 && n < string.length() - 1) {
            string2 = string.substring(n + 1).toLowerCase();
        }
        return string2;
    }

    public static String getBasename(String string) {
        String string2 = WpFileUtils.getExtension(string);
        return string.substring(0, string.length() - string2.length() - 1);
    }

    public static boolean isPath(String string) {
        return string.contains("/") || string.contains("\\");
    }

    public static boolean deleteFile(String string) {
        File file = new File(string);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    private static String generate_unique_filename(String string) {
        Object object = string;
        String string2 = WpFileUtils.getBasename(string);
        String string3 = WpFileUtils.getExtension(string);
        while (new File((String)object).exists()) {
            object = string2 + "_" + UUID.randomUUID().toString().substring(0, 8) + "." + string3;
        }
        return object;
    }

    /*
     * Exception decompiling
     */
    public static File getUniqueFile(String var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void deleteDirectory(File file) throws IOException {
        if (file.isDirectory()) {
            for (File file2 : file.listFiles()) {
                WpFileUtils.deleteDirectory(file2);
            }
        }
        if (!file.delete()) {
            throw new FileNotFoundException("Failed to delete file: " + file.getAbsolutePath());
        }
    }

    public static String downloadFile(String string, Charset charset) throws Exception {
        URL uRL = new URL(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(uRL.openStream());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[1024];
        int n = 0;
        while (-1 != (n = ((InputStream)bufferedInputStream).read(byArray))) {
            byteArrayOutputStream.write(byArray, 0, n);
        }
        byteArrayOutputStream.close();
        ((InputStream)bufferedInputStream).close();
        if (charset != null) {
            return new String(byteArrayOutputStream.toByteArray(), charset);
        }
        return new String(byteArrayOutputStream.toByteArray());
    }

    public static boolean isWeb(String string) {
        try {
            URL uRL = new URL(string);
            return uRL.getProtocol().equalsIgnoreCase("http") || uRL.getProtocol().equalsIgnoreCase("https");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
    }
}

