/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.Vector;
import javax.imageio.ImageIO;

public class WpGraphicsUtils {
    private static final byte[] gray_4bit_rgb = new byte[]{0, 17, 34, 51, 68, 85, 102, 119, -120, -103, -86, -69, -52, -35, -18, -1};
    private static final IndexColorModel gray_4bit_color_model = new IndexColorModel(4, 16, gray_4bit_rgb, gray_4bit_rgb, gray_4bit_rgb);

    public static BufferedImage scaleImageExt(BufferedImage bufferedImage, int n, int n2, Object object, int n3, boolean bl) {
        int n4;
        int n5;
        BufferedImage bufferedImage2 = bufferedImage;
        if (bl) {
            n5 = bufferedImage.getWidth();
            n4 = bufferedImage.getHeight();
        } else {
            n5 = n;
            n4 = n2;
        }
        do {
            BufferedImage bufferedImage3;
            if (bl && n5 > n && (n5 /= 2) < n) {
                n5 = n;
            }
            if (bl && n4 > n2 && (n4 /= 2) < n2) {
                n4 = n2;
            }
            bufferedImage2 = bufferedImage3 = WpGraphicsUtils.scaleImage(bufferedImage2, n5, n4, object, n3);
        } while (n5 != n || n4 != n2);
        return bufferedImage2;
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2, Object object, int n3) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage scaleImage(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType());
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static boolean scaleFileImage(String string, String string2, int n, int n2) {
        boolean bl = false;
        WpFile wpFile = new WpFile(string);
        if (wpFile.exists()) {
            try {
                BufferedImage bufferedImage = ImageIO.read(wpFile.getJavaFile());
                int n3 = bufferedImage.getWidth();
                int n4 = bufferedImage.getHeight();
                Point2D.Double double_ = WpGraphicsUtils.calcScaledSize(n3, n4, n, n2);
                BufferedImage bufferedImage2 = WpGraphicsUtils.scaleImage(bufferedImage, (int)double_.getX(), (int)double_.getY(), RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, 12);
                ImageIO.write((RenderedImage)bufferedImage2, WpFileUtils.getExtension(string2), new WpFile(string2).getJavaFile());
                bl = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    private static Point2D.Double calcScaledSize(int n, int n2, int n3, int n4) {
        double d = n3;
        double d2 = n4;
        double d3 = n2;
        double d4 = n;
        if (d3 > d4) {
            d4 = d4 * d2 / d3;
            d3 = d2;
        } else {
            d3 = d3 * d / d4;
            d4 = d;
        }
        return new Point2D.Double(d4, d3);
    }

    public static BufferedImage to4bitGrayscale(BufferedImage bufferedImage, Color color) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12, gray_4bit_color_model);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(bufferedImage, 0, 0, color, null);
        return bufferedImage2;
    }

    public static BufferedImage to1bit(BufferedImage bufferedImage, Color color) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 12);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(bufferedImage, 0, 0, color, null);
        return bufferedImage2;
    }

    public static Vector<String> grayColors() {
        Vector<String> vector = new Vector<String>(gray_4bit_rgb.length);
        for (byte by : gray_4bit_rgb) {
            vector.add(String.format("#%02X%02X%02X", by, by, by));
        }
        return vector;
    }

    public static BufferedImage autoRotate(int n, BufferedImage bufferedImage) throws Exception {
        if (bufferedImage.getHeight() > bufferedImage.getWidth()) {
            if (n != 90 && n != 270) {
                n = 90;
            }
        } else if (n != 180) {
            n = 0;
        }
        if (n == 0) {
            return bufferedImage;
        }
        if (n == 90) {
            n = 270;
        } else if (n == 270) {
            n = 90;
        }
        return WpGraphicsUtils.rotate(n, bufferedImage);
    }

    public static BufferedImage rotate(int n, BufferedImage bufferedImage) throws Exception {
        int n2;
        int n3;
        if (n == 0) {
            return bufferedImage;
        }
        if (n != 90 && n != 180 && n != 270) {
            throw new Exception("Wrong angle");
        }
        if (n == 180) {
            n3 = bufferedImage.getWidth();
            n2 = bufferedImage.getHeight();
        } else {
            n3 = bufferedImage.getHeight();
            n2 = bufferedImage.getWidth();
        }
        BufferedImage bufferedImage2 = bufferedImage.getColorModel() instanceof IndexColorModel ? new BufferedImage(n3, n2, bufferedImage.getType(), (IndexColorModel)bufferedImage.getColorModel()) : new BufferedImage(n3, n2, bufferedImage.getType());
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.rotate(Math.toRadians(n));
        switch (n) {
            case 90: {
                graphics2D.drawImage((Image)bufferedImage, 0, -n3, null);
                break;
            }
            case 180: {
                graphics2D.drawImage((Image)bufferedImage, -n3, -n2, null);
                break;
            }
            case 270: {
                graphics2D.drawImage((Image)bufferedImage, -n2, 0, null);
            }
        }
        graphics2D.dispose();
        return bufferedImage2;
    }

    public static BufferedImage scale(BufferedImage bufferedImage, int n, int n2) {
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, bufferedImage.getType(), (IndexColorModel)bufferedImage.getColorModel());
        Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        return bufferedImage2;
    }
}

