/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.AdapterManagerUpdater;
import de.wilke.wizepanel.core.adapters.AdaptersChangeListener;
import de.wilke.wizepanel.core.adapters.AscTimeTablesAdapter;
import de.wilke.wizepanel.core.adapters.CsvAdapter;
import de.wilke.wizepanel.core.adapters.DEAEMSAdapter;
import de.wilke.wizepanel.core.adapters.EnergySaverAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeEMailAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeEWSAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeEWSOnlineAdapter;
import de.wilke.wizepanel.core.adapters.ExchangeGraphAdapter;
import de.wilke.wizepanel.core.adapters.GoogleCalendarAdapter;
import de.wilke.wizepanel.core.adapters.HttpGeneralAdapter;
import de.wilke.wizepanel.core.adapters.ICalendarAdapter;
import de.wilke.wizepanel.core.adapters.RawAdapter;
import de.wilke.wizepanel.core.adapters.SystemMonitorAdapter;
import de.wilke.wizepanel.core.adapters.WebUntisAdapter;
import de.wilke.wizepanel.core.adapters.WilkeSimpleEventsAdapter;
import de.wilke.wizepanel.core.adapters.XMLAdapter;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AdapterManager {
    protected List<AbstractAdapterConfiguration> m_adapters = null;
    private static final String CFG_KEY_ADAPTERS = "adapters";
    private final Map<String, Class<? extends AbstractAdapterConfiguration>> m_valid_adapter_types = new LinkedHashMap<String, Class<? extends AbstractAdapterConfiguration>>();
    private final Set<AdaptersChangeListener> m_change_listeners = new HashSet<AdaptersChangeListener>();

    protected AdapterManager() {
        this.m_valid_adapter_types.put("ms-email", ExchangeEMailAdapter.class);
        this.m_valid_adapter_types.put("ms-ews", ExchangeEWSAdapter.class);
        this.m_valid_adapter_types.put("ms-ews-online", ExchangeEWSOnlineAdapter.class);
        this.m_valid_adapter_types.put("ms-exchange-graph", ExchangeGraphAdapter.class);
        this.m_valid_adapter_types.put("google-calendar", GoogleCalendarAdapter.class);
        this.m_valid_adapter_types.put("csv", CsvAdapter.class);
        this.m_valid_adapter_types.put("xml", XMLAdapter.class);
        this.m_valid_adapter_types.put("icalendar", ICalendarAdapter.class);
        this.m_valid_adapter_types.put("http-general", HttpGeneralAdapter.class);
        this.m_valid_adapter_types.put("dea-ems", DEAEMSAdapter.class);
        this.m_valid_adapter_types.put("asc-timetables", AscTimeTablesAdapter.class);
        this.m_valid_adapter_types.put("webuntis", WebUntisAdapter.class);
        this.m_valid_adapter_types.put("wilke-simple-events", WilkeSimpleEventsAdapter.class);
        this.m_valid_adapter_types.put("energy-saver", EnergySaverAdapter.class);
        this.m_valid_adapter_types.put("system-monitor", SystemMonitorAdapter.class);
    }

    public Set<String> getAdapterTypes() {
        return this.m_valid_adapter_types.keySet();
    }

    public void debug(String string) {
    }

    public List<AbstractAdapterConfiguration> getEnabledAdapters(LicenseManager licenseManager) {
        return this.getAllAdapters(true);
    }

    public synchronized List<AbstractAdapterConfiguration> getAllAdapters() {
        return this.getAllAdapters(false);
    }

    public synchronized List<AbstractAdapterConfiguration> getAllAdapters(boolean bl) {
        if (this.m_adapters == null) {
            this.read_config();
        }
        LinkedList<AbstractAdapterConfiguration> linkedList = new LinkedList<AbstractAdapterConfiguration>();
        if (this.m_adapters != null) {
            for (AbstractAdapterConfiguration abstractAdapterConfiguration : this.m_adapters) {
                if (abstractAdapterConfiguration instanceof CsvAdapter && abstractAdapterConfiguration.isEnabled() && AdapterManagerUpdater.import_csv_format_file((CsvAdapter)abstractAdapterConfiguration)) {
                    this.save();
                }
                if (!abstractAdapterConfiguration.isEnabled()) continue;
                linkedList.add(abstractAdapterConfiguration);
            }
        }
        if (bl) {
            return linkedList;
        }
        return this.m_adapters;
    }

    public AbstractAdapterConfiguration getAdapterByName(LicenseManager licenseManager, String string) {
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : this.getAllAdapters()) {
            if (!abstractAdapterConfiguration.getName().equals(string)) continue;
            return abstractAdapterConfiguration;
        }
        return null;
    }

    public AbstractAdapterConfiguration createNewAdapter(String string, AbstractAdapterConfiguration abstractAdapterConfiguration) {
        try {
            Class<? extends AbstractAdapterConfiguration> clazz = this.m_valid_adapter_types.get(string);
            if (clazz == null) {
                return null;
            }
            Constructor<? extends AbstractAdapterConfiguration> constructor = clazz.getConstructor(String.class);
            AbstractAdapterConfiguration abstractAdapterConfiguration2 = constructor.newInstance(abstractAdapterConfiguration == null ? "" : abstractAdapterConfiguration.getName());
            if (abstractAdapterConfiguration != null) {
                abstractAdapterConfiguration2.importRawData(abstractAdapterConfiguration.getData());
                if (!abstractAdapterConfiguration2.validate()) {
                    return null;
                }
            }
            return abstractAdapterConfiguration2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public synchronized void addChangeListener(AdaptersChangeListener adaptersChangeListener) {
        this.m_change_listeners.add(adaptersChangeListener);
    }

    public synchronized void removeChangeListener(AdaptersChangeListener adaptersChangeListener) {
        this.m_change_listeners.remove(adaptersChangeListener);
    }

    protected abstract void save();

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        JSONObject jSONObject2 = new JSONObject();
        jSONObject.put(CFG_KEY_ADAPTERS, (Object)jSONObject2);
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : this.getAllAdapters(false)) {
            JSONObject jSONObject3 = new JSONObject();
            jSONObject2.put(abstractAdapterConfiguration.getName(), (Object)jSONObject3);
            Map<String, String> map = abstractAdapterConfiguration.getData();
            Iterator<String> iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                String string;
                String string2 = map.get(string = iterator.next());
                jSONObject3.put(string, (Object)(string2 == null ? "" : string2));
            }
        }
        return jSONObject;
    }

    protected abstract void read_config();

    protected boolean read_json_conf(String string) {
        this.m_adapters = new LinkedList<AbstractAdapterConfiguration>();
        try {
            Object object;
            HashMap<String, String> hashMap;
            JSONObject jSONObject = new JSONObject(string);
            HashMap<String, HashMap<String, String>> hashMap2 = new HashMap<String, HashMap<String, String>>();
            JSONObject jSONObject2 = jSONObject.getJSONObject(CFG_KEY_ADAPTERS);
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                hashMap = new HashMap();
                object = jSONObject2.getJSONObject(string2);
                Iterator iterator2 = object.keys();
                while (iterator2.hasNext()) {
                    String string3 = iterator2.next().toString();
                    hashMap.put(string3, object.getString(string3));
                }
                hashMap2.put(string2, hashMap);
            }
            for (String string2 : hashMap2.keySet()) {
                hashMap = (Map)hashMap2.get(string2);
                object = new RawAdapter(string2);
                ((AbstractAdapterConfiguration)object).importRawData(hashMap);
                object = this.createNewAdapter(((AbstractAdapterConfiguration)object).getType(), (AbstractAdapterConfiguration)object);
                if (object != null) {
                    this.m_adapters.add((AbstractAdapterConfiguration)object);
                    continue;
                }
                this.debug("validation failed for adapter: " + string2);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return false;
        }
        return true;
    }

    protected void invalidate() {
        this.m_adapters = null;
        this.inform_all_change_listeners();
    }

    protected void inform_all_change_listeners() {
        for (AdaptersChangeListener adaptersChangeListener : this.m_change_listeners) {
            adaptersChangeListener.changed();
        }
    }
}

