/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class DEAEMSAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "dea-ems";
    public static final String OPTION_IGNORE_ALARM = "ignore-alarm";
    public static final String OPTION_PRIVATE_EVENT_QUALIFIERS = "private-event-qualifiers";
    public static final String OPTION_PRIVATE_EVENT_SUMMARY = "private-event-summary";
    public static final String OPTION_SOAP1_2 = "soap-1-2";
    public static final String ID_ROOM_SEP = ":";
    public static final String PLACEHOLDER_ROOM_DESCRIPTION = "RoomDescription";
    public static final String PLACEHOLDER_GROUP_NAME = "GroupName";
    public static final String PLACEHOLDER_GROUP_TYPE_DESCRIPTION = "GroupTypeDescription";
    public static final String PLACEHOLDER_ROOM = "Room";
    public static final String PLACEHOLDER_BUILDING = "Building";

    public DEAEMSAdapter(String string) {
        super(string, TYPE);
        this.setIgnoreAlarm(false);
        this.setPrivateEventQualifiers(new LinkedList<String>());
        this.setPrivateEventSummary("");
    }

    @Override
    public List<String> targets() {
        return this.getDataAsList("calendars");
    }

    public void setRooms(List<String> list) {
        this.setData("calendars", list);
    }

    public String server() {
        return this.getDataAsString("server");
    }

    public void setServer(String string) {
        this.setData("server", string);
    }

    public String user() {
        return this.getDataAsString("user");
    }

    public void setUser(String string) {
        this.setData("user", string);
    }

    public void setIgnoreAlarm(boolean bl) {
        this.setData(OPTION_IGNORE_ALARM, bl);
    }

    public void setSoap1_2(boolean bl) {
        this.setData(OPTION_SOAP1_2, bl);
    }

    public boolean ignoreAlarm() {
        return this.getDataAsBoolean(OPTION_IGNORE_ALARM, false);
    }

    public boolean soap1_2() {
        return this.getDataAsBoolean(OPTION_SOAP1_2, false);
    }

    public void setPrivateEventQualifiers(List<String> list) {
        this.setData(OPTION_PRIVATE_EVENT_QUALIFIERS, list);
    }

    public List<String> privateEventQualifiers() {
        return this.getDataAsList(OPTION_PRIVATE_EVENT_QUALIFIERS);
    }

    public void setPrivateEventSummary(String string) {
        this.setData(OPTION_PRIVATE_EVENT_SUMMARY, string);
    }

    public String privateEventSummary() {
        return this.getDataAsString(OPTION_PRIVATE_EVENT_SUMMARY);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_DEA_EMS;
    }

    @Override
    public int requiredLicenseCount() {
        List<String> list = this.targets();
        return list != null ? list.size() : 0;
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("URL", this.server());
        treeMap.put("User", this.user());
        treeMap.put("Ignore Alarm", this.ignoreAlarm());
        treeMap.put("Private Event Summary", this.privateEventSummary());
        String string = "1.1";
        if (this.soap1_2()) {
            string = "1.2";
        }
        treeMap.put("SOAP Version", string);
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : this.targets()) {
            linkedList.add(string2);
        }
        treeMap.put("Rooms", WpUtils.implode(", ", linkedList));
        return treeMap;
    }

    @Override
    public String getDescription() {
        return "DEA Event Management System (EMS)";
    }

    public static String createSaveableIDRoomTag(String string, String string2) {
        return string + ID_ROOM_SEP + string2.replace(ID_ROOM_SEP, "");
    }

    public static String extractID(String string) {
        String[] stringArray = string.split(ID_ROOM_SEP, 2);
        return stringArray[0];
    }

    @Override
    public List<String> placeholders() {
        List<String> list = super.placeholders();
        list.add(PLACEHOLDER_ROOM_DESCRIPTION);
        list.add(PLACEHOLDER_GROUP_NAME);
        list.add(PLACEHOLDER_GROUP_TYPE_DESCRIPTION);
        list.add(PLACEHOLDER_ROOM);
        list.add(PLACEHOLDER_BUILDING);
        return list;
    }
}

