/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EnergySaverAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "energy-saver";
    public static final String OPTION_TIME_FROM = "time_from";
    public static final String OPTION_TIME_TO = "time_to";
    public static final String OPTION_SLEEP_TIME = "sleep-time";

    public EnergySaverAdapter(String string) {
        super(string, TYPE);
        this.setTime(18, 6);
        this.setSleepTime(3600);
    }

    private void setSleepTime(int n) {
        this.setData(OPTION_SLEEP_TIME, n);
    }

    public int sleepTime() {
        return this.getDataAsNumber(OPTION_SLEEP_TIME, 3600);
    }

    public void setTime(int n, int n2) {
        this.setData(OPTION_TIME_FROM, n);
        this.setData(OPTION_TIME_TO, n2);
    }

    public int getTimeFrom() {
        return this.getDataAsNumber(OPTION_TIME_FROM, 18);
    }

    public int getTimeTo() {
        return this.getDataAsNumber(OPTION_TIME_TO, 6);
    }

    public List<String> rooms() {
        return this.getDataAsList("calendars");
    }

    public void setRooms(String[] stringArray) {
        this.setData("calendars", stringArray);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_BA;
    }

    @Override
    public String getDescription() {
        return "Energy Saver";
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("From", this.getTimeFrom());
        treeMap.put("To", this.getTimeTo());
        treeMap.put("Rooms", WpUtils.implode(", ", this.rooms()));
        return treeMap;
    }

    @Override
    public List<String> placeholders() {
        return null;
    }
}

