/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class ExchangeGraphAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "ms-exchange-graph";
    public static final String OPTION_IGNORE_ALARM = "ignore-alarm";
    public static final String OPTION_PRIVATE_EVENT_SUMMARY = "private-event-summary";

    public ExchangeGraphAdapter(String string) {
        super(string, TYPE);
        this.setIgnoreAlarm(false);
        this.setPrivateEventSummary("");
    }

    public String clientId() {
        return this.getDataAsString("server");
    }

    public void setClientId(String string) {
        this.setData("server", string);
    }

    public String tenantId() {
        return this.getDataAsString("user");
    }

    public void setTenantId(String string) {
        this.setData("user", string);
    }

    @Override
    public List<String> targets() {
        return this.getDataAsList("calendars");
    }

    public void setCalendars(String[] stringArray) {
        this.setData("calendars", stringArray);
    }

    public void setPrivateEventSummary(String string) {
        this.setData(OPTION_PRIVATE_EVENT_SUMMARY, string);
    }

    public String privateEventSummary() {
        return this.getDataAsString(OPTION_PRIVATE_EVENT_SUMMARY);
    }

    public void setIgnoreAlarm(boolean bl) {
        this.setData(OPTION_IGNORE_ALARM, bl);
    }

    public boolean ignoreAlarm() {
        return this.getDataAsBoolean(OPTION_IGNORE_ALARM, false);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_EXGRAPH;
    }

    @Override
    public int requiredLicenseCount() {
        List<String> list = this.targets();
        return list != null ? list.size() : 0;
    }

    @Override
    public Map<String, Object> details() {
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        treeMap.put("Client-Id", this.clientId());
        treeMap.put("Tenant-Id", this.tenantId());
        treeMap.put("Calendars", WpUtils.implode(", ", this.targets()));
        return treeMap;
    }

    @Override
    public String getDescription() {
        return "MS Exchange (Graph) / Outlook";
    }

    @Override
    public List<String> placeholders() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("DTSTART");
        linkedList.add("DTEND");
        linkedList.add("SUMMARY");
        linkedList.add("DESCRIPTION");
        linkedList.add("LOCATION");
        linkedList.add("CREATOR");
        return linkedList;
    }
}

