/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemMonitorAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "system-monitor";
    public static final String OPTION_SUMMARY_REPORT_HOURS = "summary-report-hours";
    public static final String OPTION_USE_SSL = "use-ssl";
    public static final String OPTION_INCLUDE_WARNINGS = "include-warnings";
    public static final String OPTION_REPORT_ERRORS_IMMEDIATELY = "report-errors-immediately";

    public SystemMonitorAdapter(String string) {
        super(string, TYPE);
        this.setSummaryTime(10);
        this.useSSL(true);
        this.includeWarnings(true);
        this.reportErrorsImmediately(true);
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_BA;
    }

    @Override
    public String getDescription() {
        return "System Monitor";
    }

    @Override
    public Map<String, Object> details() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("SMTP", this.server());
        hashMap.put("User", this.user());
        hashMap.put("To", WpUtils.implode(", ", this.to()));
        return hashMap;
    }

    public String server() {
        return this.getDataAsString("server");
    }

    public void setServer(String string) {
        this.setData("server", string);
    }

    public String user() {
        return this.getDataAsString("user");
    }

    public void setUser(String string) {
        this.setData("user", string);
    }

    public List<String> to() {
        return this.getDataAsList("calendars");
    }

    public void setTo(List<String> list) {
        this.setData("calendars", list);
    }

    public void setSummaryTime(int n) {
        this.setData(OPTION_SUMMARY_REPORT_HOURS, n);
    }

    public void useSSL(boolean bl) {
        this.setData(OPTION_USE_SSL, bl);
    }

    public boolean useSSL() {
        return this.getDataAsBoolean(OPTION_USE_SSL, true);
    }

    public void includeWarnings(boolean bl) {
        this.setData(OPTION_INCLUDE_WARNINGS, bl);
    }

    public boolean includeWarnings() {
        return this.getDataAsBoolean(OPTION_INCLUDE_WARNINGS, true);
    }

    public void reportErrorsImmediately(boolean bl) {
        this.setData(OPTION_REPORT_ERRORS_IMMEDIATELY, bl);
    }

    public boolean reportErrorsImmediately() {
        return this.getDataAsBoolean(OPTION_REPORT_ERRORS_IMMEDIATELY, true);
    }

    public int summaryTime() {
        return this.getDataAsNumber(OPTION_SUMMARY_REPORT_HOURS, -1);
    }

    @Override
    public List<String> placeholders() {
        return null;
    }
}

