/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.license.LicenseManager;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class XMLAdapter
extends AbstractAdapterConfiguration {
    public static final String TYPE = "xml";
    private static final String OPTION_ROOMS = "rooms";
    private static final String OPTION_DELETE_AFTER_DAYS = "delete_after_days";
    private static final int DEFAULT_DELETE_AFTER_DAYS = 0;
    public static final int DELETE_NEVER = -1;

    public XMLAdapter(String string) {
        super(string, TYPE);
        this.setRooms(new LinkedList<String>());
        this.setDeleteAfterDays(0);
    }

    public String getWatchDir() {
        return this.getDataAsString("server");
    }

    public void setWatchDir(String string) {
        this.setData("server", string);
    }

    @Override
    public List<String> targets() {
        return this.getDataAsList(OPTION_ROOMS);
    }

    public void setRooms(List<String> list) {
        this.setData(OPTION_ROOMS, list);
    }

    public int deleteAfterDays() {
        return this.getDataAsNumber(OPTION_DELETE_AFTER_DAYS, 0);
    }

    public void setDeleteAfterDays(int n) {
        this.setData(OPTION_DELETE_AFTER_DAYS, n);
    }

    @Override
    public boolean allowsSecondsInterval() {
        return true;
    }

    @Override
    public LicenseManager.LicensePackages requiredLicense() {
        return LicenseManager.LicensePackages.WZP_SOFT_XML;
    }

    @Override
    public int requiredLicenseCount() {
        List<String> list = this.targets();
        return list != null ? list.size() : 0;
    }

    @Override
    public Map<String, Object> details() {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("Directory", this.getWatchDir());
        hashMap.put("Sources", WpUtils.implode(", ", this.targets()));
        hashMap.put("DeleteAfterDays", this.deleteAfterDays());
        return hashMap;
    }

    @Override
    public String getDescription() {
        return "XML";
    }

    @Override
    public List<String> placeholders() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("DTSTART");
        linkedList.add("DTEND");
        return linkedList;
    }
}

