/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.adapters.types;

import de.wilke.wizepanel.core.adapters.types.SimpleEventsRoom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleEventsRoomGraph {
    private static final String JSON_ROOMS = "rooms";
    private static final String JSON_ROOM_CONNECTIONS = "connections";
    private static final String JSON_FROM = "from";
    private static final String JSON_TO = "to";
    private Map<SimpleEventsRoom, List<SimpleEventsRoom>> rooms = new HashMap<SimpleEventsRoom, List<SimpleEventsRoom>>();

    public void fromJSON(JSONObject jSONObject) throws JSONException {
        JSONArray jSONArray;
        this.clear();
        JSONArray jSONArray2 = jSONObject.getJSONArray(JSON_ROOMS);
        if (jSONArray2.length() != 0) {
            for (int i = 0; i < jSONArray2.length(); ++i) {
                this.addRoom(jSONArray2.getString(i));
            }
        }
        if ((jSONArray = jSONObject.getJSONArray(JSON_ROOM_CONNECTIONS)).length() != 0) {
            for (int i = 0; i < jSONArray.length(); ++i) {
                JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                String string = jSONObject2.getString(JSON_FROM);
                JSONArray jSONArray3 = jSONObject2.getJSONArray(JSON_TO);
                if (jSONArray3.length() == 0) continue;
                for (int j = 0; j < jSONArray3.length(); ++j) {
                    String string2 = jSONArray3.getString(j);
                    this.addSubRoom(string, string2);
                }
            }
        }
    }

    public JSONObject toJSON() throws JSONException {
        Set<String> set = this.getAllRooms();
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        for (String object : set) {
            jSONArray.put((Object)object);
        }
        jSONObject.put(JSON_ROOMS, (Object)jSONArray);
        JSONArray jSONArray2 = new JSONArray();
        for (String string : set) {
            JSONObject jSONObject2 = new JSONObject();
            jSONObject2.put(JSON_FROM, (Object)string);
            List<SimpleEventsRoom> list = this.getSubRooms(string);
            JSONArray jSONArray3 = new JSONArray();
            for (SimpleEventsRoom simpleEventsRoom : list) {
                jSONArray3.put((Object)simpleEventsRoom.toString());
            }
            jSONObject2.put(JSON_TO, (Object)jSONArray3);
            jSONArray2.put((Object)jSONObject2);
        }
        jSONObject.put(JSON_ROOM_CONNECTIONS, (Object)jSONArray2);
        return jSONObject;
    }

    public void clear() {
        Set<String> set = this.getAllRooms();
        for (String string : set) {
            this.removeRoom(string);
        }
    }

    public void addRoom(String string) {
        this.rooms.putIfAbsent(new SimpleEventsRoom(string), new ArrayList());
    }

    public void removeRoom(String string) {
        SimpleEventsRoom simpleEventsRoom = new SimpleEventsRoom(string);
        for (List<SimpleEventsRoom> list : this.rooms.values()) {
            list.remove(simpleEventsRoom);
        }
        this.rooms.remove(new SimpleEventsRoom(string));
    }

    public void setSubRooms(String string, List<SimpleEventsRoom> list) {
        SimpleEventsRoom simpleEventsRoom = new SimpleEventsRoom(string);
        this.rooms.get(simpleEventsRoom).clear();
        this.rooms.get(simpleEventsRoom).addAll(list);
    }

    public boolean addSubRoom(String string, String string2) {
        SimpleEventsRoom simpleEventsRoom = new SimpleEventsRoom(string);
        SimpleEventsRoom simpleEventsRoom2 = new SimpleEventsRoom(string2);
        if (!this.rooms.containsKey(simpleEventsRoom) || !this.rooms.containsKey(simpleEventsRoom2)) {
            return false;
        }
        if (string.equals(string2)) {
            return false;
        }
        if (this.getAllDescendants(string2).contains(string)) {
            return false;
        }
        if (!this.rooms.get(simpleEventsRoom).contains(simpleEventsRoom2)) {
            this.rooms.get(simpleEventsRoom).add(simpleEventsRoom2);
        }
        return true;
    }

    public void renameRoom(String string, String string2) {
        SimpleEventsRoom simpleEventsRoom = new SimpleEventsRoom(string);
        if (!this.rooms.containsKey(simpleEventsRoom)) {
            return;
        }
        this.addRoom(string2);
        for (String string3 : this.getAllRooms()) {
            if (!this.getSubRooms(string3).contains(simpleEventsRoom)) continue;
            this.addSubRoom(string3, string2);
        }
        this.removeRoom(string);
    }

    public void removeSubRoom(String string, String string2) {
        SimpleEventsRoom simpleEventsRoom = new SimpleEventsRoom(string);
        List<SimpleEventsRoom> list = this.rooms.get(simpleEventsRoom);
        if (list != null) {
            list.remove(new SimpleEventsRoom(string2));
        }
    }

    public List<SimpleEventsRoom> getSubRooms(String string) {
        return this.rooms.get(new SimpleEventsRoom(string));
    }

    String printGraph() {
        StringBuffer stringBuffer = new StringBuffer();
        for (SimpleEventsRoom simpleEventsRoom : this.rooms.keySet()) {
            stringBuffer.append(simpleEventsRoom);
            stringBuffer.append(this.rooms.get(simpleEventsRoom));
        }
        return stringBuffer.toString();
    }

    public Set<String> getAllRooms() {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (SimpleEventsRoom simpleEventsRoom : this.rooms.keySet()) {
            linkedHashSet.add(simpleEventsRoom.toString());
        }
        return linkedHashSet;
    }

    public SimpleEventsRoom createRoom(String string) {
        return new SimpleEventsRoom(string);
    }

    public Set<String> getAllDescendants(String string) {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Stack<String> stack = new Stack<String>();
        List<SimpleEventsRoom> list = this.getSubRooms(string);
        if (list != null) {
            for (SimpleEventsRoom object : list) {
                stack.push(object.label);
            }
            while (!stack.isEmpty()) {
                String string2 = (String)stack.pop();
                if (linkedHashSet.contains(string2)) continue;
                linkedHashSet.add(string2);
                for (SimpleEventsRoom simpleEventsRoom : this.getSubRooms(string2)) {
                    stack.push(simpleEventsRoom.label);
                }
            }
        }
        return linkedHashSet;
    }
}

