/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.app;

import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import java.awt.Cursor;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import javax.swing.ImageIcon;

public class WP {
    public static LinkedList<String> m_langs = null;

    public static String getTemplateFilename(String string) {
        return WpSystemLocator.getLocator().getTemplateDir() + "/" + string;
    }

    public static synchronized LinkedList<String> getLanguages() {
        if (m_langs == null) {
            File[] fileArray = new File(WpSystemLocator.getLocator().getLanguagesDir()).listFiles();
            m_langs = new LinkedList();
            for (int i = 0; i < fileArray.length; ++i) {
                m_langs.add(fileArray[i].getName());
            }
        }
        return m_langs;
    }

    public static String date2str(Date date) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        return simpleDateFormat.format(date);
    }

    public static Date str2date(String string) {
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateTimeInstance(1, 1);
        try {
            return simpleDateFormat.parse(string);
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    public static Cursor getCursor(String string, Point point) {
        try {
            return Toolkit.getDefaultToolkit().createCustomCursor(new ImageIcon(WpSystemLocator.getLocator().getCursorsDir() + "/" + string + ".gif").getImage(), point, string);
        }
        catch (HeadlessException headlessException) {
            return Cursor.getDefaultCursor();
        }
    }

    public static String getImageFilename(String string) {
        return WpSystemLocator.getLocator().getImagesDir() + "/" + string;
    }

    public static void savePreferences(WPApp wPApp, Preferences preferences) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(WpSystemLocator.getLocator().getAppPrefsDir() + "/" + wPApp.getApp() + ".xml");
            preferences.exportNode(fileOutputStream);
        }
        catch (IOException iOException) {
            System.err.println(WPApp.tr("err_settings_save", wPApp.getApp()));
        }
        catch (BackingStoreException backingStoreException) {
            System.err.println(WPApp.tr("err_settings_save", wPApp.getApp()));
        }
    }

    public static void loadPreferences(WPApp wPApp) {
        try {
            FileInputStream fileInputStream = new FileInputStream(WpSystemLocator.getLocator().getAppPrefsDir() + "/" + wPApp.getApp() + ".xml");
            Preferences.importPreferences(fileInputStream);
        }
        catch (IOException iOException) {
            System.err.println(WPApp.tr("err_settings_load", wPApp.getApp()));
        }
        catch (InvalidPreferencesFormatException invalidPreferencesFormatException) {
            System.err.println(WPApp.tr("err_settings_load", wPApp.getApp()));
        }
    }
}

