/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.app;

import de.wilke.wizepanel.core.WPLangUtils;
import de.wilke.wizepanel.core.app.WP;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class WPApp
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static String _app;
    private static String _lang;
    private final Frame _frame;
    private final boolean _embedded;
    private String _title;

    public WPApp(Frame frame, String string, String string2, boolean bl) {
        this._frame = frame;
        _app = string;
        this._embedded = bl;
        _lang = WP.getLanguages().contains(string2) ? string2 : WpSystemLocator.getLocator().getDefaultLanguage();
        UIManager.put("swing.boldMetal", Boolean.FALSE);
    }

    public String getApp() {
        return _app;
    }

    public boolean isEmbedded() {
        return this._embedded;
    }

    public Frame frame() {
        return this._frame;
    }

    public String getTitle() {
        return this._title;
    }

    public void setTitle(String string) {
        this._title = string;
        this._frame.setTitle(string);
    }

    public static String tr(String string) {
        return WPLangUtils.tr(_app, _lang, string);
    }

    public static String getLang() {
        return _lang;
    }

    public static String tr(String string, String ... stringArray) {
        return MessageFormat.format(WPApp.tr(string), stringArray);
    }

    public static ImageIcon getIcon(String string) {
        return new ImageIcon(WP.getImageFilename("/apps/" + _app + "/" + string));
    }

    public static ImageIcon getFactoryIcon(String string) {
        return new ImageIcon(WpSystemLocator.getLocator().getFactoryImagesDir() + "/" + string);
    }

    public static BufferedImage getFactoryImage(String string) {
        try {
            return ImageIO.read(new File(WpSystemLocator.getLocator().getFactoryImagesDir() + "/" + string));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }
}

