/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.displays;

import de.wilke.wizepanel.core.WpGraphicsUtils;
import java.awt.Color;
import java.awt.image.BufferedImage;

public class Display {
    public static final String SEP = "x";
    private String type_string;
    private int color_depth;
    private String title = "";
    private String description = "";
    private Type type = Type.TYPE_CUSTOM;
    private int width;
    private int height;

    public Display(String string, int n, int n2, int n3) {
        this.type_string = string;
        this.setSize(n, n2);
        this.color_depth = n3;
    }

    public Display(int n) {
        this.type = Type.findByID(n);
        this.setSize(this.type.xwidth, this.type.xheight);
    }

    public void setType(int n) {
        this.type = Type.findByID(n);
    }

    public void setSize(int n, int n2) {
        this.type = Type.findBySize(n, n2);
        this.width = n;
        this.height = n2;
    }

    public int getColorDepth() {
        return this.color_depth;
    }

    public void setColorDepth(int n) {
        this.color_depth = n;
    }

    public String toString() {
        return this.width + SEP + this.height + SEP + this.color_depth + SEP + this.type_string;
    }

    public void setTitle(String string) {
        this.title = string == null ? "" : string;
    }

    public String getTitle() {
        return this.title;
    }

    public void setDescription(String string) {
        this.description = string == null ? "" : string;
    }

    public String getDescription() {
        return this.description;
    }

    public Type getType() {
        return this.type;
    }

    public String getTypeDescription() {
        return this.type.description;
    }

    public Color defaultBackground() {
        return Color.WHITE;
    }

    public boolean canBeTransparent() {
        return this.color_depth > 8;
    }

    public boolean equals(Object object) {
        if (object instanceof Display) {
            Display display = (Display)object;
            return display.getWidth() == this.width && display.getHeight() == this.height && display.getColorDepth() == this.color_depth && display.getType() == this.type;
        }
        return super.equals(object);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public boolean isSupportedImage(BufferedImage bufferedImage) {
        return this.isSupportedSize(bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public boolean isSupportedSize(int n, int n2) {
        if (this.getWidth() == -1 || this.getHeight() == -1) {
            return true;
        }
        return this.getWidth() == n && this.getHeight() == n2 || this.getWidth() == n2 && this.getHeight() == n;
    }

    public BufferedImage convert(BufferedImage bufferedImage, int n) {
        if (this.type == Type.TYPE_060_BUDGET) {
            bufferedImage = WpGraphicsUtils.scaleImage(bufferedImage, bufferedImage.getWidth() * 2, bufferedImage.getHeight() * 2);
        }
        if (this.type.available_color_depths == null) {
            return bufferedImage;
        }
        if (!this.type.hasColorDepth(n)) {
            n = this.type.preferredColorDepth();
        }
        switch (n) {
            case 1: {
                return WpGraphicsUtils.to1bit(bufferedImage, this.defaultBackground());
            }
            case 4: {
                return WpGraphicsUtils.to4bitGrayscale(bufferedImage, this.defaultBackground());
            }
        }
        return bufferedImage;
    }

    public boolean isTextAntialiasing() {
        return this.color_depth != 1;
    }

    public static enum Type {
        TYPE_CUSTOM(-1, "custom", -1, -1, true, null, false),
        TYPE_057(0, "5.7\"", 320, 240, false, new int[]{1}, false),
        TYPE_097(1, "9.7\"", 1200, 825, true, new int[]{1, 4}, true),
        TYPE_060(2, "6.0\"", 800, 600, true, new int[]{1, 4}, true),
        TYPE_WIZESCREEN(3, "WIZESCREEN", -1, -1, true, null, false),
        TYPE_060_BUDGET(4, "6.0\" Budget", 400, 300, true, new int[]{1}, true),
        TYPE_060_PLUS(5, "6.0\"+", 1024, 758, true, new int[]{1, 4}, true);

        public final int id;
        public final String description;
        private final int xwidth;
        private final int xheight;
        private final boolean has_data_command;
        public final int[] available_color_depths;
        public final boolean has_display_update_method_command;

        private Type(int n2, String string2, int n3, int n4, boolean bl, int[] nArray, boolean bl2) {
            this.id = n2;
            this.description = string2;
            this.xwidth = n3;
            this.xheight = n4;
            this.has_data_command = bl;
            this.available_color_depths = nArray;
            this.has_display_update_method_command = bl2;
        }

        public static Type findBySize(int n, int n2) {
            for (Type type : Type.values()) {
                if ((type.xwidth != n || type.xheight != n2) && (type.xheight != n || type.xwidth != n2)) continue;
                return type;
            }
            return TYPE_CUSTOM;
        }

        public static Type findByID(int n) {
            for (Type type : Type.values()) {
                if (type.id != n) continue;
                return type;
            }
            return TYPE_CUSTOM;
        }

        public boolean hasColorDepth(int n) {
            if (this.available_color_depths == null) {
                return true;
            }
            for (int n2 : this.available_color_depths) {
                if (n2 != n) continue;
                return true;
            }
            return false;
        }

        public int preferredColorDepth() {
            if (this.available_color_depths != null && this.available_color_depths.length != 0) {
                return this.available_color_depths[0];
            }
            return 1;
        }

        public boolean fixedSize() {
            return this.xwidth != -1 && this.xheight != -1;
        }

        public boolean hasDataCommand() {
            return this.has_data_command;
        }
    }
}

