/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.ics;

import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class XWizePanel {
    public static final String XWIZEPANEL = "X-WIZEPANEL";
    public static final String PRODID = "-//Wilke//Exchange to iCal4j 1.0//EN";
    public static final String COMMAND_DELETE = "DELETE";
    public static final String COMMAND_ADD = "ADD";
    private JSONObject m_json = new JSONObject();
    @Deprecated
    private static final String LIST_SEP = ";";
    @Deprecated
    private static final String FIELD_SEP = "=";

    public XWizePanel() {
    }

    public XWizePanel(String string) {
        try {
            string = string.replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
            this.m_json = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            System.err.println("JSON:\n" + string);
            for (byte by : string.getBytes()) {
                System.err.println("\t" + (by & 0xFF) + " " + (char)by);
            }
            this.parse_old_style(string);
        }
    }

    public void add(WPDataItem wPDataItem, String string) {
        try {
            this.m_json.put(wPDataItem.toString(), (Object)string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void add(WPDataItem wPDataItem, boolean bl) {
        try {
            this.m_json.put(wPDataItem.toString(), bl);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void add(WPDataItem wPDataItem, Map<String, String> map) {
        if (wPDataItem == WPDataItem.Placeholders) {
            Map<String, String> map2 = this.getMap(WPDataItem.Placeholders);
            for (String string : map.keySet()) {
                map2.put(string.toUpperCase(), map.get(string));
            }
            map = map2;
        }
        try {
            this.m_json.put(wPDataItem.toString(), map);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public String getString(WPDataItem wPDataItem, String string) {
        try {
            return this.m_json.getString(wPDataItem.toString());
        }
        catch (JSONException jSONException) {
            return string;
        }
    }

    public boolean getBoolean(WPDataItem wPDataItem, boolean bl) {
        try {
            return this.m_json.getBoolean(wPDataItem.toString());
        }
        catch (JSONException jSONException) {
            return bl;
        }
    }

    public Map<String, String> getMap(WPDataItem wPDataItem) {
        try {
            JSONObject jSONObject = this.m_json.getJSONObject(wPDataItem.toString());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : JSONObject.getNames((JSONObject)jSONObject)) {
                hashMap.put(string, jSONObject.getString(string));
            }
            return hashMap;
        }
        catch (JSONException jSONException) {
            return new HashMap<String, String>();
        }
    }

    public String toString() {
        return this.getICSName() + ":" + this.getICSValue();
    }

    public String getICSName() {
        return XWIZEPANEL;
    }

    public String getICSValue() {
        return this.m_json.toString();
    }

    @Deprecated
    private void parse_old_style(String string) {
        String[] stringArray = string.split(LIST_SEP);
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        String[] stringArray2 = string.split(LIST_SEP);
        for (int i = 0; i < stringArray2.length; ++i) {
            String[] stringArray3 = stringArray2[i].split(FIELD_SEP);
            if (stringArray3.length != 2) continue;
            try {
                this.add(WPDataItem.valueOf(stringArray3[0]), stringArray3[1]);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public static enum WPDataItem {
        ResourceName,
        TargetStationPath,
        Command,
        Filename,
        WizePanelComment,
        SessionType,
        AdapterCfg,
        Placeholders,
        Template,
        PrivateEventSummary,
        SuppressEventNotChangedWarnings,
        IsSimpleEvents,
        IsSimpleEventsNonMain;

    }
}

