/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.core.server.transfer;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.server.transfer.SimpleEventsListEntry;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SimpleEventsList {
    private static final String KEY_ID = "id";
    private static final String KEY_ROOM = "room";
    private static final String KEY_SUBJECT = "subject";
    private static final String KEY_ORGANIZER = "organizer";
    private static final String KEY_DETAILS = "details";
    private static final String KEY_DISPLAY_ON = "display_on";
    private static final String KEY_START = "start";
    private static final String KEY_END = "end";
    private static final String KEY_IS_SIMPLE_EVENTS_NON_MAIN = "isSimpleEventsNonMain";
    private final List<SimpleEventsListEntry> entries = new LinkedList<SimpleEventsListEntry>();

    public SimpleEventsList() {
    }

    public SimpleEventsList(String string) throws JSONException {
        JSONArray jSONArray = new JSONArray(string);
        for (int i = 0; i < jSONArray.length(); ++i) {
            JSONObject jSONObject = jSONArray.getJSONObject(i);
            this.addEvent(jSONObject.getString(KEY_ID), jSONObject.getString(KEY_ROOM), jSONObject.getString(KEY_SUBJECT), jSONObject.getString(KEY_ORGANIZER), WpTimeUtils.str2date(jSONObject.getString(KEY_START)), WpTimeUtils.str2date(jSONObject.getString(KEY_END)), jSONObject.getString(KEY_DETAILS), WpTimeUtils.str2date(jSONObject.getString(KEY_DISPLAY_ON)), jSONObject.getBoolean(KEY_IS_SIMPLE_EVENTS_NON_MAIN));
        }
    }

    public void addEvent(SimpleEventsListEntry simpleEventsListEntry) {
        this.entries.add(simpleEventsListEntry);
    }

    public void addEvent(String string, String string2, String string3, String string4, Date date, Date date2, String string5, Date date3, boolean bl) {
        this.entries.add(new SimpleEventsListEntry(string, string2, string3, string4, date, date2, string5, date3, bl));
    }

    public List<SimpleEventsListEntry> entries() {
        return this.entries;
    }

    public void sort() {
        Collections.sort(this.entries, new Comparator<SimpleEventsListEntry>(){

            @Override
            public int compare(SimpleEventsListEntry simpleEventsListEntry, SimpleEventsListEntry simpleEventsListEntry2) {
                if (simpleEventsListEntry.display_on.after(simpleEventsListEntry2.display_on)) {
                    return 1;
                }
                if (simpleEventsListEntry.display_on.before(simpleEventsListEntry2.display_on)) {
                    return -1;
                }
                return 0;
            }
        });
    }

    public void sortForView() {
        Collections.sort(this.entries, new Comparator<SimpleEventsListEntry>(){
            Date now = new Date();
            EventState o1State = EventState.Future;
            EventState o2State = EventState.Future;

            @Override
            public int compare(SimpleEventsListEntry simpleEventsListEntry, SimpleEventsListEntry simpleEventsListEntry2) {
                this.o1State = simpleEventsListEntry.start.before(this.now) && simpleEventsListEntry.end.before(this.now) ? EventState.Expired : (simpleEventsListEntry.start.before(this.now) && simpleEventsListEntry.end.after(this.now) ? EventState.Current : EventState.Future);
                this.o2State = simpleEventsListEntry2.start.before(this.now) && simpleEventsListEntry2.end.before(this.now) ? EventState.Expired : (simpleEventsListEntry2.start.before(this.now) && simpleEventsListEntry2.end.after(this.now) ? EventState.Current : EventState.Future);
                if (this.o1State == this.o2State) {
                    if (simpleEventsListEntry.start.before(simpleEventsListEntry2.start)) {
                        return -1;
                    }
                    if (simpleEventsListEntry.start.after(simpleEventsListEntry2.start)) {
                        return 1;
                    }
                } else {
                    if (this.o1State == EventState.Expired) {
                        return -1;
                    }
                    if (this.o1State == EventState.Current) {
                        if (this.o2State == EventState.Expired) {
                            return 1;
                        }
                        return -1;
                    }
                    return 1;
                }
                return 0;
            }
        });
    }

    public String toJSONString() throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (SimpleEventsListEntry simpleEventsListEntry : this.entries) {
            JSONObject jSONObject = new JSONObject();
            jSONObject.put(KEY_ID, (Object)simpleEventsListEntry.id);
            jSONObject.put(KEY_ROOM, (Object)simpleEventsListEntry.room);
            jSONObject.put(KEY_SUBJECT, (Object)simpleEventsListEntry.subject);
            jSONObject.put(KEY_ORGANIZER, (Object)simpleEventsListEntry.organizer);
            jSONObject.put(KEY_START, (Object)WpTimeUtils.date2str(simpleEventsListEntry.start));
            jSONObject.put(KEY_END, (Object)WpTimeUtils.date2str(simpleEventsListEntry.end));
            jSONObject.put(KEY_DETAILS, (Object)simpleEventsListEntry.details);
            jSONObject.put(KEY_DISPLAY_ON, (Object)WpTimeUtils.date2str(simpleEventsListEntry.display_on));
            jSONObject.put(KEY_IS_SIMPLE_EVENTS_NON_MAIN, simpleEventsListEntry.isSimpleEventsNonMain);
            jSONArray.put((Object)jSONObject);
        }
        return jSONArray.toString();
    }

    static enum EventState {
        Expired,
        Current,
        Future;

    }
}

