/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.jms.session;

import org.json.JSONException;
import org.json.JSONObject;

public class WpSessionResponse {
    private RESPONSE_SOURCE source = RESPONSE_SOURCE.NONE;
    private long timestamp = System.currentTimeMillis();
    private String errorName = "";
    private String errorParams = "";
    private String data = null;
    private static final String JSON_KEY_SOURCE = "source";
    private static final String JSON_KEY_TIMESTAMP = "timestamp";
    private static final String JSON_KEY_DATA = "data";
    private static final String JSON_KEY_ERROR_NAME = "error_name";
    private static final String JSON_KEY_ERROR_PARAMS = "error_params";

    public WpSessionResponse() {
    }

    public WpSessionResponse(JSONObject jSONObject) throws JSONException {
        if (jSONObject.has(JSON_KEY_SOURCE)) {
            this.source = RESPONSE_SOURCE.valueOf(jSONObject.getString(JSON_KEY_SOURCE));
        }
        if (jSONObject.has(JSON_KEY_TIMESTAMP)) {
            this.timestamp = jSONObject.getLong(JSON_KEY_TIMESTAMP);
        }
        if (jSONObject.has(JSON_KEY_DATA)) {
            this.data = jSONObject.getString(JSON_KEY_DATA);
        }
        if (jSONObject.has(JSON_KEY_ERROR_NAME)) {
            this.errorName = jSONObject.getString(JSON_KEY_ERROR_NAME);
        }
        if (jSONObject.has(JSON_KEY_ERROR_PARAMS)) {
            this.errorParams = jSONObject.getString(JSON_KEY_ERROR_PARAMS);
        }
    }

    public JSONObject toJSON() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        if (this.source != null) {
            jSONObject.put(JSON_KEY_SOURCE, (Object)this.source.name());
        }
        jSONObject.put(JSON_KEY_TIMESTAMP, this.timestamp);
        if (this.data != null) {
            jSONObject.put(JSON_KEY_DATA, (Object)this.data);
        }
        if (this.errorName != null) {
            jSONObject.put(JSON_KEY_ERROR_NAME, (Object)this.errorName);
        }
        if (this.errorParams != null) {
            jSONObject.put(JSON_KEY_ERROR_PARAMS, (Object)this.errorParams);
        }
        return jSONObject;
    }

    public RESPONSE_SOURCE getSource() {
        return this.source;
    }

    public WpSessionResponse setSource(RESPONSE_SOURCE rESPONSE_SOURCE) {
        this.source = rESPONSE_SOURCE;
        return this;
    }

    public String getErrorName() {
        return this.errorName;
    }

    public WpSessionResponse setErrorName(String string) {
        this.errorName = string;
        return this;
    }

    public String getErrorParams() {
        return this.errorParams;
    }

    public WpSessionResponse setErrorParams(String string) {
        this.errorParams = string;
        return this;
    }

    public String getResponseData() {
        return this.data;
    }

    public WpSessionResponse setResponseData(String string) {
        this.data = string;
        return this;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isError() {
        return this.errorName != null && !this.errorName.isEmpty();
    }

    public static enum RESPONSE_SOURCE {
        NONE,
        EVENT,
        RESOURCE,
        COMMAND;

    }
}

