/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.jms.system;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.templates.PlaceholderDetails;
import de.wilke.wizepanel.templates.Template;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;

public class WpTemplateFile {
    private String templateFileName;
    public final Template template = new Template();
    private List<PlaceholderDetails> placeholders;
    private TimeZone time_zone = null;

    public WpTemplateFile(String string, String string2) {
        this.templateFileName = string;
        if (string2 != null && !string2.isEmpty()) {
            this.time_zone = TimeZone.getTimeZone(string2);
        }
    }

    public boolean open() {
        WpFile wpFile;
        if (this.templateFileName != null && !this.templateFileName.isEmpty() && (wpFile = new WpFile(this.templateFileName, WpFile.WpFileType.TEMPLATE_FILE)).exists() && wpFile.isFile() && this.template.open(wpFile.getResolvedFileName())) {
            if (this.time_zone != null) {
                this.template.setTimeZone(this.time_zone);
            }
            this.placeholders = this.template.getPlaceholders();
            return true;
        }
        return false;
    }

    public boolean assignPlaceholders(Map<String, String> map) {
        if (map == null) {
            return false;
        }
        for (String string : map.keySet()) {
            this.template.setPlaceholder(string, map.get(string));
        }
        return true;
    }

    public boolean writeToImage(String string) {
        return this.template.writeToImage(string, false);
    }

    public BufferedImage exportToImage() {
        return this.template.exportToImage(false);
    }

    public boolean assignPlaceholdersFromMap(String string, Map<String, String> map) {
        this.assignPlaceholders(map);
        return this.writeToImage(string);
    }

    public final List<PlaceholderDetails> getPlaceholders() {
        return this.placeholders;
    }

    public int getWidth() {
        return this.template.getWidth();
    }

    public int getHeight() {
        return this.template.getHeight();
    }
}

