/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.ruleslib;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class Rule {
    public static final boolean PARSE_DEBUG = false;
    private static final String FIELD_SEPARATOR = "\\s+";
    private static final String KEY_VALUE_SEPARATOR = "=";
    private String m_template = "";
    private String m_regexp_str;
    private final Map<String, String> m_regexp;

    public Rule() {
        this.m_regexp_str = null;
        this.m_regexp = new HashMap<String, String>();
    }

    public Rule(String string, String string2) {
        this.m_regexp_str = string;
        this.m_regexp = Rule.parseFacts(this.m_regexp_str);
        this.setTemplate(string2);
    }

    public void addRegExp(String string, String string2) {
        this.m_regexp.put(string, string2);
        this.m_regexp_str = this.getRuleString();
    }

    public Map<String, String> getRegExp() {
        return this.m_regexp;
    }

    public void setTemplate(String string) {
        this.m_template = string;
    }

    public String getRuleString() {
        Object object = "";
        for (String string : this.m_regexp.keySet()) {
            if (((String)object).length() != 0) {
                object = (String)object + " ";
            }
            object = (String)object + string + KEY_VALUE_SEPARATOR + this.m_regexp.get(string);
        }
        return object;
    }

    public String getPlaceholderValue(String string) {
        if (this.m_regexp.containsKey(string)) {
            return this.m_regexp.get(string);
        }
        return "";
    }

    public void clearPlaceholders() {
        this.m_regexp.clear();
    }

    public void setPlaceholderValue(String string, String string2) {
        if (string2.length() > 0) {
            this.m_regexp.put(string, string2);
        }
    }

    public String getTemplate() {
        return this.m_template;
    }

    public boolean matches(Map<String, String> map) {
        if (map.size() < this.m_regexp.size()) {
            return false;
        }
        if (this.m_regexp.size() == 0) {
            return true;
        }
        for (String string : this.m_regexp.keySet()) {
            if (!map.containsKey(string)) {
                return false;
            }
            String string2 = this.m_regexp.get(string);
            String string3 = map.get(string);
            Pattern pattern = Pattern.compile(string2);
            if (pattern.matcher(string3).matches()) continue;
            return false;
        }
        return true;
    }

    public boolean matchesExactly(Map<String, String> map) {
        if (map.size() != this.m_regexp.size()) {
            return false;
        }
        for (String string : this.m_regexp.keySet()) {
            String string2;
            if (!map.containsKey(string)) {
                return false;
            }
            String string3 = this.m_regexp.get(string);
            if (string3.equals(string2 = map.get(string))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.m_regexp_str == null ? 0 : this.m_regexp_str.hashCode());
        n = 31 * n + (this.m_template == null ? 0 : this.m_template.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Rule rule = (Rule)object;
        if (this.m_regexp_str == null ? rule.m_regexp_str != null : !this.m_regexp_str.equals(rule.m_regexp_str)) {
            return false;
        }
        return !(this.m_template == null ? rule.m_template != null : !this.m_template.equals(rule.m_template));
    }

    private static Map<String, String> parseFacts(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string.length() != 0) {
            String[] stringArray = string.split(FIELD_SEPARATOR);
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = stringArray[i].split(KEY_VALUE_SEPARATOR, 2);
                if (stringArray2.length == 2) {
                    hashMap.put(stringArray2[0], stringArray2[1]);
                    continue;
                }
                System.err.println("Warning | Ups, token \"" + stringArray[i] + "\" could not be split (original string [" + string + "]).");
            }
        }
        return hashMap;
    }
}

