/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.ruleslib;

import de.wilke.wizepanel.ruleslib.Rule;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class RulesLibraryBase {
    public static final boolean DEBUG = false;
    private static final String XML_DB_DB = "db";
    private static final String XML_DB_RULE = "rule";
    private static final String XML_DB_TEMPLATE = "template";
    private static final String XML_DB_NAME = "name";
    private static final String XML_DB_REGEXP = "regexp";
    private static final String XML_DB_FIELD = "field";
    private static final String XML_DB_VALUE = "value";
    private final List<Rule> m_rules = new LinkedList<Rule>();

    public void parse_xml_stream(String string) {
        DocumentBuilder documentBuilder;
        this.m_rules.clear();
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return;
        }
        HashMap<Integer, Rule> hashMap = new HashMap<Integer, Rule>();
        try {
            Document document = documentBuilder.parse(new ByteArrayInputStream(string.getBytes("UTF-8")));
            document.getDocumentElement().normalize();
            NodeList nodeList = document.getElementsByTagName(XML_DB_RULE);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element element;
                Element element2 = (Element)nodeList.item(i);
                Rule rule = new Rule();
                NodeList nodeList2 = element2.getElementsByTagName(XML_DB_REGEXP);
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    element = (Element)nodeList2.item(j);
                    rule.addRegExp(element.getAttribute(XML_DB_FIELD), element.getAttribute(XML_DB_VALUE));
                }
                NodeList nodeList3 = element2.getElementsByTagName(XML_DB_TEMPLATE);
                if (nodeList3.getLength() != 0) {
                    element = (Element)nodeList3.item(0);
                    rule.setTemplate(element.getAttribute(XML_DB_NAME));
                }
                if (hashMap.containsKey(rule.hashCode())) continue;
                hashMap.put(rule.hashCode(), rule);
                this.m_rules.add(rule);
            }
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            System.err.println("FIXME: RulesLibrary: SAXException");
            return;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            System.err.println("FIXME: RulesLibrary: IOException");
            return;
        }
    }

    public abstract boolean save();

    public String exportToXML() {
        Object object;
        Object object2;
        Object object3;
        DocumentBuilder documentBuilder;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
            return null;
        }
        Document document = documentBuilder.newDocument();
        Element element = document.createElement(XML_DB_DB);
        document.appendChild(element);
        for (Rule object4 : this.m_rules) {
            object3 = document.createElement(XML_DB_RULE);
            object2 = document.createElement(XML_DB_TEMPLATE);
            object2.setAttribute(XML_DB_NAME, object4.getTemplate());
            object3.appendChild((Node)object2);
            object = object4.getRegExp();
            for (String string : object.keySet()) {
                Element element2 = document.createElement(XML_DB_REGEXP);
                element2.setAttribute(XML_DB_FIELD, string);
                element2.setAttribute(XML_DB_VALUE, (String)object.get(string));
                object3.appendChild(element2);
            }
            element.appendChild((Node)object3);
        }
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            object3 = new StringWriter();
            object2 = new DOMSource(document);
            object = new StreamResult((Writer)object3);
            transformer.transform((Source)object2, (Result)object);
            return ((StringWriter)object3).toString();
        }
        catch (Exception exception) {
            System.out.println("Template::writeTo()");
            return null;
        }
    }

    private Rule getExactRule(Map<String, String> map) {
        for (Rule rule : this.m_rules) {
            if (!rule.matchesExactly(map)) continue;
            return rule;
        }
        return null;
    }

    public void insertRuleAt(Rule rule, int n) {
        this.m_rules.add(n, rule);
    }

    public List<Rule> getRules() {
        return this.m_rules;
    }

    public boolean changeField(String string, String string2, String string3) {
        boolean bl = false;
        for (Rule rule : this.m_rules) {
            String string4 = rule.getPlaceholderValue(string);
            if (string4 == null || !string4.equals(string2)) continue;
            rule.setPlaceholderValue(string, string3);
            bl = true;
        }
        return bl;
    }

    public Rule standardRule(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TARGET_NAME", string);
        return this.getExactRule(hashMap);
    }

    public Rule setStandardRule(String string, String string2) {
        Rule rule = this.standardRule(string);
        if (rule == null) {
            rule = new Rule();
            rule.addRegExp("TARGET_NAME", string);
            this.insertRuleAt(rule, 0);
        }
        rule.setTemplate(string2);
        return rule;
    }

    public String getBlankTemplate(String string) {
        Rule rule = this.blankRule(string);
        if (rule == null || rule.getTemplate().isEmpty()) {
            return null;
        }
        return rule.getTemplate();
    }

    public String getSingleTemplate(String string) {
        Rule rule = this.standardRule(string);
        if (rule == null || rule.getTemplate().isEmpty()) {
            return null;
        }
        return rule.getTemplate();
    }

    public String getManyTemplate(String string) {
        Rule rule = this.manyRule(string);
        if (rule == null || rule.getTemplate().isEmpty()) {
            return null;
        }
        return rule.getTemplate();
    }

    public Rule blankRule(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TARGET_NAME", string);
        hashMap.put("TEMPLATE", "blank");
        return this.getExactRule(hashMap);
    }

    public Rule setBlankRule(String string, String string2) {
        Rule rule = this.blankRule(string);
        if (rule == null) {
            rule = new Rule();
            rule.addRegExp("TARGET_NAME", string);
            rule.addRegExp("TEMPLATE", "blank");
            this.insertRuleAt(rule, 0);
        }
        rule.setTemplate(string2);
        return rule;
    }

    public Rule manyRule(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("TARGET_NAME", string);
        hashMap.put("TEMPLATE", "many");
        return this.getExactRule(hashMap);
    }

    public Rule setManyRule(String string, String string2) {
        Rule rule = this.manyRule(string);
        if (rule == null) {
            rule = new Rule();
            rule.addRegExp("TARGET_NAME", string);
            rule.addRegExp("TEMPLATE", "many");
            this.insertRuleAt(rule, 0);
        }
        rule.setTemplate(string2);
        return rule;
    }

    public String getTemplate(String string, boolean bl, boolean bl2) {
        String string2 = this.getSingleTemplate(string);
        if (string2 != null) {
            if (!bl) {
                return this.getBlankTemplate(string);
            }
            return string2;
        }
        string2 = this.getManyTemplate(string);
        if (string2 != null) {
            if (!bl && !bl2) {
                return this.getBlankTemplate(string);
            }
            return string2;
        }
        return null;
    }

    public Set<String> targetsWithRules() {
        HashSet<String> hashSet = new HashSet<String>();
        for (Rule rule : this.m_rules) {
            if (rule.getPlaceholderValue("TEMPLATE").isEmpty() || rule.getTemplate().isEmpty()) continue;
            hashSet.add(rule.getPlaceholderValue("TARGET_NAME"));
        }
        return hashSet;
    }
}

