/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates;

import de.wilke.wizepanel.templates.Template;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class MyZip {
    private static final Logger logger = LogManager.getLogger(MyZip.class);
    private static final String TEMPLATE = "template.xml";
    private static final String IMAGES_PREFIX = "images";
    private String m_filename = null;
    private final HashMap<String, ZIPImage> m_images = new HashMap();

    public void clear() {
        this.m_filename = null;
        this.m_images.clear();
    }

    public boolean open(String string) {
        this.m_filename = string;
        return true;
    }

    public String getFilename() {
        return this.m_filename;
    }

    private String getEntryAsString(String string) {
        String string2;
        ZipFile zipFile = new ZipFile(this.m_filename);
        try {
            InputStream inputStream = zipFile.getInputStream(new ZipEntry(string));
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n = 0;
            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n);
            }
            byteArrayOutputStream.flush();
            string2 = new String(byteArrayOutputStream.toByteArray(), "UTF-8");
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                logger.debug("Could not read string entry", (Throwable)exception);
                return null;
            }
        }
        zipFile.close();
        return string2;
    }

    private BufferedImage getEntryAsImage(String string) {
        BufferedImage bufferedImage;
        ZipFile zipFile = new ZipFile(this.m_filename);
        try {
            InputStream inputStream = zipFile.getInputStream(new ZipEntry(string));
            bufferedImage = ImageIO.read(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                logger.debug("Could not read image entry", (Throwable)exception);
                return null;
            }
        }
        zipFile.close();
        return bufferedImage;
    }

    public boolean write(Template template) {
        if (this.m_filename == null) {
            return false;
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.m_filename);
             ZipOutputStream zipOutputStream = new ZipOutputStream(new BufferedOutputStream(fileOutputStream));){
            ZipEntry zipEntry = new ZipEntry(TEMPLATE);
            zipOutputStream.putNextEntry(zipEntry);
            template.getZipTemplate(zipOutputStream);
            for (String string : this.m_images.keySet()) {
                ZIPImage zIPImage = this.m_images.get(string);
                if (zIPImage.reference_counter == 0 || zIPImage.image == null) continue;
                zipEntry = new ZipEntry("images/" + string);
                zipOutputStream.putNextEntry(zipEntry);
                try {
                    ImageIO.write((RenderedImage)zIPImage.image, "png", zipOutputStream);
                }
                catch (Exception exception) {
                    logger.debug("Could not write image entry", (Throwable)exception);
                }
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return true;
    }

    public String getTemplate() {
        return this.getEntryAsString(TEMPLATE);
    }

    public BufferedImage getImage(String string) {
        ZIPImage zIPImage = this.m_images.get(string);
        if (zIPImage != null) {
            ++zIPImage.reference_counter;
            return zIPImage.image;
        }
        try {
            BufferedImage bufferedImage = this.getEntryAsImage("images/" + string);
            this.m_images.put(string, new ZIPImage(bufferedImage, 1));
            return bufferedImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String addImage(String string) throws Exception {
        BufferedImage bufferedImage = null;
        File file = new File(string);
        bufferedImage = ImageIO.read(file);
        if (bufferedImage == null) {
            return null;
        }
        Object object = file.getName();
        int n = ((String)object).lastIndexOf(".");
        String string2 = ((String)object).substring(0, n);
        String string3 = ((String)object).substring(n + 1);
        for (int i = 0; this.m_images.containsKey(object) && i < Integer.MAX_VALUE; ++i) {
            object = string2 + "_" + i + "." + string3;
        }
        this.m_images.put((String)object, new ZIPImage(bufferedImage));
        this.print_debug("add-image");
        return object;
    }

    public void removeImageOnSave(String string) {
        ZIPImage zIPImage = this.m_images.get(string);
        if (zIPImage != null) {
            --zIPImage.reference_counter;
        }
        this.print_debug("remove-image-on-save");
    }

    private void print_debug(String string) {
    }

    private class ZIPImage {
        public final BufferedImage image;
        public int reference_counter = 0;

        public ZIPImage(BufferedImage bufferedImage) {
            this.image = bufferedImage;
        }

        public ZIPImage(BufferedImage bufferedImage, int n) {
            this.image = bufferedImage;
            this.reference_counter = n;
        }
    }
}

