/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElementRectBase;
import de.wilke.wizepanel.templates.format.FormatterFactory;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import javax.imageio.ImageIO;

public class TemplateElementGraphics
extends TemplateElementRectBase {
    private String m_image_name = "";
    private boolean m_fit_to_rect = false;
    private boolean m_keep_ratio = false;
    private BufferedImage raw_image = null;
    private BufferedImage m_image = null;

    public TemplateElementGraphics(Template template) {
        super(template);
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getX() + this.getWidth();
        double d4 = this.getY() + this.getHeight();
        double d5 = Math.min(d, d3);
        double d6 = Math.min(d2, d4);
        double d7 = Math.abs(d - d3);
        double d8 = Math.abs(d2 - d4);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d7, d8);
        return double_.intersects(rectangle);
    }

    @Override
    protected void drawComponent(Graphics2D graphics2D) {
        if (this.m_image == null) {
            return;
        }
        if (this.m_fit_to_rect) {
            if (this.m_keep_ratio) {
                float f = (float)this.m_image.getWidth() / (float)this.m_image.getHeight();
                int n = this.getHeight();
                int n2 = (int)((float)n * f);
                if (n2 > this.getWidth()) {
                    n2 = this.getWidth();
                    n = (int)((float)n2 / f);
                }
                if (n > this.getHeight()) {
                    n = this.getHeight();
                    n2 = (int)((float)n * f);
                }
                graphics2D.drawImage(this.m_image, this.getX(), this.getY(), n2, n, null, null);
            } else {
                graphics2D.drawImage(this.m_image, this.getX(), this.getY(), this.getWidth(), this.getHeight(), null, null);
            }
        } else {
            graphics2D.drawImage((Image)this.m_image, this.getX(), this.getY(), null);
        }
    }

    @Override
    protected void drawHelpers(Graphics2D graphics2D) {
        if (this.m_image == null) {
            this.draw_sys_border(graphics2D);
        }
    }

    @Override
    public void rebuild() {
        this.import_image(this.raw_image);
    }

    public String getImageName() {
        return this.m_image_name;
    }

    public boolean getFitToRect() {
        return this.m_fit_to_rect;
    }

    public boolean getKeepRatio() {
        return this.m_keep_ratio;
    }

    @Override
    public void setPlaceholderValue(String string) {
        if (string == null || string.isEmpty()) {
            return;
        }
        this.raw_image = null;
        this.m_image = null;
        File file = new File(string);
        if (!file.isAbsolute() && !this._placeholder_format.isEmpty()) {
            file = new File(FormatterFactory.format(this._placeholder_format, string, this._tpl.getTimeZone()));
        }
        try {
            this.raw_image = ImageIO.read(file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.import_image(this.raw_image);
    }

    @Override
    public void setPlaceholderFormat(String object) {
        super.setPlaceholderFormat((String)object);
        if (!((String)object).endsWith("/") || !((String)object).endsWith("\\")) {
            object = (String)object + File.separator;
        }
    }

    @Override
    public String type() {
        return "tool.graphics";
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.image_name")) {
            this.raw_image = this._tpl.getImage(string2);
            if (this.raw_image == null) {
                return true;
            }
            if (this.import_image(this.raw_image)) {
                this._tpl.removeImageOnSave(this.m_image_name);
            }
            this.m_image_name = string2;
            return true;
        }
        if (string.equals("attr.resizable")) {
            this.setResizable(WpUtils.str2bool(string2));
            return true;
        }
        if (string.equals("attr.fit_to_rect")) {
            this.m_fit_to_rect = WpUtils.str2bool(string2);
            return true;
        }
        if (string.equals("attr.keep_ratio")) {
            this.m_keep_ratio = WpUtils.str2bool(string2);
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.image_name")) {
            return this.m_image_name;
        }
        if (string.equals("attr.resizable")) {
            return WpUtils.bool2str(this.m_resizable);
        }
        if (string.equals("attr.fit_to_rect")) {
            return WpUtils.bool2str(this.m_fit_to_rect);
        }
        if (string.equals("attr.keep_ratio")) {
            return WpUtils.bool2str(this.m_keep_ratio);
        }
        return super.getAttribute(string);
    }

    @Override
    protected LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = super.getAttributeNames();
        linkedList.add("attr.image_name");
        linkedList.add("attr.resizable");
        linkedList.add("attr.fit_to_rect");
        linkedList.add("attr.keep_ratio");
        return linkedList;
    }

    private boolean import_image(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return false;
        }
        this.m_image = this._tpl.image_rgb2tpl(bufferedImage);
        if (this.getWidth() == 0) {
            this.setSize(this.m_image.getWidth(), this.getHeight());
        }
        if (this.getHeight() == 0) {
            this.setSize(this.getWidth(), this.m_image.getHeight());
        }
        return true;
    }

    @Override
    public boolean doHideElement() {
        return this.m_image_name.isEmpty() && this._placeholder_hide_if_empty;
    }
}

