/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.templates.MouseHandle;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import java.awt.Color;
import java.util.LinkedList;

public abstract class TemplateElementLineBase
extends TemplateElement {
    private final int BR = 0;
    private final int TL = 1;
    protected int m_x1 = 0;
    protected int m_y1 = 0;
    protected int m_x2 = 0;
    protected int m_y2 = 0;
    protected Color m_color = Color.black;

    public TemplateElementLineBase(Template template) {
        super(template);
        this._handles = new MouseHandle[2];
        this._handles[1] = new MouseHandle();
        this._handles[0] = new MouseHandle();
    }

    @Override
    protected void setHandle(int n, int n2, int n3, boolean bl) {
        if (bl) {
            int n4 = n3 - this._handles[n].getY();
            int n5 = n2 - this._handles[n].getX();
            this._handles[1].shift(n5, n4);
            this._handles[0].shift(n5, n4);
        }
        this._handles[n].setPosition(n2, n3);
        this.m_x1 = this._handles[1].getX();
        this.m_y1 = this._handles[1].getY();
        this.m_x2 = this._handles[0].getX();
        this.m_y2 = this._handles[0].getY();
        this.rebuild();
    }

    @Override
    public MouseHandle getAnchorHandle() {
        return this._handles[1];
    }

    @Override
    public int getX() {
        return this.m_x1;
    }

    @Override
    public int getY() {
        return this.m_y1;
    }

    @Override
    public int getWidth() {
        return this.m_x2 - this.m_x1;
    }

    @Override
    public int getHeight() {
        return this.m_y2 - this.m_y1;
    }

    @Override
    public void setPosition(int n, int n2) {
        int n3 = n - this.m_x1;
        int n4 = n2 - this.m_y1;
        this.m_x1 = n;
        this.m_y1 = n2;
        this.m_x2 += n3;
        this.m_y2 += n4;
        this.geometry2handles();
    }

    @Override
    public void setSize(int n, int n2) {
        this.m_x2 = this.m_x1 + n;
        this.m_y2 = this.m_y1 + n2;
        this.geometry2handles();
    }

    @Override
    public boolean isValidSize() {
        return this.m_x1 != this.m_x2 || this.m_y1 != this.m_y2;
    }

    private void geometry2handles() {
        this._handles[1].setPosition(this.m_x1, this.m_y1);
        this._handles[0].setPosition(this.m_x2, this.m_y2);
    }

    public int getX1() {
        return this.m_x1;
    }

    public int getY1() {
        return this.m_y1;
    }

    public int getX2() {
        return this.m_x2;
    }

    public int getY2() {
        return this.m_y2;
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.x1")) {
            this.m_x1 = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        if (string.equals("attr.y1")) {
            this.m_y1 = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        if (string.equals("attr.x2")) {
            this.m_x2 = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        if (string.equals("attr.y2")) {
            this.m_y2 = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.x1")) {
            return Integer.toString(this.m_x1);
        }
        if (string.equals("attr.y1")) {
            return Integer.toString(this.m_y1);
        }
        if (string.equals("attr.x2")) {
            return Integer.toString(this.m_x2);
        }
        if (string.equals("attr.y2")) {
            return Integer.toString(this.m_y2);
        }
        return super.getAttribute(string);
    }

    @Override
    protected LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("attr.x1");
        linkedList.add("attr.y1");
        linkedList.add("attr.x2");
        linkedList.add("attr.y2");
        return linkedList;
    }

    public Color color() {
        return this.m_color;
    }
}

