/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.qr.WPQR;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElementRectBase;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.LinkedList;

public class TemplateElementQR
extends TemplateElementRectBase {
    public static final String ATTR_BG_COLOR = "attr.bg_color";
    public static final String ATTR_FG_COLOR = "attr.fg_color";
    private String m_text = "WizePanel";
    private BufferedImage generated_image = null;
    private Color fg_color = Color.BLACK;
    private Color bg_color = Color.WHITE;

    public TemplateElementQR(Template template) {
        super(template);
        this.rebuild();
    }

    public String getText() {
        return this.m_text;
    }

    public Color getBackgroundColor() {
        return this.bg_color;
    }

    public Color getForegroundColor() {
        return this.fg_color;
    }

    @Override
    public boolean intersects(Rectangle rectangle) {
        double d = this.getX();
        double d2 = this.getY();
        double d3 = this.getX() + this.getWidth();
        double d4 = this.getY() + this.getHeight();
        double d5 = Math.min(d, d3);
        double d6 = Math.min(d2, d4);
        double d7 = Math.abs(d - d3);
        double d8 = Math.abs(d2 - d4);
        Rectangle2D.Double double_ = new Rectangle2D.Double(d5, d6, d7, d8);
        return double_.intersects(rectangle);
    }

    @Override
    public String type() {
        return "tool.qr";
    }

    @Override
    public void rebuild() {
        try {
            int n = 0xFF000000 | this.bg_color.getRed() << 16 | this.bg_color.getGreen() << 8 | this.bg_color.getBlue() << 0;
            int n2 = 0xFF000000 | this.fg_color.getRed() << 16 | this.fg_color.getGreen() << 8 | this.fg_color.getBlue() << 0;
            this.generated_image = WPQR.encode((String)this.m_text, (String)"UTF-8", (int)this.getWidth(), (int)this.getHeight(), (int)n, (int)n2);
        }
        catch (Exception exception) {
            this.generated_image = null;
        }
    }

    @Override
    protected void drawComponent(Graphics2D graphics2D) {
        if (this.generated_image == null) {
            if (this.m_text != null) {
                graphics2D.drawString(this.m_text, this.getX(), this.getY());
            }
        } else {
            graphics2D.drawImage(this.generated_image, null, this.getX(), this.getY());
        }
    }

    @Override
    protected void drawHelpers(Graphics2D graphics2D) {
        this.draw_sys_border(graphics2D);
    }

    @Override
    protected LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = super.getAttributeNames();
        linkedList.add("attr.text");
        linkedList.add(ATTR_BG_COLOR);
        linkedList.add(ATTR_FG_COLOR);
        return linkedList;
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.text")) {
            return this.m_text;
        }
        if (string.equals(ATTR_BG_COLOR)) {
            return WpTemplateUtils.color2str(this.bg_color);
        }
        if (string.equals(ATTR_FG_COLOR)) {
            return WpTemplateUtils.color2str(this.fg_color);
        }
        return super.getAttribute(string);
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.text")) {
            this.m_text = string2;
            this.rebuild();
            return true;
        }
        if (string.equals(ATTR_BG_COLOR)) {
            this.bg_color = WpTemplateUtils.str2color(string2);
            this.rebuild();
            return true;
        }
        if (string.equals(ATTR_FG_COLOR)) {
            this.fg_color = WpTemplateUtils.str2color(string2);
            this.rebuild();
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public void setPlaceholderValue(String string) {
        this.m_text = string;
        this.rebuild();
    }

    @Override
    public String getPlaceholderValue() {
        return this.m_text;
    }

    @Override
    public boolean doHideElement() {
        return this.m_text.isEmpty() && this._placeholder_hide_if_empty;
    }
}

