/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.templates.MouseHandle;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElement;
import java.awt.Color;
import java.awt.Cursor;
import java.util.LinkedList;

public abstract class TemplateElementRectBase
extends TemplateElement {
    private final int BR = 0;
    private final int CR = 1;
    private final int TR = 2;
    private final int BL = 3;
    private final int BC = 4;
    private final int TL = 5;
    private final int TC = 6;
    private final int CL = 7;
    private int m_x = 0;
    private int m_y = 0;
    private int m_w = 0;
    private int m_h = 0;
    protected Color m_border_color = Color.BLACK;
    protected Color m_fill_color = Color.WHITE;
    protected boolean m_fill_bg = false;

    public TemplateElementRectBase(Template template) {
        super(template);
        this._handles = new MouseHandle[8];
        this._handles[5] = new MouseHandle(Cursor.getPredefinedCursor(6));
        this._handles[6] = new MouseHandle(Cursor.getPredefinedCursor(8));
        this._handles[2] = new MouseHandle(Cursor.getPredefinedCursor(7));
        this._handles[7] = new MouseHandle(Cursor.getPredefinedCursor(10));
        this._handles[1] = new MouseHandle(Cursor.getPredefinedCursor(11));
        this._handles[0] = new MouseHandle(Cursor.getPredefinedCursor(5));
        this._handles[4] = new MouseHandle(Cursor.getPredefinedCursor(9));
        this._handles[3] = new MouseHandle(Cursor.getPredefinedCursor(4));
    }

    @Override
    protected void setHandle(int n, int n2, int n3, boolean bl) {
        if (!this.m_resizable || bl) {
            int n4 = this.m_x - this._handles[n].getX();
            int n5 = this.m_y - this._handles[n].getY();
            this.setPosition(n2 + n4, n3 + n5);
            this.rebuild();
            return;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        switch (n) {
            case 5: {
                bl2 = true;
                bl3 = true;
                break;
            }
            case 6: {
                bl2 = true;
                break;
            }
            case 2: {
                bl2 = true;
                bl4 = true;
                break;
            }
            case 7: {
                bl3 = true;
                break;
            }
            case 1: {
                bl4 = true;
                break;
            }
            case 3: {
                bl3 = true;
                bl5 = true;
                break;
            }
            case 4: {
                bl5 = true;
                break;
            }
            case 0: {
                bl4 = true;
                bl5 = true;
                break;
            }
            default: {
                return;
            }
        }
        if (bl2) {
            if (n3 > this._handles[0].getY()) {
                n3 = this._handles[0].getY();
            }
            this._handles[5].setY(n3);
            this._handles[6].setY(n3);
            this._handles[2].setY(n3);
        }
        if (bl3) {
            if (n2 > this._handles[0].getX()) {
                n2 = this._handles[0].getX();
            }
            this._handles[5].setX(n2);
            this._handles[7].setX(n2);
            this._handles[3].setX(n2);
        }
        if (bl4) {
            if (n2 < this._handles[5].getX()) {
                n2 = this._handles[5].getX();
            }
            this._handles[2].setX(n2);
            this._handles[1].setX(n2);
            this._handles[0].setX(n2);
        }
        if (bl5) {
            if (n3 < this._handles[5].getY()) {
                n3 = this._handles[5].getY();
            }
            this._handles[3].setY(n3);
            this._handles[4].setY(n3);
            this._handles[0].setY(n3);
        }
        this.m_x = this._handles[5].getX();
        this.m_y = this._handles[5].getY();
        this.m_w = this._handles[0].getX() - this.m_x;
        this.m_h = this._handles[0].getY() - this.m_y;
        if (bl2 || bl5) {
            this._handles[7].setY(this.m_y + this.m_h / 2);
            this._handles[1].setY(this.m_y + this.m_h / 2);
        }
        if (bl3 || bl4) {
            this._handles[6].setX(this.m_x + this.m_w / 2);
            this._handles[4].setX(this.m_x + this.m_w / 2);
        }
        this.rebuild();
    }

    @Override
    public MouseHandle getAnchorHandle() {
        return this._handles[5];
    }

    @Override
    public int getX() {
        return this.m_x;
    }

    @Override
    public int getY() {
        return this.m_y;
    }

    @Override
    public int getWidth() {
        return this.m_w;
    }

    @Override
    public int getHeight() {
        return this.m_h;
    }

    @Override
    public void setSize(int n, int n2) {
        this.m_w = n;
        this.m_h = n2;
        this.geometry2handles();
    }

    @Override
    public boolean isValidSize() {
        return this.m_w != 0 && this.m_h != 0;
    }

    @Override
    public void setPosition(int n, int n2) {
        this.m_x = n;
        this.m_y = n2;
        this.geometry2handles();
    }

    private void geometry2handles() {
        int n = this.m_w / 2;
        int n2 = this.m_h / 2;
        this._handles[5].setPosition(this.m_x, this.m_y);
        this._handles[6].setPosition(this.m_x + n, this.m_y);
        this._handles[2].setPosition(this.m_x + this.m_w, this.m_y);
        this._handles[7].setPosition(this.m_x, this.m_y + n2);
        this._handles[1].setPosition(this.m_x + this.m_w, this.m_y + n2);
        this._handles[0].setPosition(this.m_x + this.m_w, this.m_y + this.m_h);
        this._handles[4].setPosition(this.m_x + n, this.m_y + this.m_h);
        this._handles[3].setPosition(this.m_x, this.m_y + this.m_h);
    }

    @Override
    public void normalize() {
        int n;
        int n2;
        int n3;
        int n4 = this._handles[5].getX();
        if (n4 > (n3 = this._handles[0].getX())) {
            this._handles[5].setX(n3);
            this._handles[7].setX(n3);
            this._handles[3].setX(n3);
            this._handles[2].setX(n4);
            this._handles[1].setX(n4);
            this._handles[0].setX(n4);
        }
        if ((n2 = this._handles[5].getY()) > (n = this._handles[0].getY())) {
            this._handles[5].setY(n);
            this._handles[6].setY(n);
            this._handles[2].setY(n);
            this._handles[3].setY(n2);
            this._handles[4].setY(n2);
            this._handles[0].setY(n2);
        }
        this.m_x = this._handles[5].getX();
        this.m_y = this._handles[5].getY();
        this.m_w = this._handles[0].getX() - this.m_x;
        this.m_h = this._handles[0].getY() - this.m_y;
        this.rebuild();
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.x")) {
            this.m_x = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        if (string.equals("attr.y")) {
            this.m_y = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        if (string.equals("attr.w")) {
            this.m_w = Math.abs(Integer.parseInt(string2));
            this.m_w = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        if (string.equals("attr.h")) {
            this.m_h = Math.abs(Integer.parseInt(string2));
            this.m_h = Integer.parseInt(string2);
            this.geometry2handles();
            return true;
        }
        if (string.equals("attr.fill_bg")) {
            this.m_fill_bg = WpUtils.str2bool(string2);
            return true;
        }
        if (string.equals("attr.line_color")) {
            this.m_border_color = WpTemplateUtils.str2color(string2);
            return true;
        }
        if (string.equals("attr.fill_color")) {
            this.m_fill_color = WpTemplateUtils.str2color(string2);
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.x")) {
            return Integer.toString(this.m_x);
        }
        if (string.equals("attr.y")) {
            return Integer.toString(this.m_y);
        }
        if (string.equals("attr.w")) {
            return Integer.toString(this.m_w);
        }
        if (string.equals("attr.h")) {
            return Integer.toString(this.m_h);
        }
        if (string.equals("attr.fill_bg")) {
            return WpUtils.bool2str(this.m_fill_bg);
        }
        if (string.equals("attr.line_color")) {
            return WpTemplateUtils.color2str(this.m_border_color);
        }
        if (string.equals("attr.fill_color")) {
            return WpTemplateUtils.color2str(this.m_fill_color);
        }
        return super.getAttribute(string);
    }

    @Override
    protected LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = new LinkedList<String>();
        linkedList.add("attr.x");
        linkedList.add("attr.y");
        linkedList.add("attr.w");
        linkedList.add("attr.h");
        linkedList.add("attr.fill_bg");
        linkedList.add("attr.line_color");
        linkedList.add("attr.fill_color");
        return linkedList;
    }

    public Color getBorderColor() {
        return this.m_border_color;
    }

    public Color getFillColor() {
        return this.m_fill_color;
    }

    public boolean doFillBackground() {
        return this.m_fill_bg;
    }
}

