/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElementRect;
import de.wilke.wizepanel.templates.format.FormatterFactory;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Hashtable;
import java.util.LinkedList;

public class TemplateElementText
extends TemplateElementRect {
    private boolean m_need_rebuild = false;
    private Color m_text_color = Color.BLACK;
    private String m_filter_chars = "";
    private static final String ELLIPSIS = " ...";
    private TextLayout m_ellipsis;
    private Alignment m_hor_align = Alignment.LEFT;
    private Alignment m_ver_align = Alignment.TOP;
    private Trim m_trim = Trim.NONE;
    private boolean m_wrap = false;
    private Font m_font = null;
    private Padding m_padding = new Padding();
    private String m_text = "";
    private float wrapping_width = 0.0f;
    private float _text_height = 0.0f;
    private final LinkedList<LayoutLine> _layout_lines = new LinkedList();
    private static final String[] attributes_to_copy = new String[]{"attr.font"};

    public TemplateElementText(Template template) {
        super(template);
        this.setAttribute("attr.line_width", Integer.toString(0));
    }

    @Override
    protected void drawComponent(Graphics2D graphics2D) {
        super.drawComponent(graphics2D);
        if (this.m_need_rebuild) {
            this.rebuild();
        }
        graphics2D.setColor(this.m_text_color);
        for (LayoutLine layoutLine : this._layout_lines) {
            TextLayout textLayout = layoutLine.layout;
            textLayout.draw(graphics2D, (float)(this.getX() + this.m_padding.left) + layoutLine.x, (float)(this.getY() + this.m_padding.top) + layoutLine.y);
        }
    }

    @Override
    public void setPlaceholderValue(String string) {
        if (this._placeholder.length() != 0) {
            this.m_text = string == null ? "" : string;
            this.m_need_rebuild = true;
        }
    }

    @Override
    public String getPlaceholderValue() {
        if (this._placeholder.length() != 0) {
            return this.m_text;
        }
        return "";
    }

    public String toString() {
        return this.m_text;
    }

    private Alignment str2alignment(String string) {
        if (string.equals("left")) {
            return Alignment.LEFT;
        }
        if (string.equals("right")) {
            return Alignment.RIGHT;
        }
        if (string.equals("top")) {
            return Alignment.TOP;
        }
        if (string.equals("bottom")) {
            return Alignment.BOTTOM;
        }
        if (string.equals("justification")) {
            return Alignment.JUSTIFICATION;
        }
        return Alignment.CENTER;
    }

    private String alignment2str(Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
            case TOP: {
                return "top";
            }
            case BOTTOM: {
                return "bottom";
            }
            case JUSTIFICATION: {
                return "justification";
            }
        }
        return "center";
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.text")) {
            this.m_text = string2 == null ? "" : string2;
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.text_color")) {
            this.m_text_color = WpTemplateUtils.str2color(string2);
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.font")) {
            this.m_font = WpTemplateUtils.str2font(string2);
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.hor_align")) {
            this.m_hor_align = this.str2alignment(string2);
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.ver_align")) {
            this.m_ver_align = this.str2alignment(string2);
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.break_text")) {
            this.m_wrap = WpUtils.str2bool(string2);
            if (this.m_trim != Trim.NONE) {
                this.m_trim = Trim.VERTICAL;
            }
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.trim_text")) {
            boolean bl = WpUtils.str2bool(string2);
            this.m_trim = bl ? (this.m_wrap ? Trim.VERTICAL : Trim.HORIZONTAL) : Trim.NONE;
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.filter_chars")) {
            this.m_filter_chars = string2;
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.text_padding_left")) {
            this.m_padding.left = Integer.parseInt(string2);
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.text_padding_top")) {
            this.m_padding.top = Integer.parseInt(string2);
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.text_padding_right")) {
            this.m_padding.right = Integer.parseInt(string2);
            this.m_need_rebuild = true;
            return true;
        }
        if (string.equals("attr.text_padding_bottom")) {
            this.m_padding.bottom = Integer.parseInt(string2);
            this.m_need_rebuild = true;
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.text")) {
            return this.m_text;
        }
        if (string.equals("attr.font")) {
            return WpTemplateUtils.font2str(this.m_font);
        }
        if (string.equals("attr.hor_align")) {
            return this.alignment2str(this.m_hor_align);
        }
        if (string.equals("attr.ver_align")) {
            return this.alignment2str(this.m_ver_align);
        }
        if (string.equals("attr.break_text")) {
            return WpUtils.bool2str(this.m_wrap);
        }
        if (string.equals("attr.filter_chars")) {
            return this.m_filter_chars;
        }
        if (string.equals("attr.trim_text")) {
            return WpUtils.bool2str(this.m_trim != Trim.NONE);
        }
        if (string.equals("attr.text_color")) {
            return WpTemplateUtils.color2str(this.m_text_color);
        }
        if (string.equals("attr.text_padding_left")) {
            return Integer.toString(this.m_padding.left);
        }
        if (string.equals("attr.text_padding_top")) {
            return Integer.toString(this.m_padding.top);
        }
        if (string.equals("attr.text_padding_right")) {
            return Integer.toString(this.m_padding.right);
        }
        if (string.equals("attr.text_padding_bottom")) {
            return Integer.toString(this.m_padding.bottom);
        }
        return super.getAttribute(string);
    }

    @Override
    public LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = super.getAttributeNames();
        linkedList.add("attr.text");
        linkedList.add("attr.font");
        linkedList.add("attr.hor_align");
        linkedList.add("attr.ver_align");
        linkedList.add("attr.break_text");
        linkedList.add("attr.filter_chars");
        linkedList.add("attr.trim_text");
        linkedList.add("attr.text_color");
        linkedList.add("attr.text_padding_left");
        linkedList.add("attr.text_padding_top");
        linkedList.add("attr.text_padding_right");
        linkedList.add("attr.text_padding_bottom");
        return linkedList;
    }

    public Color getTextColor() {
        return this.m_text_color;
    }

    public Padding getPadding() {
        return this.m_padding;
    }

    @Override
    public String type() {
        return "tool.text";
    }

    @Override
    public void rebuild() {
        String string;
        String[] stringArray;
        super.rebuild();
        this.m_need_rebuild = false;
        if (this._layout_lines == null || this.m_font == null) {
            return;
        }
        this._layout_lines.clear();
        if (this.m_text.length() == 0) {
            return;
        }
        LinkedList<LayoutLine> linkedList = new LinkedList<LayoutLine>();
        this._text_height = 0.0f;
        boolean bl = false;
        String[] stringArray2 = stringArray = this.apply_filters(this.m_text).replaceAll("\n\n+", "\n \n").split("\n");
        int n = stringArray2.length;
        for (int i = 0; i < n && !(bl = this.split_paragraph(string = stringArray2[i], linkedList)); ++i) {
        }
        this.justify_lines(linkedList);
        if (bl) {
            this.append_ellipsis();
        }
    }

    private String apply_filters(String string) {
        if (!this._placeholder_format.isEmpty()) {
            string = FormatterFactory.format(this._placeholder_format, string, this._tpl.getTimeZone());
        }
        for (int i = 0; i < this.m_filter_chars.length(); ++i) {
            string = string.replace(this.m_filter_chars.substring(i, i + 1), "");
        }
        return string;
    }

    private int getContentWidth() {
        return this.getWidth() - this.m_padding.left - this.m_padding.right;
    }

    private int getContentHeight() {
        return this.getHeight() - this.m_padding.top - this.m_padding.bottom;
    }

    protected void update_styled_ellipsis(Hashtable<TextAttribute, Font> hashtable) {
        AttributedString attributedString = new AttributedString(ELLIPSIS, hashtable);
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.create_font_renderer_context());
        lineBreakMeasurer.setPosition(attributedCharacterIterator.getBeginIndex());
        this.m_ellipsis = lineBreakMeasurer.nextLayout(Float.MAX_VALUE);
    }

    private boolean split_paragraph(String string, LinkedList<LayoutLine> linkedList) {
        if (string.length() == 0) {
            return false;
        }
        Hashtable<TextAttribute, Font> hashtable = new Hashtable<TextAttribute, Font>();
        hashtable.put(TextAttribute.FONT, this.m_font);
        AttributedString attributedString = new AttributedString(string, hashtable);
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.create_font_renderer_context());
        lineBreakMeasurer.setPosition(attributedCharacterIterator.getBeginIndex());
        this.update_styled_ellipsis(hashtable);
        if (this.m_wrap) {
            this.wrapping_width = this.getContentWidth();
            if (this.wrapping_width <= 0.0f) {
                return false;
            }
        } else {
            this.wrapping_width = Float.MAX_VALUE;
            if (this.m_trim == Trim.HORIZONTAL) {
                this.wrapping_width = this.getContentWidth();
            }
        }
        boolean bl = false;
        LayoutLine layoutLine = null;
        TextLayout textLayout = null;
        boolean bl2 = false;
        while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
            if (this.m_trim == Trim.VERTICAL && (int)(this._text_height + 2.0f * this.line_height(this.m_ellipsis)) > this.getContentHeight()) {
                bl = true;
                bl2 = true;
            }
            textLayout = null;
            try {
                if ((this.m_trim == Trim.HORIZONTAL || bl) && lineBreakMeasurer.nextOffset(this.wrapping_width) < attributedCharacterIterator.getEndIndex()) {
                    this.wrapping_width -= this.m_ellipsis.getAdvance();
                    bl2 = true;
                }
                if (this.wrapping_width < (textLayout = lineBreakMeasurer.nextLayout(this.wrapping_width)).getVisibleAdvance()) {
                    textLayout = null;
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            if (textLayout == null) {
                return false;
            }
            layoutLine = new LayoutLine(textLayout, this.line_height(textLayout));
            linkedList.add(layoutLine);
            this._text_height += layoutLine.height;
            if (!bl && this.m_trim != Trim.HORIZONTAL) continue;
        }
        if (layoutLine != null) {
            layoutLine.last_line = true;
        }
        return bl2;
    }

    private float line_height(TextLayout textLayout) {
        return textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
    }

    private void justify_lines(LinkedList<LayoutLine> linkedList) {
        float f = 0.0f;
        if (this.m_trim == Trim.NONE || this._text_height < (float)this.getContentHeight()) {
            switch (this.m_ver_align) {
                case TOP: {
                    break;
                }
                case CENTER: {
                    f = ((float)this.getContentHeight() - this._text_height) / 2.0f;
                    break;
                }
                case BOTTOM: {
                    f = (float)this.getContentHeight() - this._text_height;
                    break;
                }
            }
        }
        for (LayoutLine layoutLine : linkedList) {
            TextLayout textLayout = layoutLine.layout;
            f += textLayout.getAscent();
            float f2 = 0.0f;
            switch (this.m_hor_align) {
                case LEFT: {
                    f2 += 0.0f;
                    break;
                }
                case CENTER: {
                    f2 += ((float)this.getContentWidth() - textLayout.getVisibleAdvance()) / 2.0f;
                    break;
                }
                case RIGHT: {
                    f2 += (float)this.getContentWidth() - textLayout.getVisibleAdvance();
                    break;
                }
                case JUSTIFICATION: {
                    if (layoutLine.last_line) break;
                    textLayout = textLayout.getJustifiedLayout(this.getContentWidth());
                }
            }
            this._layout_lines.add(new LayoutLine(textLayout, f2, f, this.line_height(textLayout)));
            f += textLayout.getDescent() + textLayout.getLeading();
        }
    }

    private void append_ellipsis() {
        LayoutLine layoutLine = this._layout_lines.getLast();
        float f = layoutLine.layout.getAdvance() + this.m_ellipsis.getAdvance();
        switch (this.m_hor_align) {
            case CENTER: {
                if (layoutLine.layout.isLeftToRight()) {
                    layoutLine.x = ((float)this.getContentWidth() - f) / 2.0f;
                    break;
                }
                layoutLine.x = ((float)this.getContentWidth() + f) / 2.0f - f;
                break;
            }
            case RIGHT: {
                layoutLine.x = (float)this.getContentWidth() - f;
                break;
            }
        }
        float f2 = layoutLine.x + layoutLine.layout.getVisibleAdvance();
        float f3 = layoutLine.y;
        this._layout_lines.add(new LayoutLine(this.m_ellipsis, f2, f3, this.line_height(this.m_ellipsis)));
    }

    @Override
    protected void drawHelpers(Graphics2D graphics2D) {
        if (this.getLineWidth() == 0) {
            this.draw_sys_border(graphics2D);
        }
        graphics2D.setColor(this._sys_fg);
        graphics2D.setStroke(SYS_BORDER_STROKE);
        int n = this.getX() + this.m_padding.left;
        int n2 = this.getY() + this.m_padding.top;
        int n3 = this.getContentWidth();
        int n4 = this.getContentHeight();
        if (n3 < 0) {
            n += n3;
            n3 = -n3;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (this.m_padding.top != 0) {
            graphics2D.drawLine(n, n2, n + n3, n2);
        }
        if (this.m_padding.left != 0) {
            graphics2D.drawLine(n, n2, n, n2 + n4);
        }
        if (this.m_padding.right != 0) {
            graphics2D.drawLine(n + n3, n2, n + n3, n2 + n4);
        }
        if (this.m_padding.bottom != 0) {
            graphics2D.drawLine(n, n2 + n4, n + n3, n2 + n4);
        }
    }

    private FontRenderContext create_font_renderer_context() {
        return new FontRenderContext(null, this._tpl.getDisplay().isTextAntialiasing(), false);
    }

    @Override
    public boolean canCopyAttributes() {
        return true;
    }

    @Override
    public String[] attributesToCopy() {
        return attributes_to_copy;
    }

    @Override
    public boolean doHideElement() {
        return this.m_text.isEmpty() && this._placeholder_hide_if_empty;
    }

    public class Padding {
        public int left = 0;
        public int top = 0;
        public int right = 0;
        public int bottom = 0;
    }

    private static enum Alignment {
        CENTER,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        JUSTIFICATION;

    }

    private class LayoutLine {
        public TextLayout layout = null;
        public float x = 0.0f;
        public float y = 0.0f;
        public float height = 0.0f;
        public boolean last_line = false;

        public LayoutLine(TextLayout textLayout, float f, float f2, float f3) {
            this.layout = textLayout;
            this.x = f;
            this.y = f2;
            this.height = f3;
        }

        public LayoutLine(TextLayout textLayout, float f) {
            this.layout = textLayout;
            this.height = f;
        }
    }

    private static enum Trim {
        NONE,
        VERTICAL,
        HORIZONTAL;

    }
}

