/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.elements;

import de.wilke.wizepanel.core.WpTemplateUtils;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.templates.Template;
import de.wilke.wizepanel.templates.elements.TemplateElementRect;
import de.wilke.wizepanel.templates.format.FormatterFactory;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TimeZone;
import org.json.JSONException;
import org.json.JSONObject;

public class TemplateElementTimetable
extends TemplateElementRect {
    private boolean rebuildNeeded = false;
    protected String timelineFormat = "{date:HH:mm}";
    private Font timelineFont = null;
    private Alignment timelineHoriAlign = Alignment.LEFT;
    private Color timelineFontColor = Color.BLACK;
    protected Color timelineBackgroundColor = Color.WHITE;
    protected boolean fillTimelineBackground = false;
    protected int timelineWidth = 90;
    protected int timelineStartHour = 8;
    protected int timelineEndHour = 18;
    protected int timelineDisplayInterval = 1;
    protected int timelineTextPadding = 10;
    private boolean timelineHalfhourMark = true;
    protected Color timeIndicatorLineColor = Color.BLACK;
    protected int timeIndicatorLineWidth = 1;
    private Alignment eventHoriAlign = Alignment.LEFT;
    private Alignment eventVertAlign = Alignment.TOP;
    private Font eventFont = null;
    private Color eventFontColorCurrentDay = Color.WHITE;
    private Color eventFontColorNoncurrentDay = Color.WHITE;
    protected boolean eventTimeShow = true;
    protected boolean eventTimeBold = true;
    private TextLayout eventTimeEllipsis;
    protected boolean eventSummaryBold = false;
    private TextLayout eventSummaryEllipsis;
    protected boolean eventDescriptionBold = false;
    private TextLayout eventDescriptionEllipsis;
    private Color eventBackgroundColorCurrentDay = Color.BLACK;
    private Color eventBackgroundColorNoncurrentDay = Color.BLACK;
    private Padding eventTextPadding = new Padding();
    private int EVENT_RIGHT_PADDING = 5;
    private int EVENT_TOP_MARGIN = 2;
    private JSONObject timetableJsonData = new JSONObject();
    private static final String ELLIPSIS = "...";
    private final LinkedList<EventLayout> eventLayouts = new LinkedList();
    private final LinkedList<TextlineLayout> timelineLayouts = new LinkedList();
    private static final String[] attributes_to_copy = new String[]{"attr.time.font", "attr.event.font"};

    public Padding getEventPadding() {
        return this.eventTextPadding;
    }

    public TemplateElementTimetable(Template template) {
        super(template);
        this.setAttribute("attr.line_width", Integer.toString(0));
    }

    @Override
    protected void drawComponent(Graphics2D graphics2D) {
        super.drawComponent(graphics2D);
        if (this.rebuildNeeded) {
            this.rebuild();
        }
        if (this.fillTimelineBackground) {
            graphics2D.setColor(this.timelineBackgroundColor);
            graphics2D.fillRect(this.getX(), this.getY(), this.getTimeWidth(), this.getContentHeight());
        }
        graphics2D.setColor(this.timelineFontColor);
        for (TextlineLayout textlineLayout : this.timelineLayouts) {
            TextLayout textLayout = textlineLayout.textLayout;
            textLayout.draw(graphics2D, this.getX() + Math.round(textlineLayout.x) + this.timelineTextPadding, this.getY() + Math.round(textlineLayout.y));
        }
        float f = (float)this.getContentHeight() / (float)((this.timelineEndHour - this.timelineStartHour + 1) * 60);
        if (this.timelineHalfhourMark && this.timelineWidth > 0) {
            int n = Math.round((float)this.timelineFont.getSize() / 3.0f);
            float f2 = (float)this.getY() + f * 30.0f - (float)(n / 2);
            int n2 = this.getX();
            switch (this.timelineHoriAlign) {
                case CENTER: {
                    n2 += (this.getTimeContentWidth() - n) / 2 + this.timelineTextPadding;
                    break;
                }
                case RIGHT: {
                    n2 += this.getTimeContentWidth() - n + this.timelineTextPadding;
                    break;
                }
                default: {
                    n2 += this.timelineTextPadding;
                }
            }
            for (int i = this.timelineEndHour - this.timelineStartHour; i >= 0; --i) {
                graphics2D.fillOval(n2, Math.round(f2 + (float)i * f * 60.0f), n, n);
            }
        }
        if (this.timeIndicatorLineWidth > 0) {
            graphics2D.setColor(this.timeIndicatorLineColor);
            graphics2D.setStroke(new BasicStroke(this.timeIndicatorLineWidth, 0, 0));
            for (int i = this.timelineEndHour - this.timelineStartHour; i >= 0; --i) {
                int n = this.timeIndicatorLineWidth == 1 ? 1 : 0;
                graphics2D.drawLine(this.getX() + (this.getTimeWidth() - this.timelineTextPadding > 0 ? this.getTimeWidth() - this.timelineTextPadding : 0), Math.round((float)this.getY() + (float)(i * 60) * f), this.getX() + (this.getWidth() - n > 0 ? this.getWidth() - n : 0), Math.round((float)this.getY() + (float)(i * 60) * f));
            }
        }
        for (EventLayout eventLayout : this.eventLayouts) {
            TextLayout textLayout;
            graphics2D.setColor(eventLayout.backgroundColor);
            graphics2D.fillRect(this.getX() + Math.round(eventLayout.x), this.getY() + Math.round(eventLayout.y), Math.round(eventLayout.getBoxWidth()), Math.round(eventLayout.getBoxHeight()));
            graphics2D.setColor(this.getFillColor());
            graphics2D.setStroke(new BasicStroke(this.EVENT_TOP_MARGIN));
            graphics2D.drawLine(this.getX() + this.getTimeWidth() + 1, this.getY() + Math.round(eventLayout.y - 1.0f), this.getX() + this.getTimeWidth() + this.getContentWidth(), this.getY() + Math.round(eventLayout.y - 1.0f));
            graphics2D.setColor(eventLayout.fontColor);
            if (this.eventTimeShow) {
                for (TextlineLayout textlineLayout : eventLayout.timeLayouts) {
                    textLayout = textlineLayout.textLayout;
                    textLayout.draw(graphics2D, (float)this.getX() + textlineLayout.x + (float)Math.round(eventLayout.x) + (float)this.eventTextPadding.left, (float)this.getY() + textlineLayout.y + (float)Math.round(eventLayout.y) + (float)this.eventTextPadding.top);
                }
            }
            for (TextlineLayout textlineLayout : eventLayout.summaryLayouts) {
                textLayout = textlineLayout.textLayout;
                textLayout.draw(graphics2D, (float)this.getX() + textlineLayout.x + (float)Math.round(eventLayout.x) + (float)this.eventTextPadding.left, (float)this.getY() + textlineLayout.y + (float)Math.round(eventLayout.y) + (float)this.eventTextPadding.top);
            }
            for (TextlineLayout textlineLayout : eventLayout.descriptionLayouts) {
                textLayout = textlineLayout.textLayout;
                textLayout.draw(graphics2D, (float)this.getX() + textlineLayout.x + (float)Math.round(eventLayout.x) + (float)this.eventTextPadding.left, (float)this.getY() + textlineLayout.y + (float)Math.round(eventLayout.y) + (float)this.eventTextPadding.top);
            }
        }
    }

    @Override
    public void setPlaceholderValue(String string) {
        if (this._placeholder.length() != 0) {
            try {
                this.timetableJsonData = string == null || string.isEmpty() ? new JSONObject() : new JSONObject(string);
                this.rebuildNeeded = true;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                this.timetableJsonData = new JSONObject();
                this.rebuildNeeded = true;
            }
        }
    }

    @Override
    public String getPlaceholderValue() {
        if (this._placeholder.length() != 0) {
            return this.timetableJsonData.toString();
        }
        return "";
    }

    public String toString() {
        return this.timetableJsonData.toString();
    }

    private Alignment str2alignment(String string) {
        if (string.equals("left")) {
            return Alignment.LEFT;
        }
        if (string.equals("right")) {
            return Alignment.RIGHT;
        }
        if (string.equals("top")) {
            return Alignment.TOP;
        }
        if (string.equals("bottom")) {
            return Alignment.BOTTOM;
        }
        if (string.equals("justification")) {
            return Alignment.JUSTIFICATION;
        }
        return Alignment.CENTER;
    }

    private String alignment2str(Alignment alignment) {
        switch (alignment) {
            case LEFT: {
                return "left";
            }
            case RIGHT: {
                return "right";
            }
            case TOP: {
                return "top";
            }
            case BOTTOM: {
                return "bottom";
            }
            case JUSTIFICATION: {
                return "justification";
            }
        }
        return "center";
    }

    @Override
    public boolean setAttribute(String string, String string2) {
        if (string.equals("attr.time.font")) {
            this.timelineFont = WpTemplateUtils.str2font(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.hor_align")) {
            this.timelineHoriAlign = this.str2alignment(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.padding")) {
            this.timelineTextPadding = Integer.parseInt(string2) <= 0 ? 0 : Integer.parseInt(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.format")) {
            this.timelineFormat = string2;
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.font_color")) {
            this.timelineFontColor = WpTemplateUtils.str2color(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.background")) {
            this.timelineBackgroundColor = WpTemplateUtils.str2color(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.indicator_line_color")) {
            this.timeIndicatorLineColor = WpTemplateUtils.str2color(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.indicator_line_w")) {
            this.timeIndicatorLineWidth = Integer.parseInt(string2) <= 0 ? 0 : Integer.parseInt(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.fill_bg")) {
            this.fillTimelineBackground = WpUtils.str2bool(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.w")) {
            this.timelineWidth = Integer.parseInt(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.start")) {
            this.timelineStartHour = Integer.parseInt(string2) % 24;
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.end")) {
            this.timelineEndHour = Integer.parseInt(string2) % 24;
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.interval")) {
            this.timelineDisplayInterval = Integer.parseInt(string2) > 0 ? Integer.parseInt(string2) : 2;
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.time.half_hour_mark")) {
            this.timelineHalfhourMark = WpUtils.str2bool(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.hor_align")) {
            this.eventHoriAlign = this.str2alignment(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.ver_align")) {
            this.eventVertAlign = this.str2alignment(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.font")) {
            this.eventFont = WpTemplateUtils.str2font(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.font_color_current_day")) {
            this.eventFontColorCurrentDay = WpTemplateUtils.str2color(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.font_color_noncurrent_day")) {
            this.eventFontColorNoncurrentDay = WpTemplateUtils.str2color(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.time_show")) {
            this.eventTimeShow = WpUtils.str2bool(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.time_bold")) {
            this.eventTimeBold = WpUtils.str2bool(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.summary_bold")) {
            this.eventSummaryBold = WpUtils.str2bool(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.desc_bold")) {
            this.eventDescriptionBold = WpUtils.str2bool(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.current_day_color")) {
            this.eventBackgroundColorCurrentDay = WpTemplateUtils.str2color(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.event.noncurrent_day_color")) {
            this.eventBackgroundColorNoncurrentDay = WpTemplateUtils.str2color(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.events_data")) {
            try {
                this.timetableJsonData = new JSONObject(string2);
                this.rebuildNeeded = true;
                return true;
            }
            catch (JSONException jSONException) {
                jSONException.printStackTrace();
                this.timetableJsonData = new JSONObject();
                this.rebuildNeeded = true;
                return false;
            }
        }
        if (string.equals("attr.text_padding_left")) {
            this.eventTextPadding.left = Integer.parseInt(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.text_padding_top")) {
            this.eventTextPadding.top = Integer.parseInt(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.text_padding_right")) {
            this.eventTextPadding.right = Integer.parseInt(string2);
            this.rebuildNeeded = true;
            return true;
        }
        if (string.equals("attr.text_padding_bottom")) {
            this.eventTextPadding.bottom = Integer.parseInt(string2);
            this.rebuildNeeded = true;
            return true;
        }
        return super.setAttribute(string, string2);
    }

    @Override
    public String getAttribute(String string) {
        if (string.equals("attr.time.font")) {
            return WpTemplateUtils.font2str(this.timelineFont);
        }
        if (string.equals("attr.time.hor_align")) {
            return this.alignment2str(this.timelineHoriAlign);
        }
        if (string.equals("attr.time.padding")) {
            return Integer.toString(this.timelineTextPadding);
        }
        if (string.equals("attr.time.format")) {
            return this.timelineFormat;
        }
        if (string.equals("attr.time.font_color")) {
            return WpTemplateUtils.color2str(this.timelineFontColor);
        }
        if (string.equals("attr.time.background")) {
            return WpTemplateUtils.color2str(this.timelineBackgroundColor);
        }
        if (string.equals("attr.time.indicator_line_color")) {
            return WpTemplateUtils.color2str(this.timeIndicatorLineColor);
        }
        if (string.equals("attr.time.indicator_line_w")) {
            return Integer.toString(this.timeIndicatorLineWidth);
        }
        if (string.equals("attr.time.fill_bg")) {
            return WpUtils.bool2str(this.fillTimelineBackground);
        }
        if (string.equals("attr.time.w")) {
            return Integer.toString(this.timelineWidth);
        }
        if (string.equals("attr.time.start")) {
            return Integer.toString(this.timelineStartHour);
        }
        if (string.equals("attr.time.end")) {
            return Integer.toString(this.timelineEndHour);
        }
        if (string.equals("attr.time.interval")) {
            return Integer.toString(this.timelineDisplayInterval);
        }
        if (string.equals("attr.time.half_hour_mark")) {
            return WpUtils.bool2str(this.timelineHalfhourMark);
        }
        if (string.equals("attr.event.hor_align")) {
            return this.alignment2str(this.eventHoriAlign);
        }
        if (string.equals("attr.event.ver_align")) {
            return this.alignment2str(this.eventVertAlign);
        }
        if (string.equals("attr.event.font")) {
            return WpTemplateUtils.font2str(this.eventFont);
        }
        if (string.equals("attr.event.font_color_current_day")) {
            return WpTemplateUtils.color2str(this.eventFontColorCurrentDay);
        }
        if (string.equals("attr.event.font_color_noncurrent_day")) {
            return WpTemplateUtils.color2str(this.eventFontColorNoncurrentDay);
        }
        if (string.equals("attr.event.time_show")) {
            return WpUtils.bool2str(this.eventTimeShow);
        }
        if (string.equals("attr.event.time_bold")) {
            return WpUtils.bool2str(this.eventTimeBold);
        }
        if (string.equals("attr.event.summary_bold")) {
            return WpUtils.bool2str(this.eventSummaryBold);
        }
        if (string.equals("attr.event.desc_bold")) {
            return WpUtils.bool2str(this.eventDescriptionBold);
        }
        if (string.equals("attr.event.current_day_color")) {
            return WpTemplateUtils.color2str(this.eventBackgroundColorCurrentDay);
        }
        if (string.equals("attr.event.noncurrent_day_color")) {
            return WpTemplateUtils.color2str(this.eventBackgroundColorNoncurrentDay);
        }
        if (string.equals("attr.events_data")) {
            return this.timetableJsonData.toString();
        }
        if (string.equals("attr.text_padding_left")) {
            return Integer.toString(this.eventTextPadding.left);
        }
        if (string.equals("attr.text_padding_top")) {
            return Integer.toString(this.eventTextPadding.top);
        }
        if (string.equals("attr.text_padding_right")) {
            return Integer.toString(this.eventTextPadding.right);
        }
        if (string.equals("attr.text_padding_bottom")) {
            return Integer.toString(this.eventTextPadding.bottom);
        }
        return super.getAttribute(string);
    }

    @Override
    public LinkedList<String> getAttributeNames() {
        LinkedList<String> linkedList = super.getAttributeNames();
        linkedList.add("attr.events_data");
        linkedList.add("attr.time.font");
        linkedList.add("attr.time.format");
        linkedList.add("attr.time.hor_align");
        linkedList.add("attr.time.padding");
        linkedList.add("attr.time.font_color");
        linkedList.add("attr.time.background");
        linkedList.add("attr.time.indicator_line_color");
        linkedList.add("attr.time.indicator_line_w");
        linkedList.add("attr.time.fill_bg");
        linkedList.add("attr.time.w");
        linkedList.add("attr.time.start");
        linkedList.add("attr.time.end");
        linkedList.add("attr.time.interval");
        linkedList.add("attr.time.half_hour_mark");
        linkedList.add("attr.event.hor_align");
        linkedList.add("attr.event.ver_align");
        linkedList.add("attr.event.font");
        linkedList.add("attr.event.font_color_current_day");
        linkedList.add("attr.event.font_color_noncurrent_day");
        linkedList.add("attr.event.time_show");
        linkedList.add("attr.event.time_bold");
        linkedList.add("attr.event.summary_bold");
        linkedList.add("attr.event.desc_bold");
        linkedList.add("attr.event.current_day_color");
        linkedList.add("attr.event.noncurrent_day_color");
        linkedList.add("attr.text_padding_left");
        linkedList.add("attr.text_padding_top");
        linkedList.add("attr.text_padding_right");
        linkedList.add("attr.text_padding_bottom");
        return linkedList;
    }

    public Color getEventCurrentDayFontColor() {
        return this.eventFontColorCurrentDay;
    }

    public Color getEventNoncurrentDayFontColor() {
        return this.eventFontColorNoncurrentDay;
    }

    public Color getEventCurrentDayColor() {
        return this.eventBackgroundColorCurrentDay;
    }

    public Color getEventNoncurrentDayColor() {
        return this.eventBackgroundColorNoncurrentDay;
    }

    public Color getTimeFontColor() {
        return this.timelineFontColor;
    }

    public Color getTimeFillColor() {
        return this.timelineBackgroundColor;
    }

    public Color getTimeIndLineColor() {
        return this.timeIndicatorLineColor;
    }

    @Override
    public String type() {
        return "tool.timetable";
    }

    @Override
    public void rebuild() {
        super.rebuild();
        this.rebuildNeeded = false;
        if (this.timelineFont == null || this.eventFont == null) {
            return;
        }
        this.timelineLayouts.clear();
        float f = (float)this.getContentHeight() / (float)((this.timelineEndHour - this.timelineStartHour + 1) * 60);
        if (f <= 0.0f) {
            return;
        }
        LinkedList<TextlineLayout> linkedList = new LinkedList<TextlineLayout>();
        for (int i = this.timelineStartHour; i <= this.timelineEndHour; i += this.timelineDisplayInterval) {
            this.splitParagraph(this.buildTime(i < 10 ? "0" + i : "" + i), linkedList);
        }
        float f2 = ((TextlineLayout)linkedList.getFirst()).textLayout.getAscent() / 2.0f;
        for (TextlineLayout object2 : linkedList) {
            this.timelineLayouts.add(this.justifyLayout(object2.textLayout, f2));
            f2 += f * (float)(this.timelineDisplayInterval * 60);
        }
        this.eventLayouts.clear();
        Object object3 = "";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        Date date = null;
        try {
            object3 = this.timetableJsonData.getString("CURRENT_DAY");
            date = simpleDateFormat.parse((String)object3);
        }
        catch (ParseException | JSONException calendar) {
            // empty catch block
        }
        if (date != null) {
            Calendar calendar = Calendar.getInstance();
            if (this._tpl.getTimeZone() != null && Arrays.asList(TimeZone.getAvailableIDs()).contains(this._tpl.getTimeZone().toString())) {
                calendar = Calendar.getInstance(this._tpl.getTimeZone());
            }
            Calendar calendar2 = (Calendar)calendar.clone();
            calendar.setTimeInMillis(date.getTime());
            Calendar calendar3 = (Calendar)calendar.clone();
            calendar3.set(11, 0);
            calendar3.clear(12);
            calendar3.clear(13);
            calendar3.clear(14);
            Calendar calendar4 = (Calendar)calendar3.clone();
            calendar4.add(5, 1);
            if (calendar4.before(calendar3)) {
                calendar4.add(1, 1);
            }
            boolean bl = false;
            if (calendar2.get(1) == calendar3.get(1) && calendar2.get(6) == calendar3.get(6)) {
                bl = true;
            }
            JSONObject jSONObject = null;
            try {
                jSONObject = this.timetableJsonData.getJSONObject("EVENTLIST");
            }
            catch (JSONException calendar5) {
                calendar5.printStackTrace();
            }
            if (jSONObject == null) {
                return;
            }
            Calendar calendar5 = (Calendar)calendar.clone();
            Calendar calendar6 = (Calendar)calendar.clone();
            Iterator iterator = jSONObject.sortedKeys();
            while (iterator.hasNext()) {
                try {
                    Object object;
                    String string;
                    String string2;
                    EventLayout eventLayout = new EventLayout();
                    String exception = (String)iterator.next();
                    JSONObject jSONObject2 = new JSONObject(jSONObject.getString(exception));
                    String string3 = jSONObject2.getString("DTSTART");
                    Date date2 = WpTimeUtils.str2date(string3);
                    calendar5.setTimeInMillis(date2.getTime());
                    if (calendar5.after(calendar4) || calendar5.equals(calendar4)) continue;
                    if (calendar5.before(calendar3) || calendar5.equals(calendar3)) {
                        eventLayout.y = 0.0f;
                        string2 = "00:00";
                    } else {
                        eventLayout.y = ((float)calendar5.get(11) * 60.0f + (float)calendar5.get(12) - (float)this.timelineStartHour * 60.0f) * f;
                        if (eventLayout.y < 0.0f) {
                            eventLayout.y = 0.0f;
                        }
                        string2 = FormatterFactory.format("{date:HH:mm}", string3, this._tpl.getTimeZone());
                    }
                    String string4 = jSONObject2.getString("DTEND");
                    date2 = WpTimeUtils.str2date(string4);
                    calendar6.setTimeInMillis(date2.getTime());
                    if (calendar6.before(calendar3) || calendar6.equals(calendar3)) continue;
                    if (calendar6.after(calendar4) || calendar6.equals(calendar4)) {
                        eventLayout.h = (float)this.getContentHeight() - eventLayout.y;
                        string = "23:59";
                    } else {
                        eventLayout.h = ((float)calendar6.get(11) * 60.0f + (float)calendar6.get(12) - (float)this.timelineStartHour * 60.0f) * f - (float)Math.round(eventLayout.y);
                        string = FormatterFactory.format("{date:HH:mm}", string4, this._tpl.getTimeZone());
                        if (eventLayout.h + eventLayout.y > (float)this.getContentHeight()) {
                            eventLayout.h = (float)this.getContentHeight() - eventLayout.y;
                        }
                        if (eventLayout.h <= 0.0f) continue;
                    }
                    eventLayout.x = this.getTimeWidth();
                    eventLayout.w = this.getContentWidth();
                    eventLayout.backgroundColor = bl ? this.eventBackgroundColorCurrentDay : this.eventBackgroundColorNoncurrentDay;
                    Color color = eventLayout.fontColor = bl ? this.eventFontColorCurrentDay : this.eventFontColorNoncurrentDay;
                    if (this.eventTimeShow) {
                        object = string2 + " - " + string + " ";
                        this.splitParagraph(new String[]{object}, eventLayout, EventElement.TIME);
                    }
                    object = jSONObject2.getString("SUMMARY").replaceAll("[\t\u00a0\u1680\u180e\u2000\u200a\u202f\u205f\u3000]", " ");
                    String string5 = jSONObject2.getString("DESCRIPTION").replaceAll("[\t\u00a0\u1680\u180e\u2000\u200a\u202f\u205f\u3000]", " ");
                    if (string5.isEmpty()) {
                        eventLayout.reserve_description_line = false;
                    }
                    String[] stringArray = ((String)object).replaceAll("\n\n+", "\n \n").split("\n");
                    this.splitParagraph(stringArray, eventLayout, EventElement.SUMMARY);
                    String[] stringArray2 = string5.replaceAll("\n\n+", "\n \n").split("\n");
                    this.splitParagraph(stringArray2, eventLayout, EventElement.DESCRIPTION);
                    this.justifyEventLayout(eventLayout);
                    this.append_ellipsis(eventLayout);
                    this.eventLayouts.add(eventLayout);
                }
                catch (Exception exception) {}
            }
        }
    }

    private String buildTime(String string) {
        String string2 = string;
        if (!this.timelineFormat.isEmpty()) {
            string2 = FormatterFactory.format(this.timelineFormat, "19000101T" + string + "0000Z", TimeZone.getTimeZone("GMT+0"));
        }
        return string2;
    }

    private int getContentWidth() {
        return this.getWidth() > this.timelineWidth + 1 ? this.getWidth() - this.timelineWidth - this.EVENT_RIGHT_PADDING : 0;
    }

    private int getTimeContentWidth() {
        return (this.getWidth() > this.timelineWidth ? this.timelineWidth : this.getWidth()) - 2 * this.timelineTextPadding;
    }

    private int getTimeWidth() {
        return this.getWidth() > this.timelineWidth ? this.timelineWidth : this.getWidth();
    }

    private int getContentHeight() {
        return this.getHeight();
    }

    protected void update_styled_ellipsis(Hashtable<TextAttribute, Font> hashtable, EventElement eventElement) {
        AttributedString attributedString = new AttributedString(ELLIPSIS, hashtable);
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.create_font_renderer_context());
        lineBreakMeasurer.setPosition(attributedCharacterIterator.getBeginIndex());
        switch (eventElement) {
            case TIME: {
                this.eventTimeEllipsis = lineBreakMeasurer.nextLayout(Float.MAX_VALUE);
                break;
            }
            case SUMMARY: {
                this.eventSummaryEllipsis = lineBreakMeasurer.nextLayout(Float.MAX_VALUE);
                break;
            }
            case DESCRIPTION: {
                this.eventDescriptionEllipsis = lineBreakMeasurer.nextLayout(Float.MAX_VALUE);
                break;
            }
        }
    }

    private void splitParagraph(String string, LinkedList<TextlineLayout> linkedList) {
        if (string.length() == 0) {
            return;
        }
        Hashtable<TextAttribute, Font> hashtable = new Hashtable<TextAttribute, Font>();
        hashtable.put(TextAttribute.FONT, this.timelineFont);
        AttributedString attributedString = new AttributedString(string, hashtable);
        AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
        LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.create_font_renderer_context());
        lineBreakMeasurer.setPosition(attributedCharacterIterator.getBeginIndex());
        TextlineLayout textlineLayout = null;
        TextLayout textLayout = null;
        float f = Float.MAX_VALUE;
        if (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex()) {
            textLayout = lineBreakMeasurer.nextLayout(f);
            textlineLayout = new TextlineLayout(textLayout, this.lineHeight(textLayout), false);
            linkedList.add(textlineLayout);
        }
    }

    private void splitParagraph(String[] stringArray, EventLayout eventLayout, EventElement eventElement) {
        if (stringArray.length == 0) {
            return;
        }
        Hashtable<TextAttribute, Font> hashtable = new Hashtable<TextAttribute, Font>();
        switch (eventElement) {
            case TIME: {
                hashtable.put(TextAttribute.FONT, this.eventFont.deriveFont(0 | (!this.eventTimeBold ? 0 : 1) | (this.eventFont.isItalic() ? 2 : 0)));
                break;
            }
            case SUMMARY: {
                hashtable.put(TextAttribute.FONT, this.eventFont.deriveFont(0 | (!this.eventSummaryBold ? 0 : 1) | (this.eventFont.isItalic() ? 2 : 0)));
                break;
            }
            case DESCRIPTION: {
                hashtable.put(TextAttribute.FONT, this.eventFont.deriveFont(0 | (!this.eventDescriptionBold ? 0 : 1) | (this.eventFont.isItalic() ? 2 : 0)));
            }
        }
        float f = eventLayout.getContentWidth();
        this.update_styled_ellipsis(hashtable, eventElement);
        boolean bl = false;
        boolean bl2 = false;
        block21: for (String string : stringArray) {
            TextLayout textLayout;
            if (bl2) {
                switch (eventElement) {
                    case TIME: {
                        if (eventLayout.timeLayouts.size() <= 0) break;
                        eventLayout.timeLayouts.getLast().wasTrimmed = true;
                        break;
                    }
                    case SUMMARY: {
                        if (eventLayout.summaryLayouts.size() <= 0) break;
                        eventLayout.summaryLayouts.getLast().wasTrimmed = true;
                        break;
                    }
                    case DESCRIPTION: {
                        if (eventLayout.descriptionLayouts.size() <= 0) break;
                        eventLayout.descriptionLayouts.getLast().wasTrimmed = true;
                    }
                }
                break;
            }
            if (string.isEmpty()) break;
            AttributedString attributedString = new AttributedString(string, hashtable);
            AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
            LineBreakMeasurer lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator, this.create_font_renderer_context());
            lineBreakMeasurer.setPosition(attributedCharacterIterator.getBeginIndex());
            TextlineLayout textlineLayout = null;
            TextLayout textLayout2 = null;
            switch (eventElement) {
                case TIME: {
                    if ((float)((int)(eventLayout.textHeight + this.lineHeight(this.eventTimeEllipsis))) > eventLayout.getContentHeight()) {
                        return;
                    }
                    textLayout = this.eventTimeEllipsis;
                    break;
                }
                case SUMMARY: {
                    if ((float)((int)(eventLayout.textHeight + this.lineHeight(this.eventSummaryEllipsis))) > eventLayout.getContentHeight()) {
                        return;
                    }
                    textLayout = this.eventSummaryEllipsis;
                    break;
                }
                default: {
                    if ((float)((int)(eventLayout.textHeight + this.lineHeight(this.eventDescriptionEllipsis))) > eventLayout.getContentHeight()) {
                        return;
                    }
                    textLayout = this.eventDescriptionEllipsis;
                }
            }
            while (lineBreakMeasurer.getPosition() < attributedCharacterIterator.getEndIndex() && !bl2) {
                if (eventElement == EventElement.SUMMARY && eventLayout.reserve_description_line) {
                    if ((float)((int)(eventLayout.textHeight + 3.0f * this.lineHeight(textLayout))) > eventLayout.getContentHeight()) {
                        bl2 = true;
                    }
                } else if ((float)((int)(eventLayout.textHeight + 2.0f * this.lineHeight(textLayout))) > eventLayout.getContentHeight()) {
                    bl2 = true;
                }
                textLayout2 = null;
                try {
                    if (bl2 && lineBreakMeasurer.nextOffset(f) < attributedCharacterIterator.getEndIndex()) {
                        if (eventElement == EventElement.TIME) {
                            f -= this.eventTimeEllipsis.getAdvance();
                        } else if (eventElement == EventElement.SUMMARY) {
                            f -= this.eventSummaryEllipsis.getAdvance();
                        } else if (eventElement == EventElement.DESCRIPTION) {
                            f -= this.eventDescriptionEllipsis.getAdvance();
                        }
                        string = string.substring(lineBreakMeasurer.getPosition(), attributedCharacterIterator.getEndIndex() - 1);
                        attributedString = new AttributedString(string, hashtable);
                        attributedCharacterIterator = attributedString.getIterator();
                        while (!(string = string.substring(0, attributedCharacterIterator.getEndIndex() - 2)).isEmpty() && (lineBreakMeasurer = new LineBreakMeasurer(attributedCharacterIterator = (attributedString = new AttributedString(string, hashtable)).getIterator(), this.create_font_renderer_context())).nextOffset(f) < attributedCharacterIterator.getEndIndex()) {
                        }
                        bl = true;
                    }
                    if (f < (textLayout2 = lineBreakMeasurer.nextLayout(f)).getVisibleAdvance()) {
                        textLayout2 = null;
                    }
                }
                catch (ArrayIndexOutOfBoundsException | IllegalArgumentException runtimeException) {
                    // empty catch block
                }
                if (textLayout2 == null) continue block21;
                textlineLayout = new TextlineLayout(textLayout2, this.lineHeight(textLayout2), bl);
                switch (eventElement) {
                    case TIME: {
                        eventLayout.timeLayouts.add(textlineLayout);
                        eventLayout.textHeight += textlineLayout.height;
                        break;
                    }
                    case SUMMARY: {
                        eventLayout.summaryLayouts.add(textlineLayout);
                        eventLayout.textHeight += textlineLayout.height;
                        break;
                    }
                    case DESCRIPTION: {
                        eventLayout.descriptionLayouts.add(textlineLayout);
                        eventLayout.textHeight += textlineLayout.height;
                    }
                }
            }
        }
    }

    private float lineHeight(TextLayout textLayout) {
        float f = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        return f;
    }

    private TextlineLayout justifyLayout(TextLayout textLayout, float f) {
        float f2 = 0.0f;
        switch (this.timelineHoriAlign) {
            case LEFT: {
                if (textLayout.isLeftToRight()) {
                    f2 += 0.0f;
                    break;
                }
                f2 += (float)this.getTimeContentWidth() - textLayout.getAdvance();
                break;
            }
            case CENTER: {
                if (textLayout.isLeftToRight()) {
                    f2 += ((float)this.getTimeContentWidth() - textLayout.getAdvance()) / 2.0f;
                    break;
                }
                f2 += ((float)this.getTimeContentWidth() + textLayout.getAdvance()) / 2.0f - textLayout.getAdvance();
                break;
            }
            case RIGHT: {
                if (textLayout.isLeftToRight()) {
                    f2 += (float)this.getTimeContentWidth() - textLayout.getAdvance();
                    break;
                }
                f2 += (float)this.getTimeContentWidth();
                break;
            }
            case JUSTIFICATION: {
                textLayout = textLayout.getJustifiedLayout(this.getTimeContentWidth());
            }
        }
        return new TextlineLayout(textLayout, f2, f, this.lineHeight(textLayout));
    }

    private void justifyEventLayout(EventLayout eventLayout) {
        float f = 0.0f;
        float f2 = 0.0f;
        if (eventLayout.textHeight < eventLayout.getContentHeight()) {
            switch (this.eventVertAlign) {
                case TOP: {
                    f = 0.0f;
                    break;
                }
                case CENTER: {
                    f = (eventLayout.getContentHeight() - eventLayout.textHeight) / 2.0f;
                    break;
                }
                case BOTTOM: {
                    f = eventLayout.getContentHeight() - eventLayout.textHeight;
                    break;
                }
            }
        }
        for (TextlineLayout textlineLayout : eventLayout.timeLayouts) {
            f += textlineLayout.textLayout.getAscent();
            switch (this.eventHoriAlign) {
                case LEFT: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 += 0.0f;
                        break;
                    }
                    f2 += textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f;
                    break;
                }
                case CENTER: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 = (eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f)) / 2.0f;
                        break;
                    }
                    f2 = (eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f)) / 2.0f + (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f);
                    break;
                }
                case RIGHT: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 = eventLayout.getContentWidth() - textlineLayout.textLayout.getVisibleAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f);
                        break;
                    }
                    f2 = eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance();
                    break;
                }
                case JUSTIFICATION: {
                    f2 = 0.0f;
                    if (textlineLayout.wasTrimmed) break;
                    textlineLayout.textLayout = textlineLayout.textLayout.getJustifiedLayout(eventLayout.getContentWidth());
                }
            }
            textlineLayout.x = f2;
            textlineLayout.y = f;
            textlineLayout.textLayout = textlineLayout.textLayout;
            textlineLayout.height = this.lineHeight(textlineLayout.textLayout);
            f += textlineLayout.textLayout.getDescent() + textlineLayout.textLayout.getLeading();
        }
        for (TextlineLayout textlineLayout : eventLayout.summaryLayouts) {
            f += textlineLayout.textLayout.getAscent();
            switch (this.eventHoriAlign) {
                case LEFT: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 += 0.0f;
                        break;
                    }
                    f2 += textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f;
                    break;
                }
                case CENTER: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 = (eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f)) / 2.0f;
                        break;
                    }
                    f2 = (eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f)) / 2.0f + (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f);
                    break;
                }
                case RIGHT: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 = eventLayout.getContentWidth() - textlineLayout.textLayout.getVisibleAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f);
                        break;
                    }
                    f2 = eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance();
                    break;
                }
                case JUSTIFICATION: {
                    f2 = 0.0f;
                    if (textlineLayout.wasTrimmed) break;
                    textlineLayout.textLayout = textlineLayout.textLayout.getJustifiedLayout(eventLayout.getContentWidth());
                }
            }
            textlineLayout.x = f2;
            textlineLayout.y = f;
            textlineLayout.textLayout = textlineLayout.textLayout;
            textlineLayout.height = this.lineHeight(textlineLayout.textLayout);
            f += textlineLayout.textLayout.getDescent() + textlineLayout.textLayout.getLeading();
        }
        for (TextlineLayout textlineLayout : eventLayout.descriptionLayouts) {
            f += textlineLayout.textLayout.getAscent();
            switch (this.eventHoriAlign) {
                case LEFT: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 += 0.0f;
                        break;
                    }
                    f2 += textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f;
                    break;
                }
                case CENTER: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 = (eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f)) / 2.0f;
                        break;
                    }
                    f2 = (eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f)) / 2.0f + (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f);
                    break;
                }
                case RIGHT: {
                    if (textlineLayout.textLayout.isLeftToRight()) {
                        f2 = eventLayout.getContentWidth() - textlineLayout.textLayout.getVisibleAdvance() - (textlineLayout.wasTrimmed ? this.eventTimeEllipsis.getAdvance() : 0.0f);
                        break;
                    }
                    f2 = eventLayout.getContentWidth() - textlineLayout.textLayout.getAdvance();
                    break;
                }
                case JUSTIFICATION: {
                    f2 = 0.0f;
                    if (textlineLayout.wasTrimmed) break;
                    textlineLayout.textLayout = textlineLayout.textLayout.getJustifiedLayout(eventLayout.getContentWidth());
                }
            }
            textlineLayout.x = f2;
            textlineLayout.y = f;
            textlineLayout.textLayout = textlineLayout.textLayout;
            textlineLayout.height = this.lineHeight(textlineLayout.textLayout);
            f += textlineLayout.textLayout.getDescent() + textlineLayout.textLayout.getLeading();
        }
    }

    private void append_ellipsis(EventLayout eventLayout) {
        float f = 0.0f;
        float f2 = 0.0f;
        LinkedList<TextlineLayout> linkedList = new LinkedList<TextlineLayout>(eventLayout.timeLayouts);
        for (TextlineLayout textlineLayout : linkedList) {
            if (!textlineLayout.wasTrimmed) continue;
            if (textlineLayout.textLayout.isLeftToRight()) {
                f = textlineLayout.x + textlineLayout.textLayout.getVisibleAdvance();
                f2 = textlineLayout.y;
            } else {
                f = textlineLayout.x - this.eventTimeEllipsis.getAdvance();
                f2 = textlineLayout.y;
            }
            eventLayout.timeLayouts.add(new TextlineLayout(this.eventTimeEllipsis, f, f2, this.lineHeight(this.eventTimeEllipsis)));
        }
        linkedList = new LinkedList<TextlineLayout>(eventLayout.summaryLayouts);
        for (TextlineLayout textlineLayout : linkedList) {
            if (!textlineLayout.wasTrimmed) continue;
            if (textlineLayout.textLayout.isLeftToRight()) {
                f = textlineLayout.x + textlineLayout.textLayout.getVisibleAdvance();
                f2 = textlineLayout.y;
            } else {
                f = textlineLayout.x - this.eventSummaryEllipsis.getAdvance();
                f2 = textlineLayout.y;
            }
            eventLayout.summaryLayouts.add(new TextlineLayout(this.eventSummaryEllipsis, f, f2, this.lineHeight(this.eventSummaryEllipsis)));
        }
        linkedList = new LinkedList<TextlineLayout>(eventLayout.descriptionLayouts);
        for (TextlineLayout textlineLayout : linkedList) {
            if (!textlineLayout.wasTrimmed) continue;
            if (textlineLayout.textLayout.isLeftToRight()) {
                f = textlineLayout.x + textlineLayout.textLayout.getVisibleAdvance();
                f2 = textlineLayout.y;
            } else {
                f = textlineLayout.x - this.eventDescriptionEllipsis.getAdvance();
                f2 = textlineLayout.y;
            }
            eventLayout.descriptionLayouts.add(new TextlineLayout(this.eventDescriptionEllipsis, f, f2, this.lineHeight(this.eventDescriptionEllipsis)));
        }
    }

    @Override
    protected void drawHelpers(Graphics2D graphics2D) {
        if (this.getLineWidth() == 0) {
            this.draw_sys_border(graphics2D);
        }
        graphics2D.setColor(this._sys_fg);
        graphics2D.setStroke(SYS_BORDER_STROKE);
        int n = this.getX();
        int n2 = this.getY();
        int n3 = this.getContentHeight();
        if (this.getContentWidth() > 0) {
            graphics2D.drawLine(n + this.timelineWidth, n2, n + this.timelineWidth, n2 + n3);
        }
        if (this.timelineTextPadding != 0) {
            graphics2D.drawLine(n + this.timelineTextPadding, n2, n + this.timelineTextPadding, n2 + n3);
            graphics2D.drawLine(n + this.getTimeWidth() - this.timelineTextPadding, n2, n + this.getTimeWidth() - this.timelineTextPadding, n2 + n3);
        }
    }

    private FontRenderContext create_font_renderer_context() {
        return new FontRenderContext(null, this._tpl.getDisplay().isTextAntialiasing(), false);
    }

    @Override
    public boolean canCopyAttributes() {
        return true;
    }

    @Override
    public String[] attributesToCopy() {
        return attributes_to_copy;
    }

    @Override
    public boolean doHideElement() {
        return this.timetableJsonData.length() == 0 && this._placeholder_hide_if_empty;
    }

    private static enum Alignment {
        CENTER,
        LEFT,
        RIGHT,
        TOP,
        BOTTOM,
        JUSTIFICATION;

    }

    private class EventLayout {
        private float x = 0.0f;
        private float y = 0.0f;
        private float h = 0.0f;
        private float w = 0.0f;
        public Color backgroundColor = Color.BLACK;
        public Color fontColor = Color.WHITE;
        public LinkedList<TextlineLayout> timeLayouts = new LinkedList();
        public LinkedList<TextlineLayout> summaryLayouts = new LinkedList();
        public LinkedList<TextlineLayout> descriptionLayouts = new LinkedList();
        private float textHeight = 0.0f;
        private boolean reserve_description_line = true;

        private EventLayout() {
        }

        public float getContentWidth() {
            return this.w - (float)TemplateElementTimetable.this.eventTextPadding.left - (float)TemplateElementTimetable.this.eventTextPadding.right;
        }

        public float getContentHeight() {
            return this.h - (float)TemplateElementTimetable.this.eventTextPadding.top - (float)TemplateElementTimetable.this.eventTextPadding.bottom;
        }

        public float getBoxWidth() {
            return this.w;
        }

        public float getBoxHeight() {
            return this.h;
        }
    }

    private class TextlineLayout {
        public TextLayout textLayout = null;
        public float x = 0.0f;
        public float y = 0.0f;
        public float height = 0.0f;
        public boolean wasTrimmed = false;

        public TextlineLayout(TextLayout textLayout, float f, float f2, float f3) {
            this.textLayout = textLayout;
            this.x = f;
            this.y = f2;
            this.height = f3;
        }

        public TextlineLayout(TextLayout textLayout, float f, boolean bl) {
            this.textLayout = textLayout;
            this.height = f;
            this.wasTrimmed = bl;
        }
    }

    private static enum EventElement {
        TIME,
        SUMMARY,
        DESCRIPTION;

    }

    public class Padding {
        public int left = 10;
        public int top = 10;
        public int right = 0;
        public int bottom = 0;
    }
}

