/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.templates.gui;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.MemoryImageSource;
import javax.swing.JLabel;
import javax.swing.event.MouseInputAdapter;

public class TemplatePreview
extends JLabel {
    private static final long serialVersionUID = 1L;
    private BufferedImage m_image = null;
    private String m_text = null;
    private int _img_w = 0;
    private int _img_h = 0;
    private int _last_w = 0;
    private int _last_h = 0;
    private boolean m_scale_to_fit = false;
    private boolean m_scale_up = false;
    private boolean m_scale_flood = false;
    private boolean m_always_move_cursor = false;
    private Point dragging_from = new Point();
    private final MouseHandler m_mh = new MouseHandler();
    private Cursor m_transparent_cursor;
    private boolean m_draw_bounding_box = false;
    private TexturePaint checked_paint = null;

    public TemplatePreview() {
        this.setShowCursor(true);
        int[] nArray = new int[256];
        Image image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(16, 16, nArray, 0, 16));
        try {
            this.m_transparent_cursor = Toolkit.getDefaultToolkit().createCustomCursor(image, new Point(0, 0), "invisibleCursor");
        }
        catch (HeadlessException headlessException) {
            this.m_transparent_cursor = Cursor.getDefaultCursor();
        }
    }

    public void setImage(BufferedImage bufferedImage) {
        this.m_text = null;
        this.m_image = bufferedImage;
        this.calculate_canvas_dimensions(null);
        this.revalidate();
        this.repaint();
    }

    public void setTransparentBackgroundImage(BufferedImage bufferedImage) {
        this.checked_paint = new TexturePaint(bufferedImage, new Rectangle(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight()));
    }

    public void setDrawBoundingBox(boolean bl) {
        this.m_draw_bounding_box = bl;
        this.repaint();
    }

    public void setShowCursor(boolean bl) {
        if (bl) {
            this.addMouseListener(this.m_mh);
            this.addMouseMotionListener(this.m_mh);
        } else {
            this.removeMouseListener(this.m_mh);
            this.removeMouseMotionListener(this.m_mh);
            this.setCursor(this.m_transparent_cursor);
        }
    }

    @Override
    public void setText(String string) {
        this.m_text = string;
        this.m_image = null;
        this.revalidate();
        this.repaint();
    }

    public void setScaleToFit(boolean bl) {
        this.m_scale_to_fit = bl;
        this.calculate_canvas_dimensions(null);
        this.revalidate();
        this.repaint();
    }

    public boolean isScaleToFit() {
        return this.m_scale_to_fit;
    }

    public void setScaleUp(boolean bl) {
        this.m_scale_up = bl;
        this.calculate_canvas_dimensions(null);
        this.revalidate();
        this.repaint();
    }

    public boolean isScaleUp() {
        return this.m_scale_up;
    }

    public void setScaleFlood(boolean bl) {
        this.m_scale_flood = bl;
        this.calculate_canvas_dimensions(null);
        this.revalidate();
        this.repaint();
    }

    public boolean isScaleFlood() {
        return this.m_scale_flood;
    }

    public void setShowMoveCursor(boolean bl) {
        this.m_always_move_cursor = bl;
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        if (this.m_image != null) {
            this.calculate_canvas_dimensions(null);
            int n = (this.getWidth() - this._img_w) / 2;
            int n2 = (this.getHeight() - this._img_h) / 2;
            if (this.checked_paint != null) {
                ((Graphics2D)graphics).setPaint(this.checked_paint);
                graphics.fillRect(n, n2, this._img_w, this._img_h);
            }
            graphics.drawImage(this.m_image, n, n2, this._img_w, this._img_h, null);
            if (this.m_draw_bounding_box) {
                graphics.setColor(this.getForeground());
                graphics.drawRect(n, n2, this._img_w, this._img_h);
            }
        } else if (this.m_text != null) {
            this.calculate_canvas_dimensions(graphics);
            graphics.setColor(this.getForeground());
            Dimension dimension = this.getPreferredSize();
            graphics.drawString(this.m_text, (int)(((double)this.getWidth() - dimension.getWidth()) / 2.0), (int)((double)this.getHeight() - dimension.getHeight()));
            System.out.println("bbox: " + dimension);
            System.out.println("   x: " + (int)(dimension.getWidth() / 2.0));
            System.out.println("   y: " + (int)((double)this.getHeight() - dimension.getHeight()));
        }
    }

    private void calculate_canvas_dimensions(Graphics graphics) {
        if (this.m_text != null && graphics != null) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle2D rectangle2D = fontMetrics.getStringBounds(this.m_text, graphics);
            this.setPreferredSize(new Dimension((int)rectangle2D.getWidth(), (int)rectangle2D.getHeight()));
            return;
        }
        if (this.m_image == null || this.getWidth() == 0 || this.getHeight() == 0) {
            return;
        }
        if (this._last_w == this.getWidth() && this._last_h == this.getHeight()) {
            return;
        }
        if (this.m_scale_flood) {
            this._img_w = this.getWidth();
            this._img_h = this.getHeight();
        } else {
            this._img_w = this._last_w = this.m_image.getWidth();
            this._img_h = this._last_h = this.m_image.getHeight();
            if (this.m_scale_to_fit) {
                float f = (float)this._img_w / (float)this._img_h;
                int n = this.getWidth();
                int n2 = this.getHeight();
                if (this._img_w > n || this.m_scale_up) {
                    this._img_w = n;
                    this._img_h = (int)((float)this._img_w / f);
                }
                if (this._img_h > n2 || this.m_scale_up) {
                    this._img_h = n2;
                    this._img_w = (int)(f * (float)this._img_h);
                }
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.m_image != null) {
            if (this.m_scale_to_fit) {
                return super.getPreferredSize();
            }
            return new Dimension(this.m_image.getWidth(), this.m_image.getHeight());
        }
        if (this.m_text != null) {
            // empty if block
        }
        return super.getPreferredSize();
    }

    private class MouseHandler
    extends MouseInputAdapter {
        private MouseHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!TemplatePreview.this.m_always_move_cursor) {
                TemplatePreview.this.setCursor(Cursor.getPredefinedCursor(13));
            }
            TemplatePreview.this.dragging_from.setLocation(mouseEvent.getPoint());
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            int n = -((int)((double)mouseEvent.getX() - TemplatePreview.this.dragging_from.getX()));
            int n2 = -((int)((double)mouseEvent.getY() - TemplatePreview.this.dragging_from.getY()));
            TemplatePreview.this.dragging_from = mouseEvent.getPoint();
            TemplatePreview.this.dragging_from.x += n;
            TemplatePreview.this.dragging_from.y += n2;
            Rectangle rectangle = TemplatePreview.this.getVisibleRect();
            rectangle.x += n;
            rectangle.y += n2;
            TemplatePreview.this.scrollRectToVisible(rectangle);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!TemplatePreview.this.m_always_move_cursor) {
                TemplatePreview.this.setCursor(Cursor.getDefaultCursor());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            if (TemplatePreview.this.m_always_move_cursor) {
                TemplatePreview.this.setCursor(Cursor.getPredefinedCursor(13));
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (TemplatePreview.this.m_always_move_cursor) {
                TemplatePreview.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }
}

