/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.apps;

import de.wilke.wizepanel.upi.client.WpUpiClientRequestStatus;
import de.wilke.wizepanel.upi.client.WpUpiClientStdRequest;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.prefs.Preferences;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.EtchedBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.MatteBorder;
import javax.swing.border.TitledBorder;
import javax.swing.filechooser.FileNameExtensionFilter;

public class OnOff
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final String CONNECT = "connect";
    private static final String LSEARCH = "search left";
    private static final String RSEARCH = "search right";
    private static final String LDEFAULT = "set default left";
    private static final String RDEFAULT = "set default right";
    private static final String LSEND = "send left image";
    private static final String RSEND = "send right image";
    private static final String target = "background";
    private static final String LEFT_DEFAULT = System.getProperty("user.dir") + "\\defaultImages\\default_l.png";
    private static final String RIGHT_DEFAULT = System.getProperty("user.dir") + "\\defaultImages\\default_r.png";
    private static String LEFT_IMAGE = LEFT_DEFAULT;
    private static String RIGHT_IMAGE = RIGHT_DEFAULT;
    private static String activePic = "";
    private static String ip = "127.0.0.1";
    private static int port = 9000;
    private JLabel lblAktivLeft;
    private JLabel lblAktivRight;
    private ImageIcon picLeft;
    private ImageIcon picRight;
    private JLabel lblPathLeft;
    private JLabel lblPathRight;
    private JButton btnDefaultLeft;
    private JButton btnDefaultRight;
    private JPanel panelLeft;
    private JPanel panelRight;
    private JPanel panelTop;
    private JTextField tfIP;
    private JLabel lblIp;
    private JLabel lblPort;
    private JTextField tfPort;
    private JButton btnVerbinden;
    private JTextArea tpStatus;
    private JToggleButton tbtnSendLeft;
    private JToggleButton tbtnSendRight;
    private int fontSize = 10;
    private JPanel panel;
    private Preferences prefs = Preferences.userRoot().node(this.getClass().getName());
    private Thread thread2;

    public OnOff() {
        this.checkUserDefaults();
        this.setTitle("WizeScreenServer Image Switcher");
        this.setSize(653, 601);
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                OnOff.this.prefs.put("IP", OnOff.this.tfIP.getText());
                OnOff.this.prefs.put("PORT", OnOff.this.tfPort.getText());
                if (new File(System.getProperty("user.dir") + "\\defaultImages\\temp_l.png").exists()) {
                    new File(System.getProperty("user.dir") + "\\defaultImages\\temp_l.png").delete();
                }
                if (new File(System.getProperty("user.dir") + "\\defaultImages\\temp_r.png").exists()) {
                    new File(System.getProperty("user.dir") + "\\defaultImages\\temp_r.png").delete();
                }
            }
        });
        ip = this.prefs.get("IP", ip);
        System.out.println(ip);
        try {
            port = Integer.parseInt(this.prefs.get("PORT", "" + port));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("" + port);
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0};
        gridBagLayout.columnWeights = new double[]{0.0, 1.0, 0.0};
        gridBagLayout.columnWidths = new int[]{20, 300, 20};
        gridBagLayout.rowHeights = new int[]{20, 149, 330, 15};
        this.getContentPane().setLayout(gridBagLayout);
        this.panelTop = new JPanel();
        this.panelTop.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "Server Settings", 4, 2, null, null));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        this.getContentPane().add((Component)this.panelTop, gridBagConstraints);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout2.columnWeights = new double[]{0.0, 0.0, 0.0, 1.0, 0.0};
        gridBagLayout2.columnWidths = new int[]{60, 180, 0, 199, 100};
        gridBagLayout2.rowHeights = new int[]{40, 40, 40};
        this.panelTop.setLayout(gridBagLayout2);
        this.lblIp = new JLabel("IP");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        this.panelTop.add((Component)this.lblIp, gridBagConstraints2);
        this.tfIP = new JTextField();
        this.tfIP.setText(ip);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 1;
        gridBagConstraints3.gridy = 0;
        this.panelTop.add((Component)this.tfIP, gridBagConstraints3);
        this.tfIP.setColumns(10);
        this.lblPort = new JLabel("Port");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 13;
        gridBagConstraints4.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 1;
        this.panelTop.add((Component)this.lblPort, gridBagConstraints4);
        this.tfPort = new JTextField();
        this.tfPort.setText("" + port);
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridx = 1;
        gridBagConstraints5.gridy = 1;
        this.panelTop.add((Component)this.tfPort, gridBagConstraints5);
        this.tfPort.setColumns(10);
        this.btnVerbinden = new JButton("Verbindung testen");
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints6.gridx = 1;
        gridBagConstraints6.gridy = 2;
        this.btnVerbinden.setActionCommand(CONNECT);
        this.btnVerbinden.addActionListener(this);
        this.tpStatus = new JTextArea();
        this.tpStatus.setEditable(false);
        this.tpStatus.setText("");
        this.tpStatus.setForeground(Color.BLACK);
        this.tpStatus.setBorder(new TitledBorder(new LineBorder(new Color(0, 0, 0)), "Verbindungsstatus", 4, 2, null, null));
        this.tpStatus.setLineWrap(true);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridheight = 3;
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.gridx = 3;
        gridBagConstraints7.gridy = 0;
        this.panelTop.add((Component)this.tpStatus, gridBagConstraints7);
        this.panelTop.add((Component)this.btnVerbinden, gridBagConstraints6);
        this.panel = new JPanel();
        this.panel.setBorder(new LineBorder(new Color(0, 0, 0), 0));
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.gridx = 1;
        gridBagConstraints8.gridy = 2;
        this.getContentPane().add((Component)this.panel, gridBagConstraints8);
        this.panel.setLayout(new GridLayout(0, 2, 0, 0));
        this.panelLeft = new JPanel();
        this.panel.add(this.panelLeft);
        this.panelLeft.setBorder(new MatteBorder(1, 1, 1, 1, new Color(0, 0, 0)));
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        gridBagLayout3.columnWeights = new double[]{1.0};
        gridBagLayout3.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gridBagLayout3.columnWidths = new int[]{300};
        gridBagLayout3.rowHeights = new int[]{10, 210, 10, 40, 40, 0};
        this.panelLeft.setLayout(gridBagLayout3);
        this.lblAktivLeft = new JLabel("inaktiv");
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 1;
        gridBagConstraints9.gridx = 0;
        gridBagConstraints9.gridy = 0;
        this.panelLeft.add((Component)this.lblAktivLeft, gridBagConstraints9);
        this.lblAktivLeft.setForeground(new Color(0, 0, 0));
        this.lblAktivLeft.setBackground(new Color(50, 205, 50));
        this.lblAktivLeft.setOpaque(false);
        this.lblAktivLeft.setBorder(new EtchedBorder(1, Color.GRAY, Color.LIGHT_GRAY));
        this.lblAktivLeft.setHorizontalAlignment(0);
        this.lblAktivLeft.setEnabled(false);
        this.btnDefaultLeft = new JButton("als Standardbild setzen");
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.fill = 2;
        gridBagConstraints10.gridx = 0;
        gridBagConstraints10.gridy = 3;
        this.btnDefaultLeft.setActionCommand(LDEFAULT);
        this.btnDefaultLeft.addActionListener(this);
        this.tbtnSendLeft = new JToggleButton("");
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 1;
        gridBagConstraints11.gridx = 0;
        gridBagConstraints11.gridy = 1;
        this.panelLeft.add((Component)this.tbtnSendLeft, gridBagConstraints11);
        this.tbtnSendLeft.setActionCommand(LSEND);
        this.tbtnSendLeft.addActionListener(this);
        this.setImage(LEFT_IMAGE, "left");
        this.lblPathLeft = new JLabel(new File(LEFT_IMAGE).getName());
        this.lblPathLeft.setFont(new Font("Tahoma", 0, 10));
        this.lblPathLeft.setToolTipText(LEFT_IMAGE);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = 0;
        gridBagConstraints12.gridy = 2;
        this.panelLeft.add((Component)this.lblPathLeft, gridBagConstraints12);
        this.panelLeft.add((Component)this.btnDefaultLeft, gridBagConstraints10);
        JButton jButton = new JButton("durchsuchen...");
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.fill = 2;
        gridBagConstraints13.gridx = 0;
        gridBagConstraints13.gridy = 4;
        jButton.setActionCommand(LSEARCH);
        jButton.addActionListener(this);
        this.panelLeft.add((Component)jButton, gridBagConstraints13);
        this.panelRight = new JPanel();
        this.panel.add(this.panelRight);
        this.panelRight.setBorder(new MatteBorder(1, 0, 1, 1, new Color(0, 0, 0)));
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        gridBagLayout4.columnWeights = new double[]{1.0};
        gridBagLayout4.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        gridBagLayout4.columnWidths = new int[]{300};
        gridBagLayout4.rowHeights = new int[]{10, 210, 10, 40, 40, 0};
        this.panelRight.setLayout(gridBagLayout4);
        this.lblAktivRight = new JLabel("inaktiv");
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.fill = 1;
        gridBagConstraints14.gridx = 0;
        gridBagConstraints14.gridy = 0;
        this.lblAktivRight.setBackground(new Color(50, 205, 50));
        this.lblAktivRight.setOpaque(false);
        this.lblAktivRight.setBorder(new EtchedBorder(1, Color.GRAY, Color.LIGHT_GRAY));
        this.lblAktivRight.setHorizontalAlignment(0);
        this.panelRight.add((Component)this.lblAktivRight, gridBagConstraints14);
        this.lblAktivRight.setEnabled(false);
        this.btnDefaultRight = new JButton("als Standardbild setzen");
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.fill = 2;
        gridBagConstraints15.gridx = 0;
        gridBagConstraints15.gridy = 3;
        this.btnDefaultRight.setActionCommand(RDEFAULT);
        this.btnDefaultRight.addActionListener(this);
        this.panelRight.add((Component)this.btnDefaultRight, gridBagConstraints15);
        this.tbtnSendRight = new JToggleButton("");
        GridBagConstraints gridBagConstraints16 = new GridBagConstraints();
        gridBagConstraints16.fill = 1;
        gridBagConstraints16.gridx = 0;
        gridBagConstraints16.gridy = 1;
        this.panelRight.add((Component)this.tbtnSendRight, gridBagConstraints16);
        this.tbtnSendRight.setActionCommand(RSEND);
        this.tbtnSendRight.addActionListener(this);
        this.setImage(RIGHT_IMAGE, "right");
        this.lblPathRight = new JLabel(new File(RIGHT_IMAGE).getName());
        this.lblPathRight.setFont(new Font("Tahoma", 0, this.fontSize));
        this.lblPathRight.setToolTipText(RIGHT_IMAGE);
        GridBagConstraints gridBagConstraints17 = new GridBagConstraints();
        gridBagConstraints17.gridx = 0;
        gridBagConstraints17.gridy = 2;
        this.panelRight.add((Component)this.lblPathRight, gridBagConstraints17);
        JButton jButton2 = new JButton("durchsuchen...");
        GridBagConstraints gridBagConstraints18 = new GridBagConstraints();
        gridBagConstraints18.fill = 2;
        gridBagConstraints18.gridx = 0;
        gridBagConstraints18.gridy = 4;
        jButton2.setActionCommand(RSEARCH);
        jButton2.addActionListener(this);
        this.panelRight.add((Component)jButton2, gridBagConstraints18);
        this.tpStatus.setForeground(Color.BLACK);
        this.tpStatus.setText("Verbindungsaufbau zum Server. Bitte warten...");
        this.pack();
        this.thread2 = new Thread(new Runnable(){

            @Override
            public void run() {
                OnOff.this.testConnection();
            }
        });
        if (!this.thread2.isAlive()) {
            this.thread2.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        String string2 = actionEvent.getActionCommand();
        if (string2 == null) {
            return;
        }
        if (string2.equals(CONNECT)) {
            if (!this.thread2.isAlive()) {
                this.thread2 = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        OnOff.this.testConnection();
                    }
                });
                this.thread2.start();
            }
        } else if (string2.equals(LSEND)) {
            if (this.tbtnSendLeft.isSelected()) {
                System.out.println("left clicked");
                this.sendImage(target, LEFT_IMAGE);
            } else {
                this.tbtnSendLeft.setSelected(true);
            }
        } else if (string2.equals(RSEND)) {
            if (this.tbtnSendRight.isSelected()) {
                this.sendImage(target, RIGHT_IMAGE);
            } else {
                this.tbtnSendRight.setSelected(true);
            }
        } else if (string2.equals(LDEFAULT)) {
            this.setAsDefault(LEFT_IMAGE, "left");
        } else if (string2.equals(RDEFAULT)) {
            this.setAsDefault(RIGHT_IMAGE, "right");
        } else if (string2.equals(LSEARCH)) {
            String string3 = this.searchImage();
            if (!string3.equals("")) {
                if (this.tbtnSendLeft.isSelected()) {
                    activePic = "";
                    this.tbtnSendLeft.setSelected(false);
                    this.lblAktivLeft.setText("inaktiv");
                    this.lblAktivLeft.setOpaque(false);
                    this.lblAktivLeft.setEnabled(false);
                }
                this.setImage(string3, "left");
                this.lblPathLeft.setText(LEFT_IMAGE);
            }
        } else if (string2.equals(RSEARCH) && !(string = this.searchImage()).equals("")) {
            if (this.tbtnSendRight.isSelected()) {
                activePic = "";
                this.tbtnSendRight.setSelected(false);
                this.lblAktivRight.setText("inaktiv");
                this.lblAktivRight.setEnabled(false);
                this.lblAktivRight.setOpaque(false);
                this.lblPathRight.setText(RIGHT_IMAGE);
            }
            this.setImage(string, "right");
            this.lblPathRight.setText(RIGHT_IMAGE);
        }
    }

    private static void check_reply(WpUpiClientRequestStatus wpUpiClientRequestStatus) throws Exception {
        if (wpUpiClientRequestStatus == null || !wpUpiClientRequestStatus.isOk()) {
            Exception exception = new Exception(wpUpiClientRequestStatus.getStatus() + ": " + wpUpiClientRequestStatus.getError() + " [" + wpUpiClientRequestStatus.getData() + "]");
            throw exception;
        }
    }

    private void switchImage() {
        if (activePic.equals("left")) {
            this.tbtnSendRight.setSelected(false);
            this.lblAktivLeft.setText("aktiv");
            this.lblAktivRight.setText("inaktiv");
            this.lblAktivLeft.setOpaque(true);
            this.lblAktivRight.setOpaque(false);
            this.lblAktivLeft.setEnabled(true);
            this.lblAktivRight.setEnabled(false);
        } else {
            this.tbtnSendLeft.setSelected(false);
            this.lblAktivLeft.setText("inaktiv");
            this.lblAktivRight.setText("aktiv");
            this.lblAktivLeft.setOpaque(false);
            this.lblAktivRight.setOpaque(true);
            this.lblAktivLeft.setEnabled(false);
            this.lblAktivRight.setEnabled(true);
        }
    }

    private void sendImage(final String string, final String string2) {
        if (!this.thread2.isAlive()) {
            this.thread2 = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (OnOff.this.testConnection()) {
                        WpUpiClientStdRequest wpUpiClientStdRequest = new WpUpiClientStdRequest(OnOff.this.tfIP.getText(), Integer.parseInt(OnOff.this.tfPort.getText()));
                        try {
                            WpUpiClientRequestStatus wpUpiClientRequestStatus = wpUpiClientStdRequest.requestPutTargetImage(string, string2, true).exec();
                            OnOff.check_reply(wpUpiClientRequestStatus);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        activePic = string2.equals(LEFT_IMAGE) ? "left" : "right";
                        OnOff.this.switchImage();
                    } else if (string2.equals(LEFT_IMAGE)) {
                        OnOff.this.tbtnSendLeft.setSelected(false);
                    } else {
                        OnOff.this.tbtnSendRight.setSelected(false);
                    }
                }
            });
            this.thread2.start();
        }
    }

    private boolean testConnection() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                OnOff.this.tpStatus.setForeground(Color.BLACK);
                OnOff.this.tpStatus.setText("Verbindungsaufbau zum Server. Bitte warten...");
                OnOff.this.btnVerbinden.setEnabled(false);
            }
        });
        try {
            WpUpiClientStdRequest wpUpiClientStdRequest = new WpUpiClientStdRequest(this.tfIP.getText(), Integer.parseInt(this.tfPort.getText()));
            WpUpiClientRequestStatus wpUpiClientRequestStatus = wpUpiClientStdRequest.requestGetSystemVersion().exec();
            OnOff.check_reply(wpUpiClientRequestStatus);
            System.out.println("Verbindung erfolgreich");
            this.tpStatus.setForeground(Color.GREEN);
            this.tpStatus.setText("Verbindung erfolgreich hergestellt.");
            this.btnVerbinden.setEnabled(true);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.out.println("Verbindung gescheitert");
            this.tpStatus.setForeground(Color.RED);
            this.tpStatus.setText("Verbindungsfehler: Es konnte keine Verbindung zum Server hergestellt werden.\n\nStarten Sie den Server oder \u00c3\u00bcberpr\u00c3\u00bcfen Sie die Verbindungsparameter.");
            this.btnVerbinden.setEnabled(true);
            return false;
        }
    }

    private void checkUserDefaults() {
        if (new File(System.getProperty("user.dir") + "\\defaultImages\\user_default_l.png").exists()) {
            LEFT_IMAGE = System.getProperty("user.dir") + "\\defaultImages\\user_default_l.png";
        }
        if (new File(System.getProperty("user.dir") + "\\defaultImages\\user_default_r.png").exists()) {
            RIGHT_IMAGE = System.getProperty("user.dir") + "\\defaultImages\\user_default_r.png";
        }
    }

    public void setImage(String string, String string2) {
        try {
            if (!new File(string).exists()) {
                new File(string).createNewFile();
                throw new IOException(string + " wurde nicht gefunden!");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this, string + " wurde nicht gefunden! Es wurde eine Dummydatei erzeugt.", "Dateifehler", 0);
        }
        try {
            if (string2.equals("left")) {
                this.picLeft = new ImageIcon(this.convertToPng(string, "left"));
                this.picLeft.setImage(this.scaleImage(this.picLeft.getImage(), ImageIO.read(new File(string)).getHeight(), ImageIO.read(new File(string)).getWidth()));
                this.tbtnSendLeft.setIcon(this.picLeft);
                LEFT_IMAGE = string;
            } else {
                this.picRight = new ImageIcon(this.convertToPng(string, "right"));
                this.picRight.setImage(this.scaleImage(this.picRight.getImage(), ImageIO.read(new File(string)).getHeight(), ImageIO.read(new File(string)).getWidth()));
                this.tbtnSendRight.setIcon(this.picRight);
                RIGHT_IMAGE = string;
            }
        }
        catch (IOException iOException) {
            System.out.println("scaling error");
            iOException.printStackTrace();
        }
    }

    private Image scaleImage(Image image, double d, double d2) {
        int n = 200;
        if (d2 >= d) {
            d = d * (double)n / d2;
            d2 = n;
        } else {
            d2 = d2 * (double)n / d;
            d = n;
        }
        return image.getScaledInstance((int)d2, (int)d, 0);
    }

    private String searchImage() {
        System.out.println("search called");
        String string = "";
        String string2 = "";
        while (true) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setDialogTitle("Bilddatei w\u00c3\u00a4hlen...");
            jFileChooser.setFileFilter(new FileNameExtensionFilter("Imagefilter: png, gif, bmp, jpg", "png", "gif", "bmp", "jpg"));
            int n = jFileChooser.showOpenDialog(this.getParent());
            if (n == 1) {
                System.out.println("result " + n);
                break;
            }
            String string3 = jFileChooser.getSelectedFile().getAbsolutePath();
            string = string3.substring(string3.lastIndexOf("."));
            if ((string = string.toLowerCase()).equals(".png") || string.equals(".gif") || string.equals(".bmp") || string.equals(".jpg")) {
                System.out.println("extension ok");
                string2 = jFileChooser.getSelectedFile().getAbsolutePath();
                break;
            }
            JOptionPane.showMessageDialog(this, "Bitte w\u00c3\u00a4hlen Sie eine Datei mit unterst\u00c3\u00bctztem Dateiformat (bmp, gif, jpg, png)", "Formatfehler", 1);
        }
        return string2;
    }

    private String convertToPng(String string, String string2) {
        File file = string2.equals("left") ? new File(System.getProperty("user.dir") + "\\defaultImages\\temp_l.png") : new File(System.getProperty("user.dir") + "\\defaultImages\\temp_r.png");
        if (file.exists()) {
            file.delete();
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this, "Die Datei " + string + " konnte nicht als tempor\u00c3\u00a4re png-Datei geschrieben werden.", "Lese- oder Schreibfehler", 0);
        }
        return file.getAbsolutePath();
    }

    private void setAsDefault(String string, String string2) {
        File file = string2.equals("left") ? new File(System.getProperty("user.dir") + "\\defaultImages\\user_default_l.png") : new File(System.getProperty("user.dir") + "\\defaultImages\\user_default_r.png");
        if (file.exists()) {
            file.delete();
        }
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this, "Die Datei " + string + " konnte nicht als default nach " + System.getProperty("user.dir") + "\\defaultImages\\ kopiert werden.", "Lese- oder Schreibfehler", 0);
        }
    }

    public static void main(String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new OnOff().setVisible(true);
            }
        });
    }
}

