/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.routing;

import de.wilke.wizepanel.upi.IUpiJsonable;
import de.wilke.wizepanel.upi.routing.AWpUpiRoutingItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingNaming;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import de.wilke.wizepanel.upi.routing.jaxb.ObjectFactory;
import de.wilke.wizepanel.upi.routing.jaxb.RouterType;
import de.wilke.wizepanel.upi.types.RouterParameters;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.json.JSONException;
import org.json.JSONObject;

public class UpiRouterItem
extends AWpUpiRoutingItem
implements IUpiJsonable {
    private RouterParameters params = new RouterParameters();
    private List<UpiTargetItem> targets = new LinkedList<UpiTargetItem>();

    public UpiRouterItem() {
    }

    public UpiRouterItem(String string) {
        super(string);
    }

    public UpiRouterItem(UpiRouterItem upiRouterItem) {
        this.InitItemByCopy(upiRouterItem);
    }

    public UpiRouterItem(RouterType routerType) {
        this.InitItemByJaxbType(routerType);
    }

    public UpiRouterItem(JSONObject jSONObject) throws JSONException {
        this.fromJson(jSONObject);
    }

    @Override
    public void InitItemByCopy(Object object) {
        if (object == null || !(object instanceof UpiRouterItem)) {
            return;
        }
        UpiRouterItem upiRouterItem = (UpiRouterItem)object;
        super.InitItemByCopy(upiRouterItem);
        this.setId(upiRouterItem.getId());
        this.params = upiRouterItem.params;
    }

    public void InitItemByJaxbType(RouterType routerType) {
        if (null == routerType) {
            return;
        }
        this.setId(routerType.getId());
        this.params = new RouterParameters(routerType.getRouterparams());
    }

    public RouterType assignItemValuesToJaxbTypeRoot() {
        ObjectFactory objectFactory = new ObjectFactory();
        RouterType routerType = objectFactory.createRouterType();
        routerType.setId(this.getId());
        routerType.setRouterparams(this.params.toString());
        return routerType;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.params == null ? 0 : this.params.hashCode());
        n = 31 * n + (this.targets == null ? 0 : this.targets.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        UpiRouterItem upiRouterItem = (UpiRouterItem)object;
        if (this.params == null ? upiRouterItem.params != null : !this.params.equals(upiRouterItem.params)) {
            return false;
        }
        return !(this.targets == null ? upiRouterItem.targets != null : !this.targets.equals(upiRouterItem.targets));
    }

    public void setParams(RouterParameters routerParameters) {
        this.params = routerParameters;
    }

    public RouterParameters getParams() {
        return this.params;
    }

    public List<UpiTargetItem> getTargets() {
        return this.targets;
    }

    public UpiTargetItem getTargetById(String string) {
        for (UpiTargetItem upiTargetItem : this.targets) {
            if (!upiTargetItem.getId().equals(string)) continue;
            return upiTargetItem;
        }
        return null;
    }

    @XmlElementWrapper(name="targetList")
    @XmlElement(name="target")
    public UpiRouterItem setTargets(List<UpiTargetItem> list) {
        this.targets = list;
        return this;
    }

    @Override
    public void fromJson(JSONObject jSONObject) throws JSONException {
        JSONObject jSONObject2 = jSONObject;
        this.setId(jSONObject2.getString(UpiRoutingNaming.UpiRoutingRouterParams.ID.toString()));
        this.params = new RouterParameters(jSONObject2.getString(UpiRoutingNaming.UpiRoutingRouterParams.SERVER_PARAMS.toString()));
    }

    @Override
    public JSONObject toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(UpiRoutingNaming.UpiRoutingRouterParams.ID.toString(), (Object)this.getId());
        jSONObject.put(UpiRoutingNaming.UpiRoutingRouterParams.SERVER_PARAMS.toString(), (Object)this.params.toString());
        return jSONObject;
    }

    public void addTarget(UpiTargetItem upiTargetItem) {
        this.targets.add(upiTargetItem);
    }

    public void removeTarget(UpiTargetItem upiTargetItem) {
        this.targets.remove(upiTargetItem);
    }

    public String getFormattedId() {
        return this.params.getName();
    }

    public String toString() {
        try {
            return this.toJson().toString();
        }
        catch (JSONException jSONException) {
            return this.getId();
        }
    }
}

