/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.routing.old;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

class JaxbContextHandler<RootType> {
    private JAXBContext jContext;
    private Unmarshaller unmarshaller;
    private Marshaller marshaller;
    private String jaxbContextInstancePath;
    private String storageFileName;

    public JaxbContextHandler(String string) {
        this.jaxbContextInstancePath = string;
        try {
            this.jContext = JAXBContext.newInstance((String)this.jaxbContextInstancePath);
            this.unmarshaller = this.jContext.createUnmarshaller();
            this.marshaller = this.jContext.createMarshaller();
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
    }

    public void setStorageFile(String string) {
        this.storageFileName = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAXBElement<RootType> readFromFile() {
        JAXBElement jAXBElement = null;
        try {
            this.createUnMarshallerIfNeeded();
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(this.storageFileName);
                jAXBElement = (JAXBElement)this.unmarshaller.unmarshal((InputStream)fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                if (null != fileInputStream) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        return jAXBElement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(JAXBElement<RootType> jAXBElement) {
        try {
            this.createMarshallerIfNeeded();
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(this.storageFileName);
                this.marshaller.marshal(jAXBElement, (OutputStream)fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                fileNotFoundException.printStackTrace();
            }
            finally {
                if (null != fileOutputStream) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
    }

    public JAXBElement<RootType> readFromString(String string) {
        JAXBElement jAXBElement = null;
        try {
            this.createUnMarshallerIfNeeded();
            jAXBElement = (JAXBElement)this.unmarshaller.unmarshal((Source)new StreamSource(new StringReader(string)));
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
        return jAXBElement;
    }

    public String writeToString(JAXBElement<RootType> jAXBElement) {
        try {
            this.createMarshallerIfNeeded();
            this.marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter stringWriter = new StringWriter();
            this.marshaller.marshal(jAXBElement, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return null;
        }
    }

    private void createMarshallerIfNeeded() {
        try {
            if (this.marshaller == null) {
                if (this.jContext == null) {
                    this.jContext = JAXBContext.newInstance((String)this.jaxbContextInstancePath);
                }
                if (this.jContext != null) {
                    this.marshaller = this.jContext.createMarshaller();
                }
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
    }

    private void createUnMarshallerIfNeeded() {
        try {
            if (this.unmarshaller == null) {
                if (this.jContext == null) {
                    this.jContext = JAXBContext.newInstance((String)this.jaxbContextInstancePath);
                }
                if (this.jContext != null) {
                    this.unmarshaller = this.jContext.createUnmarshaller();
                }
            }
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
        }
    }
}

