/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.types;

import de.wilke.wizepanel.upi.UpiResDescrNaming;
import org.json.JSONException;
import org.json.JSONObject;

public class RouterParameters {
    public static final String PARAM_MAXWP = "maxwp";
    public static final String PARAM_LASTSEEN = "lastseen";
    public static final String PARAM_STATUS = "status";
    public static final String PARAM_TIMEZONE = "timezone";
    public static final String PARAM_DHCP = "dhcp";
    public static final String PARAM_NAME = "name";
    private String ip = "";
    private int port = 0;
    private String name = "";
    private String subnet = "";
    private String gateway = "";
    private String mac = "";
    private String version = "v1.08";
    private int maxwp = -1;
    private boolean dhcp = false;
    private int last_seen = -1;
    private String status = "";
    private String time_zone = "";

    public RouterParameters() {
    }

    public void importFrom(RouterParameters routerParameters) {
        this.ip = routerParameters.ip;
        this.port = routerParameters.port;
        this.name = routerParameters.name;
        this.subnet = routerParameters.subnet;
        this.gateway = routerParameters.gateway;
        this.mac = routerParameters.mac;
        this.version = routerParameters.version;
        this.maxwp = routerParameters.maxwp;
        this.last_seen = routerParameters.last_seen;
        this.status = routerParameters.status;
        this.time_zone = routerParameters.time_zone;
        this.dhcp = routerParameters.dhcp;
    }

    public RouterParameters(String string) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return;
        }
        this.importFrom(jSONObject);
    }

    public void importFrom(JSONObject jSONObject) {
        try {
            this.ip = jSONObject.getString(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_IP.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.port = jSONObject.getInt(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_PORT.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.name = jSONObject.getString(PARAM_NAME);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.mac = jSONObject.getString(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_MAC.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.subnet = jSONObject.getString(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_SUBNET.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.gateway = jSONObject.getString(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_GATEWAY.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.version = jSONObject.getString(UpiResDescrNaming.UpiResDescrStandardEntry.RESOURCE_ROUTER_VERSION.toString());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.maxwp = jSONObject.getInt(PARAM_MAXWP);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.last_seen = jSONObject.getInt(PARAM_LASTSEEN);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.status = jSONObject.getString(PARAM_STATUS);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.time_zone = jSONObject.getString(PARAM_TIMEZONE);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            this.dhcp = jSONObject.getBoolean(PARAM_DHCP);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }

    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_IP.toString(), (Object)this.ip);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_PORT.toString(), this.port);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_MAC.toString(), (Object)this.mac);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_SUBNET.toString(), (Object)this.subnet);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(UpiResDescrNaming.UpiResDescrIpAddress.RESPAR_ROUTER_GATEWAY.toString(), (Object)this.gateway);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(UpiResDescrNaming.UpiResDescrStandardEntry.RESOURCE_ROUTER_VERSION.toString(), (Object)this.version);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(PARAM_MAXWP, this.maxwp);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(PARAM_LASTSEEN, this.last_seen);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(PARAM_STATUS, (Object)this.status);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(PARAM_TIMEZONE, (Object)this.time_zone);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(PARAM_DHCP, this.dhcp);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        try {
            jSONObject.put(PARAM_NAME, (Object)this.name);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jSONObject;
    }

    public String toString() {
        try {
            return this.toJSON().toString(4);
        }
        catch (JSONException jSONException) {
            return this.toJSON().toString();
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.dhcp ? 1231 : 1237);
        n = 31 * n + (this.gateway == null ? 0 : this.gateway.hashCode());
        n = 31 * n + (this.name == null ? 0 : this.name.hashCode());
        n = 31 * n + (this.ip == null ? 0 : this.ip.hashCode());
        n = 31 * n + this.last_seen;
        n = 31 * n + (this.mac == null ? 0 : this.mac.hashCode());
        n = 31 * n + this.maxwp;
        n = 31 * n + this.port;
        n = 31 * n + (this.status == null ? 0 : this.status.hashCode());
        n = 31 * n + (this.subnet == null ? 0 : this.subnet.hashCode());
        n = 31 * n + (this.time_zone == null ? 0 : this.time_zone.hashCode());
        n = 31 * n + (this.version == null ? 0 : this.version.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        RouterParameters routerParameters = (RouterParameters)object;
        if (this.dhcp != routerParameters.dhcp) {
            return false;
        }
        if (this.gateway == null ? routerParameters.gateway != null : !this.gateway.equals(routerParameters.gateway)) {
            return false;
        }
        if (this.name == null ? routerParameters.name != null : !this.name.equals(routerParameters.name)) {
            return false;
        }
        if (this.ip == null ? routerParameters.ip != null : !this.ip.equals(routerParameters.ip)) {
            return false;
        }
        if (this.last_seen != routerParameters.last_seen) {
            return false;
        }
        if (this.mac == null ? routerParameters.mac != null : !this.mac.equals(routerParameters.mac)) {
            return false;
        }
        if (this.maxwp != routerParameters.maxwp) {
            return false;
        }
        if (this.port != routerParameters.port) {
            return false;
        }
        if (this.status == null ? routerParameters.status != null : !this.status.equals(routerParameters.status)) {
            return false;
        }
        if (this.subnet == null ? routerParameters.subnet != null : !this.subnet.equals(routerParameters.subnet)) {
            return false;
        }
        if (this.time_zone == null ? routerParameters.time_zone != null : !this.time_zone.equals(routerParameters.time_zone)) {
            return false;
        }
        return !(this.version == null ? routerParameters.version != null : !this.version.equals(routerParameters.version));
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String string) {
        this.ip = string;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getSubnet() {
        return this.subnet;
    }

    public void setSubnet(String string) {
        this.subnet = string;
    }

    public String getGateway() {
        return this.gateway;
    }

    public void setGateway(String string) {
        this.gateway = string;
    }

    public String getMac() {
        return this.mac;
    }

    public void setMac(String string) {
        this.mac = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public int getMaxWP() {
        return this.maxwp;
    }

    public void setMaxWP(int n) {
        this.maxwp = n;
    }

    public int getLastSeen() {
        return this.last_seen;
    }

    public void setLastSeen(int n) {
        this.last_seen = n;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public String getTimeZone() {
        return this.time_zone;
    }

    public void setTimeZone(String string) {
        this.time_zone = string;
    }

    public boolean isDHCP() {
        return this.dhcp;
    }

    public void setDHCP(boolean bl) {
        this.dhcp = bl;
    }

    public boolean equalsCore(RouterParameters routerParameters) {
        if (this.ip == null ? routerParameters.ip != null : !this.ip.equals(routerParameters.ip)) {
            return false;
        }
        if (this.port != routerParameters.port) {
            return false;
        }
        if (this.subnet == null ? routerParameters.subnet != null : !this.subnet.equals(routerParameters.subnet)) {
            return false;
        }
        if (this.gateway == null ? routerParameters.gateway != null : !this.gateway.equals(routerParameters.gateway)) {
            return false;
        }
        return !(this.mac == null ? routerParameters.mac != null : !this.mac.equals(routerParameters.mac));
    }

    public String getName() {
        if (this.name.length() < 1) {
            return this.getIp() + ":" + this.getPort();
        }
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }
}

