/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.StringsResourceTranslator;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public final class HtmlAssetTranslator {
    private static final Pattern COMMA = Pattern.compile(",");

    private HtmlAssetTranslator() {
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length < 3) {
            System.err.println("Usage: HtmlAssetTranslator android/assets/ (all|lang1[,lang2 ...]) (all|file1.html[ file2.html ...])");
            return;
        }
        File file = new File(stringArray[0]);
        Collection<String> collection = HtmlAssetTranslator.parseLanguagesToTranslate(file, stringArray[1]);
        List<String> list = Arrays.asList(stringArray).subList(2, stringArray.length);
        Collection<String> collection2 = HtmlAssetTranslator.parseFileNamesToTranslate(file, list);
        for (String string : collection) {
            HtmlAssetTranslator.translateOneLanguage(file, string, collection2);
        }
    }

    private static Collection<String> parseLanguagesToTranslate(File file, CharSequence charSequence) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("all".equals(charSequence)) {
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory() && file.getName().startsWith("html-") && !"html-en".equals(file.getName());
                }
            };
            for (File file2 : file.listFiles(fileFilter)) {
                arrayList.add(file2.getName().substring(5));
            }
        } else {
            arrayList.addAll(Arrays.asList(COMMA.split(charSequence)));
        }
        return arrayList;
    }

    private static Collection<String> parseFileNamesToTranslate(File file, List<String> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if ("all".equals(list.get(0))) {
            File file2 = new File(file, "html-en");
            FileFilter fileFilter = new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().endsWith(".html");
                }
            };
            for (File file3 : file2.listFiles(fileFilter)) {
                arrayList.add(file3.getName());
            }
        } else {
            for (String string : list) {
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private static void translateOneLanguage(File file, String string, final Collection<String> collection) throws IOException {
        File[] fileArray;
        File file2 = new File(file, "html-" + string);
        file2.mkdirs();
        File file3 = new File(file, "html-en");
        String string2 = StringsResourceTranslator.translateString("Translated by Google Translate.", string);
        for (File file4 : fileArray = file3.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string) {
                return string.endsWith(".html") && (collection.isEmpty() || collection.contains(string));
            }
        })) {
            HtmlAssetTranslator.translateOneFile(string, file2, file4, string2);
        }
    }

    private static void translateOneFile(String string, File file, File file2, String string2) throws IOException {
        DOMImplementationRegistry dOMImplementationRegistry;
        Object object;
        Node node;
        Document document;
        Object object2;
        File file3 = new File(file, file2.getName());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            object2 = documentBuilderFactory.newDocumentBuilder();
            document = ((DocumentBuilder)object2).parse(file2);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IllegalStateException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            throw new IOException(sAXException);
        }
        object2 = document.getDocumentElement();
        object2.normalize();
        LinkedList<Object> linkedList = new LinkedList<Object>();
        linkedList.add(object2);
        while (!linkedList.isEmpty()) {
            node = (Node)linkedList.poll();
            if (HtmlAssetTranslator.shouldTranslate(node)) {
                object = node.getChildNodes();
                for (int i = 0; i < object.getLength(); ++i) {
                    linkedList.add(object.item(i));
                }
            }
            if (node.getNodeType() != 3 || ((String)(object = node.getTextContent())).trim().isEmpty()) continue;
            object = StringsResourceTranslator.translateString((String)object, string);
            node.setTextContent(" " + (String)object + " ");
        }
        node = document.createTextNode(string2);
        object = document.createElement("p");
        object.appendChild(node);
        Node node2 = object2.getElementsByTagName("body").item(0);
        node2.appendChild((Node)object);
        try {
            dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new IllegalStateException(reflectiveOperationException);
        }
        DOMImplementationLS dOMImplementationLS = (DOMImplementationLS)((Object)dOMImplementationRegistry.getDOMImplementation("LS"));
        LSSerializer lSSerializer = dOMImplementationLS.createLSSerializer();
        lSSerializer.writeToURI(document, file3.toURI().toString());
    }

    private static boolean shouldTranslate(Node node) {
        String string;
        Object object;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (object = namedNodeMap.getNamedItem("class")) != null && (string = object.getTextContent()) != null && string.contains("notranslate")) {
            return false;
        }
        object = node.getNodeName();
        if ("script".equalsIgnoreCase((String)object)) {
            return false;
        }
        string = node.getTextContent();
        if (string != null) {
            for (int i = 0; i < string.length(); ++i) {
                if (!Character.isLetter(string.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }
}

