/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing;

import com.google.zxing.LuminanceSource;

public final class PlanarYUVLuminanceSource
extends LuminanceSource {
    private static final int THUMBNAIL_SCALE_FACTOR = 2;
    private final byte[] yuvData;
    private final int dataWidth;
    private final int dataHeight;
    private final int left;
    private final int top;

    public PlanarYUVLuminanceSource(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        super(n5, n6);
        if (n3 + n5 > n || n4 + n6 > n2) {
            throw new IllegalArgumentException("Crop rectangle does not fit within image data.");
        }
        this.yuvData = byArray;
        this.dataWidth = n;
        this.dataHeight = n2;
        this.left = n3;
        this.top = n4;
        if (bl) {
            this.reverseHorizontal(n5, n6);
        }
    }

    @Override
    public byte[] getRow(int n, byte[] byArray) {
        if (n < 0 || n >= this.getHeight()) {
            throw new IllegalArgumentException("Requested row is outside the image: " + n);
        }
        int n2 = this.getWidth();
        if (byArray == null || byArray.length < n2) {
            byArray = new byte[n2];
        }
        int n3 = (n + this.top) * this.dataWidth + this.left;
        System.arraycopy(this.yuvData, n3, byArray, 0, n2);
        return byArray;
    }

    @Override
    public byte[] getMatrix() {
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n == this.dataWidth && n2 == this.dataHeight) {
            return this.yuvData;
        }
        int n3 = n * n2;
        byte[] byArray = new byte[n3];
        int n4 = this.top * this.dataWidth + this.left;
        if (n == this.dataWidth) {
            System.arraycopy(this.yuvData, n4, byArray, 0, n3);
            return byArray;
        }
        byte[] byArray2 = this.yuvData;
        for (int i = 0; i < n2; ++i) {
            int n5 = i * n;
            System.arraycopy(byArray2, n4, byArray, n5, n);
            n4 += this.dataWidth;
        }
        return byArray;
    }

    @Override
    public boolean isCropSupported() {
        return true;
    }

    @Override
    public LuminanceSource crop(int n, int n2, int n3, int n4) {
        return new PlanarYUVLuminanceSource(this.yuvData, this.dataWidth, this.dataHeight, this.left + n, this.top + n2, n3, n4, false);
    }

    public int[] renderThumbnail() {
        int n = this.getWidth() / 2;
        int n2 = this.getHeight() / 2;
        int[] nArray = new int[n * n2];
        byte[] byArray = this.yuvData;
        int n3 = this.top * this.dataWidth + this.left;
        for (int i = 0; i < n2; ++i) {
            int n4 = i * n;
            for (int j = 0; j < n; ++j) {
                int n5 = byArray[n3 + j * 2] & 0xFF;
                nArray[n4 + j] = 0xFF000000 | n5 * 65793;
            }
            n3 += this.dataWidth * 2;
        }
        return nArray;
    }

    public int getThumbnailWidth() {
        return this.getWidth() / 2;
    }

    public int getThumbnailHeight() {
        return this.getHeight() / 2;
    }

    private void reverseHorizontal(int n, int n2) {
        byte[] byArray = this.yuvData;
        int n3 = 0;
        int n4 = this.top * this.dataWidth + this.left;
        while (n3 < n2) {
            int n5 = n4 + n / 2;
            int n6 = n4;
            int n7 = n4 + n - 1;
            while (n6 < n5) {
                byte by = byArray[n6];
                byArray[n6] = byArray[n7];
                byArray[n7] = by;
                ++n6;
                --n7;
            }
            ++n3;
            n4 += this.dataWidth;
        }
    }
}

