/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.detector;

import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.aztec.AztecDetectorResult;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.detector.MathUtils;
import com.google.zxing.common.detector.WhiteRectangleDetector;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;

public final class Detector {
    private final BitMatrix image;
    private boolean compact;
    private int nbLayers;
    private int nbDataBlocks;
    private int nbCenterLayers;
    private int shift;
    private static final int[] EXPECTED_CORNER_BITS = new int[]{3808, 476, 2107, 1799};

    public Detector(BitMatrix bitMatrix) {
        this.image = bitMatrix;
    }

    public AztecDetectorResult detect() throws NotFoundException {
        return this.detect(false);
    }

    public AztecDetectorResult detect(boolean bl) throws NotFoundException {
        Object object;
        Point point = this.getMatrixCenter();
        ResultPoint[] resultPointArray = this.getBullsEyeCorners(point);
        if (bl) {
            object = resultPointArray[0];
            resultPointArray[0] = resultPointArray[2];
            resultPointArray[2] = object;
        }
        this.extractParameters(resultPointArray);
        object = this.sampleGrid(this.image, resultPointArray[this.shift % 4], resultPointArray[(this.shift + 1) % 4], resultPointArray[(this.shift + 2) % 4], resultPointArray[(this.shift + 3) % 4]);
        ResultPoint[] resultPointArray2 = this.getMatrixCornerPoints(resultPointArray);
        return new AztecDetectorResult((BitMatrix)object, resultPointArray2, this.compact, this.nbDataBlocks, this.nbLayers);
    }

    private void extractParameters(ResultPoint[] resultPointArray) throws NotFoundException {
        int n;
        if (!(this.isValid(resultPointArray[0]) && this.isValid(resultPointArray[1]) && this.isValid(resultPointArray[2]) && this.isValid(resultPointArray[3]))) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n2 = 2 * this.nbCenterLayers;
        int[] nArray = new int[]{this.sampleLine(resultPointArray[0], resultPointArray[1], n2), this.sampleLine(resultPointArray[1], resultPointArray[2], n2), this.sampleLine(resultPointArray[2], resultPointArray[3], n2), this.sampleLine(resultPointArray[3], resultPointArray[0], n2)};
        this.shift = Detector.getRotation(nArray, n2);
        long l = 0L;
        for (n = 0; n < 4; ++n) {
            int n3 = nArray[(this.shift + n) % 4];
            if (this.compact) {
                l <<= 7;
                l += (long)(n3 >> 1 & 0x7F);
                continue;
            }
            l <<= 10;
            l += (long)((n3 >> 2 & 0x3E0) + (n3 >> 1 & 0x1F));
        }
        n = Detector.getCorrectedParameterData(l, this.compact);
        if (this.compact) {
            this.nbLayers = (n >> 6) + 1;
            this.nbDataBlocks = (n & 0x3F) + 1;
        } else {
            this.nbLayers = (n >> 11) + 1;
            this.nbDataBlocks = (n & 0x7FF) + 1;
        }
    }

    private static int getRotation(int[] nArray, int n) throws NotFoundException {
        int n2 = 0;
        for (int n3 : nArray) {
            int n4 = (n3 >> n - 2 << 1) + (n3 & 1);
            n2 = (n2 << 3) + n4;
        }
        n2 = ((n2 & 1) << 11) + (n2 >> 1);
        for (int i = 0; i < 4; ++i) {
            if (Integer.bitCount(n2 ^ EXPECTED_CORNER_BITS[i]) > 2) continue;
            return i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int getCorrectedParameterData(long l, boolean bl) throws NotFoundException {
        int n;
        int n2;
        if (bl) {
            n2 = 7;
            n = 2;
        } else {
            n2 = 10;
            n = 4;
        }
        int n3 = n2 - n;
        int[] nArray = new int[n2];
        for (int i = n2 - 1; i >= 0; --i) {
            nArray[i] = (int)l & 0xF;
            l >>= 4;
        }
        try {
            ReedSolomonDecoder reedSolomonDecoder = new ReedSolomonDecoder(GenericGF.AZTEC_PARAM);
            reedSolomonDecoder.decode(nArray, n3);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n4 = 0;
        for (int i = 0; i < n; ++i) {
            n4 = (n4 << 4) + nArray[i];
        }
        return n4;
    }

    private ResultPoint[] getBullsEyeCorners(Point point) throws NotFoundException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5 = point;
        Point point2 = point;
        Point point3 = point;
        Point point4 = point;
        boolean bl = true;
        this.nbCenterLayers = 1;
        while (this.nbCenterLayers < 9) {
            float f;
            object4 = this.getFirstDifferent((Point)object5, bl, 1, -1);
            object3 = this.getFirstDifferent(point2, bl, 1, 1);
            object2 = this.getFirstDifferent(point3, bl, -1, 1);
            object = this.getFirstDifferent(point4, bl, -1, -1);
            if (this.nbCenterLayers > 2 && ((double)(f = Detector.distance((Point)object, (Point)object4) * (float)this.nbCenterLayers / (Detector.distance(point4, (Point)object5) * (float)(this.nbCenterLayers + 2))) < 0.75 || (double)f > 1.25 || !this.isWhiteOrBlackRectangle((Point)object4, (Point)object3, (Point)object2, (Point)object))) break;
            object5 = object4;
            point2 = object3;
            point3 = object2;
            point4 = object;
            bl = !bl;
            ++this.nbCenterLayers;
        }
        if (this.nbCenterLayers != 5 && this.nbCenterLayers != 7) {
            throw NotFoundException.getNotFoundInstance();
        }
        this.compact = this.nbCenterLayers == 5;
        object4 = new ResultPoint((float)((Point)object5).getX() + 0.5f, (float)((Point)object5).getY() - 0.5f);
        object3 = new ResultPoint((float)point2.getX() + 0.5f, (float)point2.getY() + 0.5f);
        object2 = new ResultPoint((float)point3.getX() - 0.5f, (float)point3.getY() + 0.5f);
        object = new ResultPoint((float)point4.getX() - 0.5f, (float)point4.getY() - 0.5f);
        return Detector.expandSquare(new ResultPoint[]{object4, object3, object2, object}, 2 * this.nbCenterLayers - 3, 2 * this.nbCenterLayers);
    }

    private Point getMatrixCenter() {
        int n;
        ResultPoint resultPoint;
        ResultPoint resultPoint2;
        ResultPoint resultPoint3;
        ResultPoint resultPoint4;
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            n = this.image.getWidth() / 2;
            int n2 = this.image.getHeight() / 2;
            resultPoint4 = this.getFirstDifferent(new Point(n + 7, n2 - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Point(n + 7, n2 + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Point(n - 7, n2 + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Point(n - 7, n2 - 7), false, -1, -1).toResultPoint();
        }
        int n3 = MathUtils.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n = MathUtils.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        try {
            ResultPoint[] resultPointArray = new WhiteRectangleDetector(this.image, 15, n3, n).detect();
            resultPoint4 = resultPointArray[0];
            resultPoint3 = resultPointArray[1];
            resultPoint2 = resultPointArray[2];
            resultPoint = resultPointArray[3];
        }
        catch (NotFoundException notFoundException) {
            resultPoint4 = this.getFirstDifferent(new Point(n3 + 7, n - 7), false, 1, -1).toResultPoint();
            resultPoint3 = this.getFirstDifferent(new Point(n3 + 7, n + 7), false, 1, 1).toResultPoint();
            resultPoint2 = this.getFirstDifferent(new Point(n3 - 7, n + 7), false, -1, 1).toResultPoint();
            resultPoint = this.getFirstDifferent(new Point(n3 - 7, n - 7), false, -1, -1).toResultPoint();
        }
        n3 = MathUtils.round((resultPoint4.getX() + resultPoint.getX() + resultPoint3.getX() + resultPoint2.getX()) / 4.0f);
        n = MathUtils.round((resultPoint4.getY() + resultPoint.getY() + resultPoint3.getY() + resultPoint2.getY()) / 4.0f);
        return new Point(n3, n);
    }

    private ResultPoint[] getMatrixCornerPoints(ResultPoint[] resultPointArray) {
        return Detector.expandSquare(resultPointArray, 2 * this.nbCenterLayers, this.getDimension());
    }

    private BitMatrix sampleGrid(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4) throws NotFoundException {
        GridSampler gridSampler = GridSampler.getInstance();
        int n = this.getDimension();
        float f = (float)n / 2.0f - (float)this.nbCenterLayers;
        float f2 = (float)n / 2.0f + (float)this.nbCenterLayers;
        return gridSampler.sampleGrid(bitMatrix, n, n, f, f, f2, f, f2, f2, f, f2, resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY(), resultPoint3.getX(), resultPoint3.getY(), resultPoint4.getX(), resultPoint4.getY());
    }

    private int sampleLine(ResultPoint resultPoint, ResultPoint resultPoint2, int n) {
        int n2 = 0;
        float f = Detector.distance(resultPoint, resultPoint2);
        float f2 = f / (float)n;
        float f3 = resultPoint.getX();
        float f4 = resultPoint.getY();
        float f5 = f2 * (resultPoint2.getX() - resultPoint.getX()) / f;
        float f6 = f2 * (resultPoint2.getY() - resultPoint.getY()) / f;
        for (int i = 0; i < n; ++i) {
            if (!this.image.get(MathUtils.round(f3 + (float)i * f5), MathUtils.round(f4 + (float)i * f6))) continue;
            n2 |= 1 << n - i - 1;
        }
        return n2;
    }

    private boolean isWhiteOrBlackRectangle(Point point, Point point2, Point point3, Point point4) {
        int n = 3;
        point = new Point(point.getX() - n, point.getY() + n);
        point2 = new Point(point2.getX() - n, point2.getY() - n);
        point3 = new Point(point3.getX() + n, point3.getY() - n);
        int n2 = this.getColor(point4 = new Point(point4.getX() + n, point4.getY() + n), point);
        if (n2 == 0) {
            return false;
        }
        int n3 = this.getColor(point, point2);
        if (n3 != n2) {
            return false;
        }
        n3 = this.getColor(point2, point3);
        if (n3 != n2) {
            return false;
        }
        n3 = this.getColor(point3, point4);
        return n3 == n2;
    }

    private int getColor(Point point, Point point2) {
        float f = Detector.distance(point, point2);
        float f2 = (float)(point2.getX() - point.getX()) / f;
        float f3 = (float)(point2.getY() - point.getY()) / f;
        int n = 0;
        float f4 = point.getX();
        float f5 = point.getY();
        boolean bl = this.image.get(point.getX(), point.getY());
        int n2 = 0;
        while ((float)n2 < f) {
            if (this.image.get(MathUtils.round(f4 += f2), MathUtils.round(f5 += f3)) != bl) {
                ++n;
            }
            ++n2;
        }
        float f6 = (float)n / f;
        if (f6 > 0.1f && f6 < 0.9f) {
            return 0;
        }
        return f6 <= 0.1f == bl ? 1 : -1;
    }

    private Point getFirstDifferent(Point point, boolean bl, int n, int n2) {
        int n3 = point.getX() + n;
        int n4 = point.getY() + n2;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n3 += n;
            n4 += n2;
        }
        n3 -= n;
        n4 -= n2;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n3 += n;
        }
        n3 -= n;
        while (this.isValid(n3, n4) && this.image.get(n3, n4) == bl) {
            n4 += n2;
        }
        return new Point(n3, n4 -= n2);
    }

    private static ResultPoint[] expandSquare(ResultPoint[] resultPointArray, float f, float f2) {
        float f3 = f2 / (2.0f * f);
        float f4 = resultPointArray[0].getX() - resultPointArray[2].getX();
        float f5 = resultPointArray[0].getY() - resultPointArray[2].getY();
        float f6 = (resultPointArray[0].getX() + resultPointArray[2].getX()) / 2.0f;
        float f7 = (resultPointArray[0].getY() + resultPointArray[2].getY()) / 2.0f;
        ResultPoint resultPoint = new ResultPoint(f6 + f3 * f4, f7 + f3 * f5);
        ResultPoint resultPoint2 = new ResultPoint(f6 - f3 * f4, f7 - f3 * f5);
        f4 = resultPointArray[1].getX() - resultPointArray[3].getX();
        f5 = resultPointArray[1].getY() - resultPointArray[3].getY();
        f6 = (resultPointArray[1].getX() + resultPointArray[3].getX()) / 2.0f;
        f7 = (resultPointArray[1].getY() + resultPointArray[3].getY()) / 2.0f;
        ResultPoint resultPoint3 = new ResultPoint(f6 + f3 * f4, f7 + f3 * f5);
        ResultPoint resultPoint4 = new ResultPoint(f6 - f3 * f4, f7 - f3 * f5);
        return new ResultPoint[]{resultPoint, resultPoint3, resultPoint2, resultPoint4};
    }

    private boolean isValid(int n, int n2) {
        return n >= 0 && n < this.image.getWidth() && n2 > 0 && n2 < this.image.getHeight();
    }

    private boolean isValid(ResultPoint resultPoint) {
        int n = MathUtils.round(resultPoint.getX());
        int n2 = MathUtils.round(resultPoint.getY());
        return this.isValid(n, n2);
    }

    private static float distance(Point point, Point point2) {
        return MathUtils.distance(point.getX(), point.getY(), point2.getX(), point2.getY());
    }

    private static float distance(ResultPoint resultPoint, ResultPoint resultPoint2) {
        return MathUtils.distance(resultPoint.getX(), resultPoint.getY(), resultPoint2.getX(), resultPoint2.getY());
    }

    private int getDimension() {
        if (this.compact) {
            return 4 * this.nbLayers + 11;
        }
        if (this.nbLayers <= 4) {
            return 4 * this.nbLayers + 15;
        }
        return 4 * this.nbLayers + 2 * ((this.nbLayers - 4) / 8 + 1) + 15;
    }

    static final class Point {
        private final int x;
        private final int y;

        ResultPoint toResultPoint() {
            return new ResultPoint(this.getX(), this.getY());
        }

        Point(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        int getX() {
            return this.x;
        }

        int getY() {
            return this.y;
        }

        public String toString() {
            return "<" + this.x + " " + this.y + ">";
        }
    }
}

