/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.AztecCode;
import com.google.zxing.aztec.encoder.HighLevelEncoder;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;

public final class Encoder {
    public static final int DEFAULT_EC_PERCENT = 33;
    public static final int DEFAULT_AZTEC_LAYERS = 0;
    private static final int MAX_NB_BITS = 32;
    private static final int MAX_NB_BITS_COMPACT = 4;
    private static final int[] WORD_SIZE = new int[]{4, 6, 6, 8, 8, 8, 8, 8, 8, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 12, 12, 12, 12, 12, 12, 12, 12, 12, 12};

    private Encoder() {
    }

    public static AztecCode encode(byte[] byArray) {
        return Encoder.encode(byArray, 33, 0);
    }

    public static AztecCode encode(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        BitArray bitArray;
        int n9;
        int n10;
        int n11;
        int n12;
        boolean bl;
        BitArray bitArray2 = new HighLevelEncoder(byArray).encode();
        int n13 = bitArray2.getSize() * n / 100 + 11;
        int n14 = bitArray2.getSize() + n13;
        if (n2 != 0) {
            bl = n2 < 0;
            n12 = Math.abs(n2);
            if (n12 > (bl ? 4 : 32)) {
                throw new IllegalArgumentException(String.format("Illegal value %s for layers", n2));
            }
            n11 = Encoder.totalBitsInLayer(n12, bl);
            n10 = WORD_SIZE[n12];
            n9 = n11 - n11 % n10;
            bitArray = Encoder.stuffBits(bitArray2, n10);
            if (bitArray.getSize() + n13 > n9) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
            if (bl && bitArray.getSize() > n10 * 64) {
                throw new IllegalArgumentException("Data to large for user specified layer");
            }
        } else {
            n10 = 0;
            bitArray = null;
            n9 = 0;
            while (true) {
                if (n9 > 32) {
                    throw new IllegalArgumentException("Data too large for an Aztec code");
                }
                bl = n9 <= 3;
                n12 = bl ? n9 + 1 : n9;
                n11 = Encoder.totalBitsInLayer(n12, bl);
                if (n14 <= n11) {
                    if (n10 != WORD_SIZE[n12]) {
                        n10 = WORD_SIZE[n12];
                        bitArray = Encoder.stuffBits(bitArray2, n10);
                    }
                    n8 = n11 - n11 % n10;
                    if ((!bl || bitArray.getSize() <= n10 * 64) && bitArray.getSize() + n13 <= n8) break;
                }
                ++n9;
            }
        }
        BitArray bitArray3 = Encoder.generateCheckWords(bitArray, n11, n10);
        n8 = bitArray.getSize() / n10;
        BitArray bitArray4 = Encoder.generateModeMessage(bl, n12, n8);
        int n15 = bl ? 11 + n12 * 4 : 14 + n12 * 4;
        int[] nArray = new int[n15];
        if (bl) {
            n7 = n15;
            for (n6 = 0; n6 < nArray.length; ++n6) {
                nArray[n6] = n6;
            }
        } else {
            n7 = n15 + 1 + 2 * ((n15 / 2 - 1) / 15);
            n6 = n15 / 2;
            n5 = n7 / 2;
            for (n4 = 0; n4 < n6; ++n4) {
                n3 = n4 + n4 / 15;
                nArray[n6 - n4 - 1] = n5 - n3 - 1;
                nArray[n6 + n4] = n5 + n3 + 1;
            }
        }
        BitMatrix bitMatrix = new BitMatrix(n7);
        n4 = 0;
        for (n5 = 0; n5 < n12; ++n5) {
            n3 = bl ? (n12 - n5) * 4 + 9 : (n12 - n5) * 4 + 12;
            for (int i = 0; i < n3; ++i) {
                int n16 = i * 2;
                for (int j = 0; j < 2; ++j) {
                    if (bitArray3.get(n4 + n16 + j)) {
                        bitMatrix.set(nArray[n5 * 2 + j], nArray[n5 * 2 + i]);
                    }
                    if (bitArray3.get(n4 + n3 * 2 + n16 + j)) {
                        bitMatrix.set(nArray[n5 * 2 + i], nArray[n15 - 1 - n5 * 2 - j]);
                    }
                    if (bitArray3.get(n4 + n3 * 4 + n16 + j)) {
                        bitMatrix.set(nArray[n15 - 1 - n5 * 2 - j], nArray[n15 - 1 - n5 * 2 - i]);
                    }
                    if (!bitArray3.get(n4 + n3 * 6 + n16 + j)) continue;
                    bitMatrix.set(nArray[n15 - 1 - n5 * 2 - i], nArray[n5 * 2 + j]);
                }
            }
            n4 += n3 * 8;
        }
        Encoder.drawModeMessage(bitMatrix, bl, n7, bitArray4);
        if (bl) {
            Encoder.drawBullsEye(bitMatrix, n7 / 2, 5);
        } else {
            Encoder.drawBullsEye(bitMatrix, n7 / 2, 7);
            n5 = 0;
            n4 = 0;
            while (n5 < n15 / 2 - 1) {
                for (n3 = n7 / 2 & 1; n3 < n7; n3 += 2) {
                    bitMatrix.set(n7 / 2 - n4, n3);
                    bitMatrix.set(n7 / 2 + n4, n3);
                    bitMatrix.set(n3, n7 / 2 - n4);
                    bitMatrix.set(n3, n7 / 2 + n4);
                }
                n5 += 15;
                n4 += 16;
            }
        }
        AztecCode aztecCode = new AztecCode();
        aztecCode.setCompact(bl);
        aztecCode.setSize(n7);
        aztecCode.setLayers(n12);
        aztecCode.setCodeWords(n8);
        aztecCode.setMatrix(bitMatrix);
        return aztecCode;
    }

    private static void drawBullsEye(BitMatrix bitMatrix, int n, int n2) {
        for (int i = 0; i < n2; i += 2) {
            for (int j = n - i; j <= n + i; ++j) {
                bitMatrix.set(j, n - i);
                bitMatrix.set(j, n + i);
                bitMatrix.set(n - i, j);
                bitMatrix.set(n + i, j);
            }
        }
        bitMatrix.set(n - n2, n - n2);
        bitMatrix.set(n - n2 + 1, n - n2);
        bitMatrix.set(n - n2, n - n2 + 1);
        bitMatrix.set(n + n2, n - n2);
        bitMatrix.set(n + n2, n - n2 + 1);
        bitMatrix.set(n + n2, n + n2 - 1);
    }

    static BitArray generateModeMessage(boolean bl, int n, int n2) {
        BitArray bitArray = new BitArray();
        if (bl) {
            bitArray.appendBits(n - 1, 2);
            bitArray.appendBits(n2 - 1, 6);
            bitArray = Encoder.generateCheckWords(bitArray, 28, 4);
        } else {
            bitArray.appendBits(n - 1, 5);
            bitArray.appendBits(n2 - 1, 11);
            bitArray = Encoder.generateCheckWords(bitArray, 40, 4);
        }
        return bitArray;
    }

    private static void drawModeMessage(BitMatrix bitMatrix, boolean bl, int n, BitArray bitArray) {
        int n2 = n / 2;
        if (bl) {
            for (int i = 0; i < 7; ++i) {
                int n3 = n2 - 3 + i;
                if (bitArray.get(i)) {
                    bitMatrix.set(n3, n2 - 5);
                }
                if (bitArray.get(i + 7)) {
                    bitMatrix.set(n2 + 5, n3);
                }
                if (bitArray.get(20 - i)) {
                    bitMatrix.set(n3, n2 + 5);
                }
                if (!bitArray.get(27 - i)) continue;
                bitMatrix.set(n2 - 5, n3);
            }
        } else {
            for (int i = 0; i < 10; ++i) {
                int n4 = n2 - 5 + i + i / 5;
                if (bitArray.get(i)) {
                    bitMatrix.set(n4, n2 - 7);
                }
                if (bitArray.get(i + 10)) {
                    bitMatrix.set(n2 + 7, n4);
                }
                if (bitArray.get(29 - i)) {
                    bitMatrix.set(n4, n2 + 7);
                }
                if (!bitArray.get(39 - i)) continue;
                bitMatrix.set(n2 - 7, n4);
            }
        }
    }

    private static BitArray generateCheckWords(BitArray bitArray, int n, int n2) {
        int n3 = bitArray.getSize() / n2;
        ReedSolomonEncoder reedSolomonEncoder = new ReedSolomonEncoder(Encoder.getGF(n2));
        int n4 = n / n2;
        int[] nArray = Encoder.bitsToWords(bitArray, n2, n4);
        reedSolomonEncoder.encode(nArray, n4 - n3);
        int n5 = n % n2;
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBits(0, n5);
        for (int n6 : nArray) {
            bitArray2.appendBits(n6, n2);
        }
        return bitArray2;
    }

    private static int[] bitsToWords(BitArray bitArray, int n, int n2) {
        int[] nArray = new int[n2];
        int n3 = bitArray.getSize() / n;
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                n4 |= bitArray.get(i * n + j) ? 1 << n - j - 1 : 0;
            }
            nArray[i] = n4;
        }
        return nArray;
    }

    private static GenericGF getGF(int n) {
        switch (n) {
            case 4: {
                return GenericGF.AZTEC_PARAM;
            }
            case 6: {
                return GenericGF.AZTEC_DATA_6;
            }
            case 8: {
                return GenericGF.AZTEC_DATA_8;
            }
            case 10: {
                return GenericGF.AZTEC_DATA_10;
            }
            case 12: {
                return GenericGF.AZTEC_DATA_12;
            }
        }
        return null;
    }

    static BitArray stuffBits(BitArray bitArray, int n) {
        BitArray bitArray2 = new BitArray();
        int n2 = bitArray.getSize();
        int n3 = (1 << n) - 2;
        for (int i = 0; i < n2; i += n) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                if (i + j < n2 && !bitArray.get(i + j)) continue;
                n4 |= 1 << n - 1 - j;
            }
            if ((n4 & n3) == n3) {
                bitArray2.appendBits(n4 & n3, n);
                --i;
                continue;
            }
            if ((n4 & n3) == 0) {
                bitArray2.appendBits(n4 | 1, n);
                --i;
                continue;
            }
            bitArray2.appendBits(n4, n);
        }
        return bitArray2;
    }

    private static int totalBitsInLayer(int n, boolean bl) {
        return ((bl ? 88 : 112) + 16 * n) * n;
    }
}

