/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.aztec.encoder;

import com.google.zxing.aztec.encoder.State;
import com.google.zxing.common.BitArray;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;

public final class HighLevelEncoder {
    static final String[] MODE_NAMES;
    static final int MODE_UPPER = 0;
    static final int MODE_LOWER = 1;
    static final int MODE_DIGIT = 2;
    static final int MODE_MIXED = 3;
    static final int MODE_PUNCT = 4;
    static final int[][] LATCH_TABLE;
    private static final int[][] CHAR_MAP;
    static final int[][] SHIFT_TABLE;
    private final byte[] text;

    public HighLevelEncoder(byte[] byArray) {
        this.text = byArray;
    }

    public BitArray encode() {
        Collection<State> collection = Collections.singletonList(State.INITIAL_STATE);
        for (int i = 0; i < this.text.length; ++i) {
            int n;
            byte by = i + 1 < this.text.length ? this.text[i + 1] : (byte)0;
            switch (this.text[i]) {
                case 13: {
                    n = by == 10 ? 2 : 0;
                    break;
                }
                case 46: {
                    n = by == 32 ? 3 : 0;
                    break;
                }
                case 44: {
                    n = by == 32 ? 4 : 0;
                    break;
                }
                case 58: {
                    n = by == 32 ? 5 : 0;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            if (n > 0) {
                collection = HighLevelEncoder.updateStateListForPair(collection, i, n);
                ++i;
                continue;
            }
            collection = this.updateStateListForChar(collection, i);
        }
        State state = Collections.min(collection, new Comparator<State>(){

            @Override
            public int compare(State state, State state2) {
                return state.getBitCount() - state2.getBitCount();
            }
        });
        return state.toBitArray(this.text);
    }

    private Collection<State> updateStateListForChar(Iterable<State> iterable, int n) {
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State state : iterable) {
            this.updateStateForChar(state, n, linkedList);
        }
        return HighLevelEncoder.simplifyStates(linkedList);
    }

    private void updateStateForChar(State state, int n, Collection<State> collection) {
        char c = (char)(this.text[n] & 0xFF);
        boolean bl = CHAR_MAP[state.getMode()][c] > 0;
        State state2 = null;
        for (int i = 0; i <= 4; ++i) {
            State state3;
            int n2 = CHAR_MAP[i][c];
            if (n2 <= 0) continue;
            if (state2 == null) {
                state2 = state.endBinaryShift(n);
            }
            if (!bl || i == state.getMode() || i == 2) {
                state3 = state2.latchAndAppend(i, n2);
                collection.add(state3);
            }
            if (bl || SHIFT_TABLE[state.getMode()][i] < 0) continue;
            state3 = state2.shiftAndAppend(i, n2);
            collection.add(state3);
        }
        if (state.getBinaryShiftByteCount() > 0 || CHAR_MAP[state.getMode()][c] == 0) {
            State state4 = state.addBinaryShiftChar(n);
            collection.add(state4);
        }
    }

    private static Collection<State> updateStateListForPair(Iterable<State> iterable, int n, int n2) {
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State state : iterable) {
            HighLevelEncoder.updateStateForPair(state, n, n2, linkedList);
        }
        return HighLevelEncoder.simplifyStates(linkedList);
    }

    private static void updateStateForPair(State state, int n, int n2, Collection<State> collection) {
        State state2;
        State state3 = state.endBinaryShift(n);
        collection.add(state3.latchAndAppend(4, n2));
        if (state.getMode() != 4) {
            collection.add(state3.shiftAndAppend(4, n2));
        }
        if (n2 == 3 || n2 == 4) {
            state2 = state3.latchAndAppend(2, 16 - n2).latchAndAppend(2, 1);
            collection.add(state2);
        }
        if (state.getBinaryShiftByteCount() > 0) {
            state2 = state.addBinaryShiftChar(n).addBinaryShiftChar(n + 1);
            collection.add(state2);
        }
    }

    private static Collection<State> simplifyStates(Iterable<State> iterable) {
        LinkedList<State> linkedList = new LinkedList<State>();
        for (State state : iterable) {
            boolean bl = true;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                State state2 = (State)iterator.next();
                if (state2.isBetterThanOrEqualTo(state)) {
                    bl = false;
                    break;
                }
                if (!state.isBetterThanOrEqualTo(state2)) continue;
                iterator.remove();
            }
            if (!bl) continue;
            linkedList.add(state);
        }
        return linkedList;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var0_5;
        void var0_3;
        void object;
        MODE_NAMES = new String[]{"UPPER", "LOWER", "DIGIT", "MIXED", "PUNCT"};
        LATCH_TABLE = new int[][]{{0, 327708, 327710, 327709, 656318}, {590318, 0, 327710, 327709, 656318}, {262158, 590300, 0, 590301, 932798}, {327709, 327708, 656318, 0, 327710}, {327711, 656380, 656382, 656381, 0}};
        CHAR_MAP = new int[5][256];
        HighLevelEncoder.CHAR_MAP[0][32] = 1;
        int n = 65;
        while (object <= 90) {
            HighLevelEncoder.CHAR_MAP[0][object] = object - 65 + 2;
            ++object;
        }
        HighLevelEncoder.CHAR_MAP[1][32] = 1;
        int n2 = 97;
        while (var0_3 <= 122) {
            HighLevelEncoder.CHAR_MAP[1][var0_3] = var0_3 - 97 + 2;
            ++var0_3;
        }
        HighLevelEncoder.CHAR_MAP[2][32] = 1;
        int n3 = 48;
        while (var0_5 <= 57) {
            HighLevelEncoder.CHAR_MAP[2][var0_5] = var0_5 - 48 + 2;
            ++var0_5;
        }
        HighLevelEncoder.CHAR_MAP[2][44] = 12;
        HighLevelEncoder.CHAR_MAP[2][46] = 13;
        int[] nArray = new int[]{0, 32, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 27, 28, 29, 30, 31, 64, 92, 94, 95, 96, 124, 126, 127};
        for (int i = 0; i < nArray.length; ++i) {
            HighLevelEncoder.CHAR_MAP[3][nArray[i]] = i;
        }
        int[] nArray2 = new int[]{0, 13, 0, 0, 0, 0, 33, 39, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 58, 59, 60, 61, 62, 63, 91, 93, 123, 125};
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] <= 0) continue;
            HighLevelEncoder.CHAR_MAP[4][nArray2[i]] = i;
        }
        for (int[] nArray3 : SHIFT_TABLE = new int[6][6]) {
            Arrays.fill(nArray3, -1);
        }
        HighLevelEncoder.SHIFT_TABLE[0][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[1][0] = 28;
        HighLevelEncoder.SHIFT_TABLE[3][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][4] = 0;
        HighLevelEncoder.SHIFT_TABLE[2][0] = 15;
    }
}

