/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.DecodeWorker;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.regex.Pattern;

public final class CommandLineRunner {
    private static final Pattern COMMA = Pattern.compile(",");

    private CommandLineRunner() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        if (stringArray.length == 0) {
            CommandLineRunner.printUsage();
            return;
        }
        Config config = new Config();
        ConcurrentLinkedQueue<String> concurrentLinkedQueue = new ConcurrentLinkedQueue<String>();
        block24: for (String object : stringArray) {
            String[] i = object.split("=");
            switch (i[0]) {
                case "--try_harder": {
                    config.setTryHarder(true);
                    continue block24;
                }
                case "--pure_barcode": {
                    config.setPureBarcode(true);
                    continue block24;
                }
                case "--products_only": {
                    config.setProductsOnly(true);
                    continue block24;
                }
                case "--dump_results": {
                    config.setDumpResults(true);
                    continue block24;
                }
                case "--dump_black_point": {
                    config.setDumpBlackPoint(true);
                    continue block24;
                }
                case "--multi": {
                    config.setMulti(true);
                    continue block24;
                }
                case "--brief": {
                    config.setBrief(true);
                    continue block24;
                }
                case "--recursive": {
                    config.setRecursive(true);
                    continue block24;
                }
                case "--crop": {
                    int[] nArray = new int[4];
                    String[] stringArray2 = COMMA.split(i[1]);
                    for (int j = 0; j < nArray.length; ++j) {
                        nArray[j] = Integer.parseInt(stringArray2[j]);
                    }
                    config.setCrop(nArray);
                    continue block24;
                }
                case "--possibleFormats": {
                    config.setPossibleFormats(COMMA.split(i[1]));
                    continue block24;
                }
                default: {
                    if (object.startsWith("-")) {
                        System.err.println("Unknown command line option " + object);
                        CommandLineRunner.printUsage();
                        return;
                    }
                    CommandLineRunner.addArgumentToInputs(object, config, concurrentLinkedQueue);
                }
            }
        }
        config.setHints(CommandLineRunner.buildHints(config));
        int n2 = Math.min(concurrentLinkedQueue.size(), Runtime.getRuntime().availableProcessors());
        int n3 = 0;
        if (n2 > 1) {
            ExecutorService executorService = Executors.newFixedThreadPool(n2);
            ArrayList<Future<Integer>> arrayList = new ArrayList<Future<Integer>>(n2);
            for (int iterator = 0; iterator < n2; ++iterator) {
                arrayList.add(executorService.submit(new DecodeWorker(config, concurrentLinkedQueue)));
            }
            executorService.shutdown();
            for (Object object : arrayList) {
                n3 += ((Integer)object.get()).intValue();
            }
        } else {
            n3 += new DecodeWorker(config, concurrentLinkedQueue).call().intValue();
        }
        if ((n = concurrentLinkedQueue.size()) > 1) {
            System.out.println("\nDecoded " + n3 + " files out of " + n + " successfully (" + n3 * 100 / n + "%)\n");
        }
    }

    private static void addArgumentToInputs(String string, Config config, Queue<String> queue) throws IOException {
        File file = new File(string);
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File file2 : file.listFiles()) {
                    String string2 = file2.getName().toLowerCase(Locale.ENGLISH);
                    if (string2.startsWith(".")) continue;
                    if (file2.isDirectory()) {
                        if (!config.isRecursive()) continue;
                        CommandLineRunner.addArgumentToInputs(file2.getAbsolutePath(), config, queue);
                        continue;
                    }
                    if (string2.endsWith(".txt") || string2.contains(".mono.png")) continue;
                    queue.add(file2.getCanonicalPath());
                }
            } else {
                queue.add(file.getCanonicalPath());
            }
        } else {
            queue.add(string);
        }
    }

    private static Map<DecodeHintType, ?> buildHints(Config config) {
        ArrayList<BarcodeFormat> arrayList = new ArrayList<BarcodeFormat>();
        String[] stringArray = config.getPossibleFormats();
        if (stringArray != null && stringArray.length > 0) {
            for (String string : stringArray) {
                arrayList.add(BarcodeFormat.valueOf(string));
            }
        } else {
            arrayList.add(BarcodeFormat.UPC_A);
            arrayList.add(BarcodeFormat.UPC_E);
            arrayList.add(BarcodeFormat.EAN_13);
            arrayList.add(BarcodeFormat.EAN_8);
            arrayList.add(BarcodeFormat.RSS_14);
            arrayList.add(BarcodeFormat.RSS_EXPANDED);
            if (!config.isProductsOnly()) {
                arrayList.add(BarcodeFormat.CODE_39);
                arrayList.add(BarcodeFormat.CODE_93);
                arrayList.add(BarcodeFormat.CODE_128);
                arrayList.add(BarcodeFormat.ITF);
                arrayList.add(BarcodeFormat.QR_CODE);
                arrayList.add(BarcodeFormat.DATA_MATRIX);
                arrayList.add(BarcodeFormat.AZTEC);
                arrayList.add(BarcodeFormat.PDF_417);
                arrayList.add(BarcodeFormat.CODABAR);
                arrayList.add(BarcodeFormat.MAXICODE);
            }
        }
        EnumMap enumMap = new EnumMap(DecodeHintType.class);
        enumMap.put(DecodeHintType.POSSIBLE_FORMATS, arrayList);
        if (config.isTryHarder()) {
            enumMap.put(DecodeHintType.TRY_HARDER, Boolean.TRUE);
        }
        if (config.isPureBarcode()) {
            enumMap.put(DecodeHintType.PURE_BARCODE, Boolean.TRUE);
        }
        return enumMap;
    }

    private static void printUsage() {
        System.err.println("Decode barcode images using the ZXing library");
        System.err.println();
        System.err.println("usage: CommandLineRunner { file | dir | url } [ options ]");
        System.err.println("  --try_harder: Use the TRY_HARDER hint, default is normal (mobile) mode");
        System.err.println("  --pure_barcode: Input image is a pure monochrome barcode image, not a photo");
        System.err.println("  --products_only: Only decode the UPC and EAN families of barcodes");
        System.err.println("  --dump_results: Write the decoded contents to input.txt");
        System.err.println("  --dump_black_point: Compare black point algorithms as input.mono.png");
        System.err.println("  --multi: Scans image for multiple barcodes");
        System.err.println("  --brief: Only output one line per file, omitting the contents");
        System.err.println("  --recursive: Descend into subdirectories");
        System.err.println("  --crop=left,top,width,height: Only examine cropped region of input image(s)");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  --possibleFormats=barcodeFormat[,barcodeFormat2...] where barcodeFormat is any of: ");
        for (BarcodeFormat barcodeFormat : BarcodeFormat.values()) {
            stringBuilder.append((Object)barcodeFormat).append(',');
        }
        stringBuilder.setLength(stringBuilder.length() - 1);
        System.err.println(stringBuilder);
    }
}

