/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.Config;
import com.google.zxing.client.j2se.ImageReader;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ResultParser;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.multi.GenericMultipleBarcodeReader;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import javax.imageio.ImageIO;

final class DecodeWorker
implements Callable<Integer> {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private final Config config;
    private final Queue<String> inputs;

    DecodeWorker(Config config, Queue<String> queue) {
        this.config = config;
        this.inputs = queue;
    }

    @Override
    public Integer call() throws IOException {
        String string;
        int n = 0;
        while ((string = this.inputs.poll()) != null) {
            File file = new File(string);
            if (file.exists()) {
                Object object;
                if (this.config.isMulti()) {
                    object = this.decodeMulti(file.toURI(), this.config.getHints());
                    if (object == null) continue;
                    ++n;
                    if (!this.config.isDumpResults()) continue;
                    DecodeWorker.dumpResultMulti(file, object);
                    continue;
                }
                object = this.decode(file.toURI(), this.config.getHints());
                if (object == null) continue;
                ++n;
                if (!this.config.isDumpResults()) continue;
                DecodeWorker.dumpResult(file, (Result)object);
                continue;
            }
            if (this.decode(URI.create(string), this.config.getHints()) == null) continue;
            ++n;
        }
        return n;
    }

    private static void dumpResult(File file, Result result) throws IOException {
        String string = file.getCanonicalPath();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        File file2 = new File(string + ".txt");
        DecodeWorker.writeStringToFile(result.getText(), file2);
    }

    private static void dumpResultMulti(File file, Result[] resultArray) throws IOException {
        String string = file.getCanonicalPath();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            string = string.substring(0, n);
        }
        File file2 = new File(string + ".txt");
        DecodeWorker.writeResultsToFile(resultArray, file2);
    }

    private static void writeStringToFile(String string, File file) throws IOException {
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);){
            outputStreamWriter.write(string);
        }
    }

    private static void writeResultsToFile(Result[] resultArray, File file) throws IOException {
        String string = System.getProperty("line.separator");
        try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(file), UTF8);){
            for (Result result : resultArray) {
                outputStreamWriter.write(result.getText());
                outputStreamWriter.write(string);
            }
        }
    }

    private Result decode(URI uRI, Map<DecodeHintType, ?> map) throws IOException {
        BufferedImage bufferedImage = ImageReader.readImage(uRI);
        try {
            Object object;
            BufferedImageLuminanceSource bufferedImageLuminanceSource;
            if (this.config.getCrop() == null) {
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
            } else {
                object = this.config.getCrop();
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage, object[0], object[1], object[2], object[3]);
            }
            object = new BinaryBitmap(new HybridBinarizer(bufferedImageLuminanceSource));
            if (this.config.isDumpBlackPoint()) {
                DecodeWorker.dumpBlackPoint(uRI, bufferedImage, (BinaryBitmap)object);
            }
            Result result = new MultiFormatReader().decode((BinaryBitmap)object, map);
            if (this.config.isBrief()) {
                System.out.println(uRI.toString() + ": Success");
            } else {
                ParsedResult parsedResult = ResultParser.parseResult(result);
                System.out.println(uRI.toString() + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                System.out.println("Found " + result.getResultPoints().length + " result points.");
                for (int i = 0; i < result.getResultPoints().length; ++i) {
                    ResultPoint resultPoint = result.getResultPoints()[i];
                    if (resultPoint == null) continue;
                    System.out.println("  Point " + i + ": (" + resultPoint.getX() + "," + resultPoint.getY() + ")");
                }
            }
            return result;
        }
        catch (NotFoundException notFoundException) {
            System.out.println(uRI.toString() + ": No barcode found");
            return null;
        }
    }

    private Result[] decodeMulti(URI uRI, Map<DecodeHintType, ?> map) throws IOException {
        BufferedImage bufferedImage = ImageReader.readImage(uRI);
        try {
            Object object;
            BufferedImageLuminanceSource bufferedImageLuminanceSource;
            if (this.config.getCrop() == null) {
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
            } else {
                object = this.config.getCrop();
                bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage, object[0], object[1], object[2], object[3]);
            }
            object = new BinaryBitmap(new HybridBinarizer(bufferedImageLuminanceSource));
            if (this.config.isDumpBlackPoint()) {
                DecodeWorker.dumpBlackPoint(uRI, bufferedImage, (BinaryBitmap)object);
            }
            MultiFormatReader multiFormatReader = new MultiFormatReader();
            GenericMultipleBarcodeReader genericMultipleBarcodeReader = new GenericMultipleBarcodeReader(multiFormatReader);
            Result[] resultArray = genericMultipleBarcodeReader.decodeMultiple((BinaryBitmap)object, map);
            if (this.config.isBrief()) {
                System.out.println(uRI.toString() + ": Success");
            } else {
                for (Result result : resultArray) {
                    ParsedResult parsedResult = ResultParser.parseResult(result);
                    System.out.println(uRI.toString() + " (format: " + result.getBarcodeFormat() + ", type: " + parsedResult.getType() + "):\nRaw result:\n" + result.getText() + "\nParsed result:\n" + parsedResult.getDisplayResult());
                    System.out.println("Found " + result.getResultPoints().length + " result points.");
                    for (int i = 0; i < result.getResultPoints().length; ++i) {
                        ResultPoint resultPoint = result.getResultPoints()[i];
                        System.out.println("  Point " + i + ": (" + resultPoint.getX() + "," + resultPoint.getY() + ")");
                    }
                }
            }
            return resultArray;
        }
        catch (NotFoundException notFoundException) {
            System.out.println(uRI.toString() + ": No barcode found");
            return null;
        }
    }

    private static void dumpBlackPoint(URI uRI, BufferedImage bufferedImage, BinaryBitmap binaryBitmap) {
        int n;
        int n2;
        int n3;
        String string = uRI.getPath();
        if (string.contains(".mono.png")) {
            return;
        }
        int n4 = binaryBitmap.getWidth();
        int n5 = binaryBitmap.getHeight();
        int n6 = n4 * 3;
        int[] nArray = new int[n6 * n5];
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n5; ++i) {
            bufferedImage.getRGB(0, i, n4, 1, nArray2, 0, n4);
            System.arraycopy(nArray2, 0, nArray, i * n6, n4);
        }
        BitArray bitArray = new BitArray(n4);
        for (n3 = 0; n3 < n5; ++n3) {
            try {
                bitArray = binaryBitmap.getBlackRow(n3, bitArray);
            }
            catch (NotFoundException notFoundException) {
                n2 = n3 * n6 + n4;
                for (n = 0; n < n4; ++n) {
                    nArray[n2 + n] = -65536;
                }
                continue;
            }
            int n7 = n3 * n6 + n4;
            for (n2 = 0; n2 < n4; ++n2) {
                nArray[n7 + n2] = bitArray.get(n2) ? -16777216 : -1;
            }
        }
        try {
            for (n3 = 0; n3 < n5; ++n3) {
                BitMatrix bitMatrix = binaryBitmap.getBlackMatrix();
                n2 = n3 * n6 + n4 * 2;
                for (n = 0; n < n4; ++n) {
                    nArray[n2 + n] = bitMatrix.get(n, n3) ? -16777216 : -1;
                }
            }
        }
        catch (NotFoundException notFoundException) {
            // empty catch block
        }
        DecodeWorker.writeResultImage(n6, n5, nArray, uRI, string, ".mono.png");
    }

    private static void writeResultImage(int n, int n2, int[] nArray, URI uRI, String string, String string2) {
        int n3;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
        Object object = string;
        if ("http".equals(uRI.getScheme()) && (n3 = ((String)object).lastIndexOf(47)) > 0) {
            object = "." + ((String)object).substring(n3);
        }
        if ((n3 = ((String)object).lastIndexOf(46)) > 0) {
            object = ((String)object).substring(0, n3);
        }
        object = (String)object + string2;
        try (FileOutputStream fileOutputStream = new FileOutputStream((String)object);){
            if (!ImageIO.write((RenderedImage)bufferedImage, "png", fileOutputStream)) {
                System.err.println("Could not encode an image to " + (String)object);
            }
        }
        catch (IOException iOException) {
            System.err.println("Could not write to " + (String)object);
        }
    }
}

