/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.j2se;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URLDecoder;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;

public final class ImageReader {
    private static final String BASE64TOKEN = "base64,";

    private ImageReader() {
    }

    public static BufferedImage readImage(URI uRI) throws IOException {
        BufferedImage bufferedImage;
        if ("data".equals(uRI.getScheme())) {
            return ImageReader.readDataURIImage(uRI);
        }
        try {
            bufferedImage = ImageIO.read(uRI.toURL());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException("Resource not found: " + uRI, illegalArgumentException);
        }
        if (bufferedImage == null) {
            throw new IOException("Could not load " + uRI);
        }
        return bufferedImage;
    }

    public static BufferedImage readDataURIImage(URI uRI) throws IOException {
        String string = uRI.toString();
        if (!string.startsWith("data:image/")) {
            throw new IOException("Unsupported data URI MIME type");
        }
        int n = string.indexOf(BASE64TOKEN);
        if (n < 0) {
            throw new IOException("Unsupported data URI encoding");
        }
        String string2 = string.substring(n + BASE64TOKEN.length());
        String string3 = URLDecoder.decode(string2, "UTF-8");
        byte[] byArray = DatatypeConverter.parseBase64Binary((String)string3);
        return ImageIO.read(new ByteArrayInputStream(byArray));
    }

    public static BufferedImage readImage(File file) throws IOException {
        return ImageReader.readImage(file.toURI());
    }
}

