/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.Result;
import com.google.zxing.client.result.AddressBookAUResultParser;
import com.google.zxing.client.result.AddressBookDoCoMoResultParser;
import com.google.zxing.client.result.BizcardResultParser;
import com.google.zxing.client.result.BookmarkDoCoMoResultParser;
import com.google.zxing.client.result.EmailAddressResultParser;
import com.google.zxing.client.result.EmailDoCoMoResultParser;
import com.google.zxing.client.result.ExpandedProductResultParser;
import com.google.zxing.client.result.GeoResultParser;
import com.google.zxing.client.result.ISBNResultParser;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ProductResultParser;
import com.google.zxing.client.result.SMSMMSResultParser;
import com.google.zxing.client.result.SMSTOMMSTOResultParser;
import com.google.zxing.client.result.SMTPResultParser;
import com.google.zxing.client.result.TelResultParser;
import com.google.zxing.client.result.TextParsedResult;
import com.google.zxing.client.result.URIResultParser;
import com.google.zxing.client.result.URLTOResultParser;
import com.google.zxing.client.result.VCardResultParser;
import com.google.zxing.client.result.VEventResultParser;
import com.google.zxing.client.result.WifiResultParser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public abstract class ResultParser {
    private static final ResultParser[] PARSERS = new ResultParser[]{new BookmarkDoCoMoResultParser(), new AddressBookDoCoMoResultParser(), new EmailDoCoMoResultParser(), new AddressBookAUResultParser(), new VCardResultParser(), new BizcardResultParser(), new VEventResultParser(), new EmailAddressResultParser(), new SMTPResultParser(), new TelResultParser(), new SMSMMSResultParser(), new SMSTOMMSTOResultParser(), new GeoResultParser(), new WifiResultParser(), new URLTOResultParser(), new URIResultParser(), new ISBNResultParser(), new ProductResultParser(), new ExpandedProductResultParser()};
    private static final Pattern DIGITS = Pattern.compile("\\d*");
    private static final Pattern ALPHANUM = Pattern.compile("[a-zA-Z0-9]*");
    private static final Pattern AMPERSAND = Pattern.compile("&");
    private static final Pattern EQUALS = Pattern.compile("=");
    private static final String BYTE_ORDER_MARK = "\ufeff";

    public abstract ParsedResult parse(Result var1);

    protected static String getMassagedText(Result result) {
        String string = result.getText();
        if (string.startsWith(BYTE_ORDER_MARK)) {
            string = string.substring(1);
        }
        return string;
    }

    public static ParsedResult parseResult(Result result) {
        for (ResultParser resultParser : PARSERS) {
            ParsedResult parsedResult = resultParser.parse(result);
            if (parsedResult == null) continue;
            return parsedResult;
        }
        return new TextParsedResult(result.getText(), null);
    }

    protected static void maybeAppend(String string, StringBuilder stringBuilder) {
        if (string != null) {
            stringBuilder.append('\n');
            stringBuilder.append(string);
        }
    }

    protected static void maybeAppend(String[] stringArray, StringBuilder stringBuilder) {
        if (stringArray != null) {
            for (String string : stringArray) {
                stringBuilder.append('\n');
                stringBuilder.append(string);
            }
        }
    }

    protected static String[] maybeWrap(String string) {
        String[] stringArray;
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        return stringArray;
    }

    protected static String unescapeBackslash(String string) {
        int n = string.indexOf(92);
        if (n < 0) {
            return string;
        }
        int n2 = string.length();
        StringBuilder stringBuilder = new StringBuilder(n2 - 1);
        stringBuilder.append(string.toCharArray(), 0, n);
        boolean bl = false;
        for (int i = n; i < n2; ++i) {
            char c = string.charAt(i);
            if (bl || c != '\\') {
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    protected static int parseHexDigit(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return 10 + (c - 97);
        }
        if (c >= 'A' && c <= 'F') {
            return 10 + (c - 65);
        }
        return -1;
    }

    protected static boolean isStringOfDigits(CharSequence charSequence, int n) {
        return charSequence != null && n == charSequence.length() && DIGITS.matcher(charSequence).matches();
    }

    protected static boolean isSubstringOfDigits(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return false;
        }
        int n3 = n + n2;
        return charSequence.length() >= n3 && DIGITS.matcher(charSequence.subSequence(n, n3)).matches();
    }

    protected static boolean isSubstringOfAlphaNumeric(CharSequence charSequence, int n, int n2) {
        if (charSequence == null) {
            return false;
        }
        int n3 = n + n2;
        return charSequence.length() >= n3 && ALPHANUM.matcher(charSequence.subSequence(n, n3)).matches();
    }

    static Map<String, String> parseNameValuePairs(String string) {
        int n = string.indexOf(63);
        if (n < 0) {
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(3);
        for (String string2 : AMPERSAND.split(string.substring(n + 1))) {
            ResultParser.appendKeyValue(string2, hashMap);
        }
        return hashMap;
    }

    private static void appendKeyValue(CharSequence charSequence, Map<String, String> map) {
        String[] stringArray = EQUALS.split(charSequence, 2);
        if (stringArray.length == 2) {
            String string = stringArray[0];
            String string2 = stringArray[1];
            try {
                string2 = ResultParser.urlDecode(string2);
                map.put(string, string2);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static String urlDecode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
    }

    static String[] matchPrefixedField(String string, String string2, char c, boolean bl) {
        ArrayList<String> arrayList = null;
        int n = 0;
        int n2 = string2.length();
        while (n < n2 && (n = string2.indexOf(string, n)) >= 0) {
            int n3 = n += string.length();
            boolean bl2 = true;
            while (bl2) {
                if ((n = string2.indexOf(c, n)) < 0) {
                    n = string2.length();
                    bl2 = false;
                    continue;
                }
                if (string2.charAt(n - 1) == '\\') {
                    ++n;
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList<String>(3);
                }
                String string3 = ResultParser.unescapeBackslash(string2.substring(n3, n));
                if (bl) {
                    string3 = string3.trim();
                }
                if (!string3.isEmpty()) {
                    arrayList.add(string3);
                }
                ++n;
                bl2 = false;
            }
        }
        if (arrayList == null || arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static String matchSinglePrefixedField(String string, String string2, char c, boolean bl) {
        String[] stringArray = ResultParser.matchPrefixedField(string, string2, c, bl);
        return stringArray == null ? null : stringArray[0];
    }
}

