/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.client.result;

import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.ParsedResultType;
import java.util.regex.Pattern;

public final class URIParsedResult
extends ParsedResult {
    private static final Pattern USER_IN_HOST = Pattern.compile(":/*([^/@]+)@[^/]+");
    private final String uri;
    private final String title;

    public URIParsedResult(String string, String string2) {
        super(ParsedResultType.URI);
        this.uri = URIParsedResult.massageURI(string);
        this.title = string2;
    }

    public String getURI() {
        return this.uri;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isPossiblyMaliciousURI() {
        return USER_IN_HOST.matcher(this.uri).find();
    }

    @Override
    public String getDisplayResult() {
        StringBuilder stringBuilder = new StringBuilder(30);
        URIParsedResult.maybeAppend(this.title, stringBuilder);
        URIParsedResult.maybeAppend(this.uri, stringBuilder);
        return stringBuilder.toString();
    }

    private static String massageURI(String object) {
        int n = ((String)(object = ((String)object).trim())).indexOf(58);
        if (n < 0) {
            object = "http://" + (String)object;
        } else if (URIParsedResult.isColonFollowedByPortNumber((String)object, n)) {
            object = "http://" + (String)object;
        }
        return object;
    }

    private static boolean isColonFollowedByPortNumber(String string, int n) {
        int n2 = string.indexOf(47, n + 1);
        if (n2 < 0) {
            n2 = string.length();
        }
        if (n2 <= n + 1) {
            return false;
        }
        for (int i = n + 1; i < n2; ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
            return false;
        }
        return true;
    }
}

