/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

public final class BitArray {
    private int[] bits;
    private int size;

    public BitArray() {
        this.size = 0;
        this.bits = new int[1];
    }

    public BitArray(int n) {
        this.size = n;
        this.bits = BitArray.makeArray(n);
    }

    BitArray(int[] nArray, int n) {
        this.bits = nArray;
        this.size = n;
    }

    public int getSize() {
        return this.size;
    }

    public int getSizeInBytes() {
        return (this.size + 7) / 8;
    }

    private void ensureCapacity(int n) {
        if (n > this.bits.length * 32) {
            int[] nArray = BitArray.makeArray(n);
            System.arraycopy(this.bits, 0, nArray, 0, this.bits.length);
            this.bits = nArray;
        }
    }

    public boolean get(int n) {
        return (this.bits[n / 32] & 1 << (n & 0x1F)) != 0;
    }

    public void set(int n) {
        int n2 = n / 32;
        this.bits[n2] = this.bits[n2] | 1 << (n & 0x1F);
    }

    public void flip(int n) {
        int n2 = n / 32;
        this.bits[n2] = this.bits[n2] ^ 1 << (n & 0x1F);
    }

    public int getNextSet(int n) {
        if (n >= this.size) {
            return this.size;
        }
        int n2 = n / 32;
        int n3 = this.bits[n2];
        n3 &= ~((1 << (n & 0x1F)) - 1);
        while (n3 == 0) {
            if (++n2 == this.bits.length) {
                return this.size;
            }
            n3 = this.bits[n2];
        }
        int n4 = n2 * 32 + Integer.numberOfTrailingZeros(n3);
        return n4 > this.size ? this.size : n4;
    }

    public int getNextUnset(int n) {
        if (n >= this.size) {
            return this.size;
        }
        int n2 = n / 32;
        int n3 = ~this.bits[n2];
        n3 &= ~((1 << (n & 0x1F)) - 1);
        while (n3 == 0) {
            if (++n2 == this.bits.length) {
                return this.size;
            }
            n3 = ~this.bits[n2];
        }
        int n4 = n2 * 32 + Integer.numberOfTrailingZeros(n3);
        return n4 > this.size ? this.size : n4;
    }

    public void setBulk(int n, int n2) {
        this.bits[n / 32] = n2;
    }

    public void setRange(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException();
        }
        if (n2 == n) {
            return;
        }
        int n3 = n / 32;
        int n4 = --n2 / 32;
        int n5 = n3;
        while (n5 <= n4) {
            int n6;
            int n7;
            int n8 = n5 > n3 ? 0 : n & 0x1F;
            int n9 = n7 = n5 < n4 ? 31 : n2 & 0x1F;
            if (n8 == 0 && n7 == 31) {
                n6 = -1;
            } else {
                n6 = 0;
                for (int i = n8; i <= n7; ++i) {
                    n6 |= 1 << i;
                }
            }
            int n10 = n5++;
            this.bits[n10] = this.bits[n10] | n6;
        }
    }

    public void clear() {
        int n = this.bits.length;
        for (int i = 0; i < n; ++i) {
            this.bits[i] = 0;
        }
    }

    public boolean isRange(int n, int n2, boolean bl) {
        if (n2 < n) {
            throw new IllegalArgumentException();
        }
        if (n2 == n) {
            return true;
        }
        int n3 = n / 32;
        int n4 = --n2 / 32;
        for (int i = n3; i <= n4; ++i) {
            int n5;
            int n6;
            int n7 = i > n3 ? 0 : n & 0x1F;
            int n8 = n6 = i < n4 ? 31 : n2 & 0x1F;
            if (n7 == 0 && n6 == 31) {
                n5 = -1;
            } else {
                n5 = 0;
                for (int j = n7; j <= n6; ++j) {
                    n5 |= 1 << j;
                }
            }
            if ((this.bits[i] & n5) == (bl ? n5 : 0)) continue;
            return false;
        }
        return true;
    }

    public void appendBit(boolean bl) {
        this.ensureCapacity(this.size + 1);
        if (bl) {
            int n = this.size / 32;
            this.bits[n] = this.bits[n] | 1 << (this.size & 0x1F);
        }
        ++this.size;
    }

    public void appendBits(int n, int n2) {
        if (n2 < 0 || n2 > 32) {
            throw new IllegalArgumentException("Num bits must be between 0 and 32");
        }
        this.ensureCapacity(this.size + n2);
        for (int i = n2; i > 0; --i) {
            this.appendBit((n >> i - 1 & 1) == 1);
        }
    }

    public void appendBitArray(BitArray bitArray) {
        int n = bitArray.size;
        this.ensureCapacity(this.size + n);
        for (int i = 0; i < n; ++i) {
            this.appendBit(bitArray.get(i));
        }
    }

    public void xor(BitArray bitArray) {
        if (this.bits.length != bitArray.bits.length) {
            throw new IllegalArgumentException("Sizes don't match");
        }
        for (int i = 0; i < this.bits.length; ++i) {
            int n = i;
            this.bits[n] = this.bits[n] ^ bitArray.bits[i];
        }
    }

    public void toBytes(int n, byte[] byArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            int n4 = 0;
            for (int j = 0; j < 8; ++j) {
                if (this.get(n)) {
                    n4 |= 1 << 7 - j;
                }
                ++n;
            }
            byArray[n2 + i] = (byte)n4;
        }
    }

    public int[] getBitArray() {
        return this.bits;
    }

    public void reverse() {
        int n;
        int[] nArray = new int[this.bits.length];
        int n2 = (this.size - 1) / 32;
        int n3 = n2 + 1;
        for (n = 0; n < n3; ++n) {
            long l = this.bits[n];
            l = l >> 1 & 0x55555555L | (l & 0x55555555L) << 1;
            l = l >> 2 & 0x33333333L | (l & 0x33333333L) << 2;
            l = l >> 4 & 0xF0F0F0FL | (l & 0xF0F0F0FL) << 4;
            l = l >> 8 & 0xFF00FFL | (l & 0xFF00FFL) << 8;
            l = l >> 16 & 0xFFFFL | (l & 0xFFFFL) << 16;
            nArray[n2 - n] = (int)l;
        }
        if (this.size != n3 * 32) {
            int n4;
            n = n3 * 32 - this.size;
            int n5 = 1;
            for (n4 = 0; n4 < 31 - n; ++n4) {
                n5 = n5 << 1 | 1;
            }
            n4 = nArray[0] >> n & n5;
            for (int i = 1; i < n3; ++i) {
                int n6 = nArray[i];
                nArray[i - 1] = n4 |= n6 << 32 - n;
                n4 = n6 >> n & n5;
            }
            nArray[n3 - 1] = n4;
        }
        this.bits = nArray;
    }

    private static int[] makeArray(int n) {
        return new int[(n + 31) / 32];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.size);
        for (int i = 0; i < this.size; ++i) {
            if ((i & 7) == 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(this.get(i) ? (char)'X' : '.');
        }
        return stringBuilder.toString();
    }
}

