/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.common;

import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.GridSampler;
import com.google.zxing.common.PerspectiveTransform;

public final class DefaultGridSampler
extends GridSampler {
    @Override
    public BitMatrix sampleGrid(BitMatrix bitMatrix, int n, int n2, float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) throws NotFoundException {
        PerspectiveTransform perspectiveTransform = PerspectiveTransform.quadrilateralToQuadrilateral(f, f2, f3, f4, f5, f6, f7, f8, f9, f10, f11, f12, f13, f14, f15, f16);
        return this.sampleGrid(bitMatrix, n, n2, perspectiveTransform);
    }

    @Override
    public BitMatrix sampleGrid(BitMatrix bitMatrix, int n, int n2, PerspectiveTransform perspectiveTransform) throws NotFoundException {
        if (n <= 0 || n2 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        BitMatrix bitMatrix2 = new BitMatrix(n, n2);
        float[] fArray = new float[n << 1];
        for (int i = 0; i < n2; ++i) {
            int n3;
            int n4 = fArray.length;
            float f = (float)i + 0.5f;
            for (n3 = 0; n3 < n4; n3 += 2) {
                fArray[n3] = (float)(n3 >> 1) + 0.5f;
                fArray[n3 + 1] = f;
            }
            perspectiveTransform.transformPoints(fArray);
            DefaultGridSampler.checkAndNudgePoints(bitMatrix, fArray);
            try {
                for (n3 = 0; n3 < n4; n3 += 2) {
                    if (!bitMatrix.get((int)fArray[n3], (int)fArray[n3 + 1])) continue;
                    bitMatrix2.set(n3 >> 1, i);
                }
                continue;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw NotFoundException.getNotFoundInstance();
            }
        }
        return bitMatrix2;
    }
}

