/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.datamatrix.encoder;

import com.google.zxing.datamatrix.encoder.Encoder;
import com.google.zxing.datamatrix.encoder.EncoderContext;
import com.google.zxing.datamatrix.encoder.HighLevelEncoder;

class C40Encoder
implements Encoder {
    C40Encoder() {
    }

    @Override
    public int getEncodingMode() {
        return 1;
    }

    @Override
    public void encode(EncoderContext encoderContext) {
        StringBuilder stringBuilder = new StringBuilder();
        while (encoderContext.hasMoreCharacters()) {
            int n;
            char c = encoderContext.getCurrentChar();
            ++encoderContext.pos;
            int n2 = this.encodeChar(c, stringBuilder);
            int n3 = stringBuilder.length() / 3 * 2;
            int n4 = encoderContext.getCodewordCount() + n3;
            encoderContext.updateSymbolInfo(n4);
            int n5 = encoderContext.getSymbolInfo().getDataCapacity() - n4;
            if (!encoderContext.hasMoreCharacters()) {
                StringBuilder stringBuilder2 = new StringBuilder();
                if (stringBuilder.length() % 3 == 2 && (n5 < 2 || n5 > 2)) {
                    n2 = this.backtrackOneCharacter(encoderContext, stringBuilder, stringBuilder2, n2);
                }
                while (stringBuilder.length() % 3 == 1 && (n2 <= 3 && n5 != 1 || n2 > 3)) {
                    n2 = this.backtrackOneCharacter(encoderContext, stringBuilder, stringBuilder2, n2);
                }
                break;
            }
            int n6 = stringBuilder.length();
            if (n6 % 3 != 0 || (n = HighLevelEncoder.lookAheadTest(encoderContext.getMessage(), encoderContext.pos, this.getEncodingMode())) == this.getEncodingMode()) continue;
            encoderContext.signalEncoderChange(n);
            break;
        }
        this.handleEOD(encoderContext, stringBuilder);
    }

    private int backtrackOneCharacter(EncoderContext encoderContext, StringBuilder stringBuilder, StringBuilder stringBuilder2, int n) {
        int n2 = stringBuilder.length();
        stringBuilder.delete(n2 - n, n2);
        --encoderContext.pos;
        char c = encoderContext.getCurrentChar();
        n = this.encodeChar(c, stringBuilder2);
        encoderContext.resetSymbolInfo();
        return n;
    }

    static void writeNextTriplet(EncoderContext encoderContext, StringBuilder stringBuilder) {
        encoderContext.writeCodewords(C40Encoder.encodeToCodewords(stringBuilder, 0));
        stringBuilder.delete(0, 3);
    }

    void handleEOD(EncoderContext encoderContext, StringBuilder stringBuilder) {
        int n = stringBuilder.length() / 3 * 2;
        int n2 = stringBuilder.length() % 3;
        int n3 = encoderContext.getCodewordCount() + n;
        encoderContext.updateSymbolInfo(n3);
        int n4 = encoderContext.getSymbolInfo().getDataCapacity() - n3;
        if (n2 == 2) {
            stringBuilder.append('\u0000');
            while (stringBuilder.length() >= 3) {
                C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
            }
            if (encoderContext.hasMoreCharacters()) {
                encoderContext.writeCodeword('\u00fe');
            }
        } else if (n4 == 1 && n2 == 1) {
            while (stringBuilder.length() >= 3) {
                C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
            }
            if (encoderContext.hasMoreCharacters()) {
                encoderContext.writeCodeword('\u00fe');
            }
            --encoderContext.pos;
        } else if (n2 == 0) {
            while (stringBuilder.length() >= 3) {
                C40Encoder.writeNextTriplet(encoderContext, stringBuilder);
            }
            if (n4 > 0 || encoderContext.hasMoreCharacters()) {
                encoderContext.writeCodeword('\u00fe');
            }
        } else {
            throw new IllegalStateException("Unexpected case. Please report!");
        }
        encoderContext.signalEncoderChange(0);
    }

    int encodeChar(char c, StringBuilder stringBuilder) {
        if (c == ' ') {
            stringBuilder.append('\u0003');
            return 1;
        }
        if (c >= '0' && c <= '9') {
            stringBuilder.append((char)(c - 48 + 4));
            return 1;
        }
        if (c >= 'A' && c <= 'Z') {
            stringBuilder.append((char)(c - 65 + 14));
            return 1;
        }
        if (c >= '\u0000' && c <= '\u001f') {
            stringBuilder.append('\u0000');
            stringBuilder.append(c);
            return 2;
        }
        if (c >= '!' && c <= '/') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c - 33));
            return 2;
        }
        if (c >= ':' && c <= '@') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c - 58 + 15));
            return 2;
        }
        if (c >= '[' && c <= '_') {
            stringBuilder.append('\u0001');
            stringBuilder.append((char)(c - 91 + 22));
            return 2;
        }
        if (c >= '`' && c <= '\u007f') {
            stringBuilder.append('\u0002');
            stringBuilder.append((char)(c - 96));
            return 2;
        }
        if (c >= '\u0080') {
            stringBuilder.append("\u0001\u001e");
            int n = 2;
            return n += this.encodeChar((char)(c - 128), stringBuilder);
        }
        throw new IllegalArgumentException("Illegal character: " + c);
    }

    private static String encodeToCodewords(CharSequence charSequence, int n) {
        char c = charSequence.charAt(n);
        char c2 = charSequence.charAt(n + 1);
        char c3 = charSequence.charAt(n + 2);
        int n2 = 1600 * c + 40 * c2 + c3 + 1;
        char c4 = (char)(n2 / 256);
        char c5 = (char)(n2 % 256);
        return new String(new char[]{c4, c5});
    }
}

