/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.maxicode.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonDecoder;
import com.google.zxing.common.reedsolomon.ReedSolomonException;
import com.google.zxing.maxicode.decoder.BitMatrixParser;
import com.google.zxing.maxicode.decoder.DecodedBitStreamParser;
import java.util.Map;

public final class Decoder {
    private static final int ALL = 0;
    private static final int EVEN = 1;
    private static final int ODD = 2;
    private final ReedSolomonDecoder rsDecoder = new ReedSolomonDecoder(GenericGF.MAXICODE_FIELD_64);

    public DecoderResult decode(BitMatrix bitMatrix) throws ChecksumException, FormatException {
        return this.decode(bitMatrix, null);
    }

    public DecoderResult decode(BitMatrix bitMatrix, Map<DecodeHintType, ?> map) throws FormatException, ChecksumException {
        byte[] byArray;
        BitMatrixParser bitMatrixParser = new BitMatrixParser(bitMatrix);
        byte[] byArray2 = bitMatrixParser.readCodewords();
        this.correctErrors(byArray2, 0, 10, 10, 0);
        int n = byArray2[0] & 0xF;
        switch (n) {
            case 2: 
            case 3: 
            case 4: {
                this.correctErrors(byArray2, 20, 84, 40, 1);
                this.correctErrors(byArray2, 20, 84, 40, 2);
                byArray = new byte[94];
                break;
            }
            case 5: {
                this.correctErrors(byArray2, 20, 68, 56, 1);
                this.correctErrors(byArray2, 20, 68, 56, 2);
                byArray = new byte[78];
                break;
            }
            default: {
                throw FormatException.getFormatInstance();
            }
        }
        System.arraycopy(byArray2, 0, byArray, 0, 10);
        System.arraycopy(byArray2, 20, byArray, 10, byArray.length - 10);
        return DecodedBitStreamParser.decode(byArray, n);
    }

    private void correctErrors(byte[] byArray, int n, int n2, int n3, int n4) throws ChecksumException {
        int n5;
        int n6 = n2 + n3;
        int n7 = n4 == 0 ? 1 : 2;
        int[] nArray = new int[n6 / n7];
        for (n5 = 0; n5 < n6; ++n5) {
            if (n4 != 0 && n5 % 2 != n4 - 1) continue;
            nArray[n5 / n7] = byArray[n5 + n] & 0xFF;
        }
        try {
            this.rsDecoder.decode(nArray, n3 / n7);
        }
        catch (ReedSolomonException reedSolomonException) {
            throw ChecksumException.getChecksumInstance();
        }
        for (n5 = 0; n5 < n2; ++n5) {
            if (n4 != 0 && n5 % 2 != n4 - 1) continue;
            byArray[n5 + n] = (byte)nArray[n5 / n7];
        }
    }
}

