/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.multi.MultipleBarcodeReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class GenericMultipleBarcodeReader
implements MultipleBarcodeReader {
    private static final int MIN_DIMENSION_TO_RECUR = 100;
    private static final int MAX_DEPTH = 4;
    private final Reader delegate;

    public GenericMultipleBarcodeReader(Reader reader) {
        this.delegate = reader;
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap) throws NotFoundException {
        return this.decodeMultiple(binaryBitmap, null);
    }

    @Override
    public Result[] decodeMultiple(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException {
        ArrayList<Result> arrayList = new ArrayList<Result>();
        this.doDecodeMultiple(binaryBitmap, map, arrayList, 0, 0, 0);
        if (arrayList.isEmpty()) {
            throw NotFoundException.getNotFoundInstance();
        }
        return arrayList.toArray(new Result[arrayList.size()]);
    }

    private void doDecodeMultiple(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map, List<Result> list, int n, int n2, int n3) {
        Result result;
        if (n3 > 4) {
            return;
        }
        try {
            result = this.delegate.decode(binaryBitmap, map);
        }
        catch (ReaderException readerException) {
            return;
        }
        boolean bl = false;
        ResultPoint[] resultPointArray = list.iterator();
        while (resultPointArray.hasNext()) {
            Result result2 = resultPointArray.next();
            if (!result2.getText().equals(result.getText())) continue;
            bl = true;
            break;
        }
        if (!bl) {
            list.add(GenericMultipleBarcodeReader.translateResultPoints(result, n, n2));
        }
        if ((resultPointArray = result.getResultPoints()) == null || resultPointArray.length == 0) {
            return;
        }
        int n4 = binaryBitmap.getWidth();
        int n5 = binaryBitmap.getHeight();
        float f = n4;
        float f2 = n5;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (ResultPoint resultPoint : resultPointArray) {
            float f5 = resultPoint.getX();
            float f6 = resultPoint.getY();
            if (f5 < f) {
                f = f5;
            }
            if (f6 < f2) {
                f2 = f6;
            }
            if (f5 > f3) {
                f3 = f5;
            }
            if (!(f6 > f4)) continue;
            f4 = f6;
        }
        if (f > 100.0f) {
            this.doDecodeMultiple(binaryBitmap.crop(0, 0, (int)f, n5), map, list, n, n2, n3 + 1);
        }
        if (f2 > 100.0f) {
            this.doDecodeMultiple(binaryBitmap.crop(0, 0, n4, (int)f2), map, list, n, n2, n3 + 1);
        }
        if (f3 < (float)(n4 - 100)) {
            this.doDecodeMultiple(binaryBitmap.crop((int)f3, 0, n4 - (int)f3, n5), map, list, n + (int)f3, n2, n3 + 1);
        }
        if (f4 < (float)(n5 - 100)) {
            this.doDecodeMultiple(binaryBitmap.crop(0, (int)f4, n4, n5 - (int)f4), map, list, n, n2 + (int)f4, n3 + 1);
        }
    }

    private static Result translateResultPoints(Result result, int n, int n2) {
        ResultPoint[] resultPointArray = result.getResultPoints();
        if (resultPointArray == null) {
            return result;
        }
        ResultPoint[] resultPointArray2 = new ResultPoint[resultPointArray.length];
        for (int i = 0; i < resultPointArray.length; ++i) {
            ResultPoint resultPoint = resultPointArray[i];
            resultPointArray2[i] = new ResultPoint(resultPoint.getX() + (float)n, resultPoint.getY() + (float)n2);
        }
        Result result2 = new Result(result.getText(), result.getRawBytes(), resultPointArray2, result.getBarcodeFormat());
        result2.putAllMetadata(result.getResultMetadata());
        return result2;
    }
}

