/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.multi.qrcode.detector;

import com.google.zxing.DecodeHintType;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.detector.FinderPattern;
import com.google.zxing.qrcode.detector.FinderPatternFinder;
import com.google.zxing.qrcode.detector.FinderPatternInfo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

final class MultiFinderPatternFinder
extends FinderPatternFinder {
    private static final FinderPatternInfo[] EMPTY_RESULT_ARRAY = new FinderPatternInfo[0];
    private static final float MAX_MODULE_COUNT_PER_EDGE = 180.0f;
    private static final float MIN_MODULE_COUNT_PER_EDGE = 9.0f;
    private static final float DIFF_MODSIZE_CUTOFF_PERCENT = 0.05f;
    private static final float DIFF_MODSIZE_CUTOFF = 0.5f;

    MultiFinderPatternFinder(BitMatrix bitMatrix) {
        super(bitMatrix);
    }

    MultiFinderPatternFinder(BitMatrix bitMatrix, ResultPointCallback resultPointCallback) {
        super(bitMatrix, resultPointCallback);
    }

    private FinderPattern[][] selectMutipleBestPatterns() throws NotFoundException {
        List<FinderPattern> list = this.getPossibleCenters();
        int n = list.size();
        if (n < 3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n == 3) {
            return new FinderPattern[][]{{list.get(0), list.get(1), list.get(2)}};
        }
        Collections.sort(list, new ModuleSizeComparator());
        ArrayList<ResultPoint[]> arrayList = new ArrayList<ResultPoint[]>();
        block0: for (int i = 0; i < n - 2; ++i) {
            FinderPattern finderPattern = list.get(i);
            if (finderPattern == null) continue;
            block1: for (int j = i + 1; j < n - 1; ++j) {
                FinderPattern finderPattern2 = list.get(j);
                if (finderPattern2 == null) continue;
                float f = (finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize()) / Math.min(finderPattern.getEstimatedModuleSize(), finderPattern2.getEstimatedModuleSize());
                float f2 = Math.abs(finderPattern.getEstimatedModuleSize() - finderPattern2.getEstimatedModuleSize());
                if (f2 > 0.5f && f >= 0.05f) continue block0;
                for (int k = j + 1; k < n; ++k) {
                    float f3;
                    float f4;
                    float f5;
                    FinderPattern finderPattern3 = list.get(k);
                    if (finderPattern3 == null) continue;
                    float f6 = (finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize()) / Math.min(finderPattern2.getEstimatedModuleSize(), finderPattern3.getEstimatedModuleSize());
                    float f7 = Math.abs(finderPattern2.getEstimatedModuleSize() - finderPattern3.getEstimatedModuleSize());
                    if (f7 > 0.5f && f6 >= 0.05f) continue block1;
                    ResultPoint[] resultPointArray = new FinderPattern[]{finderPattern, finderPattern2, finderPattern3};
                    ResultPoint.orderBestPatterns(resultPointArray);
                    FinderPatternInfo finderPatternInfo = new FinderPatternInfo((FinderPattern[])resultPointArray);
                    float f8 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getBottomLeft());
                    float f9 = ResultPoint.distance(finderPatternInfo.getTopRight(), finderPatternInfo.getBottomLeft());
                    float f10 = ResultPoint.distance(finderPatternInfo.getTopLeft(), finderPatternInfo.getTopRight());
                    float f11 = (f8 + f10) / (finderPattern.getEstimatedModuleSize() * 2.0f);
                    if (f11 > 180.0f || f11 < 9.0f || (f5 = Math.abs((f8 - f10) / Math.min(f8, f10))) >= 0.1f || (f4 = Math.abs((f9 - (f3 = (float)Math.sqrt(f8 * f8 + f10 * f10))) / Math.min(f9, f3))) >= 0.1f) continue;
                    arrayList.add(resultPointArray);
                }
            }
        }
        if (!arrayList.isEmpty()) {
            return (FinderPattern[][])arrayList.toArray((T[])new FinderPattern[arrayList.size()][]);
        }
        throw NotFoundException.getNotFoundInstance();
    }

    public FinderPatternInfo[] findMulti(Map<DecodeHintType, ?> map) throws NotFoundException {
        boolean bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
        BitMatrix bitMatrix = this.getImage();
        int n = bitMatrix.getHeight();
        int n2 = bitMatrix.getWidth();
        int n3 = (int)((float)n / 228.0f * 3.0f);
        if (n3 < 3 || bl) {
            n3 = 3;
        }
        int[] nArray = new int[5];
        for (int i = n3 - 1; i < n; i += n3) {
            nArray[0] = 0;
            nArray[1] = 0;
            nArray[2] = 0;
            nArray[3] = 0;
            nArray[4] = 0;
            int n4 = 0;
            for (int j = 0; j < n2; ++j) {
                if (bitMatrix.get(j, i)) {
                    if (n4 & true) {
                        // empty if block
                    }
                    int n5 = ++n4;
                    nArray[n5] = nArray[n5] + 1;
                    continue;
                }
                if (!(n4 & true)) {
                    if (n4 == 4) {
                        if (MultiFinderPatternFinder.foundPatternCross(nArray) && this.handlePossibleCenter(nArray, i, j)) {
                            n4 = 0;
                            nArray[0] = 0;
                            nArray[1] = 0;
                            nArray[2] = 0;
                            nArray[3] = 0;
                            nArray[4] = 0;
                            continue;
                        }
                        nArray[0] = nArray[2];
                        nArray[1] = nArray[3];
                        nArray[2] = nArray[4];
                        nArray[3] = 1;
                        nArray[4] = 0;
                        n4 = 3;
                        continue;
                    }
                    int n6 = ++n4;
                    nArray[n6] = nArray[n6] + 1;
                    continue;
                }
                int n7 = n4;
                nArray[n7] = nArray[n7] + 1;
            }
            if (!MultiFinderPatternFinder.foundPatternCross(nArray)) continue;
            this.handlePossibleCenter(nArray, i, n2);
        }
        FinderPattern[][] finderPatternArray = this.selectMutipleBestPatterns();
        ArrayList<FinderPatternInfo> arrayList = new ArrayList<FinderPatternInfo>();
        for (ResultPoint[] resultPointArray : finderPatternArray) {
            ResultPoint.orderBestPatterns(resultPointArray);
            arrayList.add(new FinderPatternInfo((FinderPattern[])resultPointArray));
        }
        if (arrayList.isEmpty()) {
            return EMPTY_RESULT_ARRAY;
        }
        return arrayList.toArray(new FinderPatternInfo[arrayList.size()]);
    }

    private static final class ModuleSizeComparator
    implements Comparator<FinderPattern>,
    Serializable {
        private static final long serialVersionUID = 588107211708956463L;

        private ModuleSizeComparator() {
        }

        @Override
        public int compare(FinderPattern finderPattern, FinderPattern finderPattern2) {
            float f = finderPattern2.getEstimatedModuleSize() - finderPattern.getEstimatedModuleSize();
            return (double)f < 0.0 ? -1 : ((double)f > 0.0 ? 1 : 0);
        }
    }
}

