/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.oned.CodaBarReader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Arrays;

public final class CodaBarWriter
extends OneDimensionalCodeWriter {
    private static final char[] START_END_CHARS = new char[]{'A', 'B', 'C', 'D'};
    private static final char[] ALT_START_END_CHARS = new char[]{'T', 'N', '*', 'E'};

    @Override
    public boolean[] encode(String string) {
        boolean bl;
        if (string.length() < 2) {
            throw new IllegalArgumentException("Codabar should start/end with start/stop symbols");
        }
        char c = Character.toUpperCase(string.charAt(0));
        char c2 = Character.toUpperCase(string.charAt(string.length() - 1));
        boolean bl2 = CodaBarReader.arrayContains(START_END_CHARS, c) && CodaBarReader.arrayContains(START_END_CHARS, c2);
        boolean bl3 = bl = CodaBarReader.arrayContains(ALT_START_END_CHARS, c) && CodaBarReader.arrayContains(ALT_START_END_CHARS, c2);
        if (!bl2 && !bl) {
            throw new IllegalArgumentException("Codabar should start/end with " + Arrays.toString(START_END_CHARS) + ", or start/end with " + Arrays.toString(ALT_START_END_CHARS));
        }
        int n = 20;
        char[] cArray = new char[]{'/', ':', '+', '.'};
        for (int i = 1; i < string.length() - 1; ++i) {
            if (Character.isDigit(string.charAt(i)) || string.charAt(i) == '-' || string.charAt(i) == '$') {
                n += 9;
                continue;
            }
            if (CodaBarReader.arrayContains(cArray, string.charAt(i))) {
                n += 10;
                continue;
            }
            throw new IllegalArgumentException("Cannot encode : '" + string.charAt(i) + "'");
        }
        boolean[] blArray = new boolean[n += string.length() - 1];
        int n2 = 0;
        for (int i = 0; i < string.length(); ++i) {
            int n3;
            char c3 = Character.toUpperCase(string.charAt(i));
            if (i == string.length() - 1) {
                switch (c3) {
                    case 'T': {
                        c3 = 'A';
                        break;
                    }
                    case 'N': {
                        c3 = 'B';
                        break;
                    }
                    case '*': {
                        c3 = 'C';
                        break;
                    }
                    case 'E': {
                        c3 = 'D';
                    }
                }
            }
            int n4 = 0;
            for (n3 = 0; n3 < CodaBarReader.ALPHABET.length; ++n3) {
                if (c3 != CodaBarReader.ALPHABET[n3]) continue;
                n4 = CodaBarReader.CHARACTER_ENCODINGS[n3];
                break;
            }
            n3 = 1;
            int n5 = 0;
            int n6 = 0;
            while (n6 < 7) {
                blArray[n2] = n3;
                ++n2;
                if ((n4 >> 6 - n6 & 1) == 0 || n5 == 1) {
                    n3 = n3 == 0 ? 1 : 0;
                    ++n6;
                    n5 = 0;
                    continue;
                }
                ++n5;
            }
            if (i >= string.length() - 1) continue;
            blArray[n2] = false;
            ++n2;
        }
        return blArray;
    }
}

