/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.ArrayList;
import java.util.Map;

public final class Code128Writer
extends OneDimensionalCodeWriter {
    private static final int CODE_START_B = 104;
    private static final int CODE_START_C = 105;
    private static final int CODE_CODE_B = 100;
    private static final int CODE_CODE_C = 99;
    private static final int CODE_STOP = 106;
    private static final char ESCAPE_FNC_1 = '\u00f1';
    private static final char ESCAPE_FNC_2 = '\u00f2';
    private static final char ESCAPE_FNC_3 = '\u00f3';
    private static final char ESCAPE_FNC_4 = '\u00f4';
    private static final int CODE_FNC_1 = 102;
    private static final int CODE_FNC_2 = 97;
    private static final int CODE_FNC_3 = 96;
    private static final int CODE_FNC_4_B = 100;

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.CODE_128) {
            throw new IllegalArgumentException("Can only encode CODE_128, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2;
        int n3 = string.length();
        if (n3 < 1 || n3 > 80) {
            throw new IllegalArgumentException("Contents length should be between 1 and 80 characters, but got " + n3);
        }
        block9: for (int i = 0; i < n3; ++i) {
            n2 = string.charAt(i);
            if (n2 >= 32 && n2 <= 126) continue;
            switch (n2) {
                case 241: 
                case 242: 
                case 243: 
                case 244: {
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("Bad character in input: " + (char)n2);
                }
            }
        }
        ArrayList<int[]> arrayList = new ArrayList<int[]>();
        n2 = 0;
        int n4 = 1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            int n7;
            n = n5 == 99 ? 2 : 4;
            int n8 = Code128Writer.isDigits(string, n6, n) ? 99 : 100;
            if (n8 == n5) {
                if (n5 == 100) {
                    n7 = string.charAt(n6) - 32;
                    ++n6;
                } else {
                    switch (string.charAt(n6)) {
                        case '\u00f1': {
                            n7 = 102;
                            ++n6;
                            break;
                        }
                        case '\u00f2': {
                            n7 = 97;
                            ++n6;
                            break;
                        }
                        case '\u00f3': {
                            n7 = 96;
                            ++n6;
                            break;
                        }
                        case '\u00f4': {
                            n7 = 100;
                            ++n6;
                            break;
                        }
                        default: {
                            n7 = Integer.parseInt(string.substring(n6, n6 + 2));
                            n6 += 2;
                            break;
                        }
                    }
                }
            } else {
                n7 = n5 == 0 ? (n8 == 100 ? 104 : 105) : n8;
                n5 = n8;
            }
            arrayList.add(Code128Reader.CODE_PATTERNS[n7]);
            n2 += n7 * n4;
            if (n6 == 0) continue;
            ++n4;
        }
        arrayList.add(Code128Reader.CODE_PATTERNS[n2 %= 103]);
        arrayList.add(Code128Reader.CODE_PATTERNS[106]);
        n = 0;
        for (int[] nArray : arrayList) {
            for (int n9 : nArray) {
                n += n9;
            }
        }
        Object object = new boolean[n];
        int n10 = 0;
        Object object2 = arrayList.iterator();
        while (object2.hasNext()) {
            int[] nArray = (int[])object2.next();
            n10 += Code128Writer.appendPattern((boolean[])object, n10, nArray, true);
        }
        return object;
    }

    private static boolean isDigits(CharSequence charSequence, int n, int n2) {
        int n3 = n + n2;
        int n4 = charSequence.length();
        for (int i = n; i < n3 && i < n4; ++i) {
            char c = charSequence.charAt(i);
            if (c >= '0' && c <= '9') continue;
            if (c != '\u00f1') {
                return false;
            }
            ++n3;
        }
        return n3 <= n4;
    }
}

