/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code39Reader;
import com.google.zxing.oned.OneDimensionalCodeWriter;
import java.util.Map;

public final class Code39Writer
extends OneDimensionalCodeWriter {
    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat != BarcodeFormat.CODE_39) {
            throw new IllegalArgumentException("Can only encode CODE_39, but got " + barcodeFormat);
        }
        return super.encode(string, barcodeFormat, n, n2, map);
    }

    @Override
    public boolean[] encode(String string) {
        int n;
        int n2 = string.length();
        if (n2 > 80) {
            throw new IllegalArgumentException("Requested contents should be less than 80 digits long, but got " + n2);
        }
        int[] nArray = new int[9];
        int n3 = 25 + n2;
        for (int i = 0; i < n2; ++i) {
            n = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(i));
            if (n < 0) {
                throw new IllegalArgumentException("Bad contents: " + string);
            }
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n], nArray);
            for (int n4 : nArray) {
                n3 += n4;
            }
        }
        boolean[] blArray = new boolean[n3];
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        n = Code39Writer.appendPattern(blArray, 0, nArray, true);
        int[] nArray2 = new int[]{1};
        n += Code39Writer.appendPattern(blArray, n, nArray2, false);
        for (int i = n2 - 1; i >= 0; --i) {
            int n5 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. *$/+%".indexOf(string.charAt(i));
            Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[n5], nArray);
            n += Code39Writer.appendPattern(blArray, n, nArray, true);
            n += Code39Writer.appendPattern(blArray, n, nArray2, false);
        }
        Code39Writer.toIntArray(Code39Reader.CHARACTER_ENCODINGS[39], nArray);
        n += Code39Writer.appendPattern(blArray, n, nArray, true);
        return blArray;
    }

    private static void toIntArray(int n, int[] nArray) {
        for (int i = 0; i < 9; ++i) {
            int n2 = n & 1 << i;
            nArray[i] = n2 == 0 ? 1 : 2;
        }
    }
}

